include "QCSP-Instance.dfy"

module Existential_Closure{
  import opened Utils 
  import opened from_QCSP_Instance = QCSP_Instance`Lemmas_for_Existential_Closure
  export Lemmas_for_PS_Correctness 
         provides Utils, from_QCSP_Instance, 
		          ExistsClose_Forall_Lemma, ExistsClose_ExtVal_Lemma, ExistsProject_Lemma, 
		          ExistsClose_Distr_And_Lemma, ExistsClose_Exists_Commutes_Lemma,
		          ExistsClose_Sum_Lemma, ExistsCloseSem_Lemma	
		 reveals ExistsClose


function ExistsClosure(alpha:Formula):Formula
	ensures sentence(ExistsClosure(alpha))
{
ExistsClose(freeVar(alpha),alpha)
}

function ExistsClose(X:set<Name>, alpha:Formula):Formula
	ensures freeVar(ExistsClose(X,alpha)) == freeVar(alpha)-X
	ensures forall S :: wfFormula(S,alpha) ==> wfFormula(S,ExistsClose(X,alpha)) 
{
if |X| == 0 then alpha else var x :| x in X;
						    Exists(x,ExistsClose(X-{x},alpha))
}

//antes ExistsClose_Comm_Lemma
lemma ExistsClose_Exists_Commutes_Lemma<T>(B:Structure<T>, f:Valuation<T>, y: Name, X:set<Name>, alpha:Formula)
	requires wfStructure(B) && wfFormula(B.Sig, alpha) && f.Values <= B.Dom
	ensures  Models(B, f, ExistsClose(X, Exists(y, alpha))) 
	         <==> Models(B, f, Exists(y, ExistsClose(X, alpha)))
	decreases X
{
if |X| > 0
	{
	var x :| x in X && ( ExistsClose(X, Exists(y, alpha)) 
						  == Exists(x, ExistsClose(X-{x}, Exists(y, alpha))) );
	var v :| v in B.Dom && ( Models(B, f[x:=v], ExistsClose(X-{x}, Exists(y, alpha)))
							 <==> Models(B, f, ExistsClose(X, Exists(y, alpha))) );
	var f' := f[x:=v];
	assert f'.Values <= f.Values + {v} ;
	assert f'.Values <= B.Dom;
	calc {
		 Models(B, f, ExistsClose(X, Exists(y, alpha)));
		   { ExistsClose_Exists_Commutes_Lemma(B, f[x:=v], y, X-{x}, alpha); } 
		 Models(B, f[x:=v], Exists(y, ExistsClose(X-{x}, alpha)));
		 Models(B, f, Exists(x, Exists(y, ExistsClose(X-{x}, alpha))));
		   { 
		   if Models(B, f, Exists(x, Exists(y, ExistsClose(X-{x}, alpha))))
			  { Exists_Commutes_Lemma(x, y, ExistsClose(X-{x}, alpha), f, B); }
		   if Models(B, f, Exists(y, Exists(x, ExistsClose(X-{x}, alpha))))
			  { Exists_Commutes_Lemma(y, x, ExistsClose(X-{x}, alpha), f, B); }
		   }
		 Models(B, f, Exists(y, Exists(x, ExistsClose(X-{x}, alpha))));
		 Models(B, f, Exists(y, ExistsClose(X, alpha)));
		 }				
	}
}

// antes AddOneExists_Lemma
// antes ExistsClosePlusOne_Lemma
lemma ExistsClosePlusVar_Lemma<T>(B:Structure<T>, f:Valuation<T>, y:Name, X:set<Name>, alpha:Formula)
	requires wfStructure(B) && wfFormula(B.Sig, alpha) && f.Values <= B.Dom
	requires y !in X 
	ensures Models(B, f, ExistsClose(X+{y}, alpha)) 
			<==> Models(B, f, Exists(y, ExistsClose(X, alpha)))	
	decreases X 
{
var Y := X + {y};
var x :| x in Y && ExistsClose(Y, alpha) == Exists(x, ExistsClose(Y-{x}, alpha));
if x != y { 
	var Z := X-{x};								
	calc {
	     Models(B, f, ExistsClose(Y, alpha));
		 Models(B, f, Exists(x, ExistsClose(Y-{x}, alpha)));
		   { assert Y - {x} == Z + {y}; }
		 Models(B, f, Exists(x, ExistsClose(Z + {y}, alpha)));
		 exists v :: v in B.Dom && Models(B, f[x:=v], ExistsClose(Z+{y}, alpha));
		   { forall v | v in B.Dom { ExistsClosePlusVar_Lemma(B, f[x:=v],y, Z, alpha); } } 
		 exists v :: v in B.Dom && Models(B, f[x:=v], Exists(y, ExistsClose(Z, alpha)));
		 Models(B, f, Exists(x, Exists(y, ExistsClose(Z, alpha))));
		   { 
		   if Models(B, f, Exists(x, Exists(y, ExistsClose(Z, alpha))))
		      { Exists_Commutes_Lemma(x, y, ExistsClose(Z,alpha), f, B); }
		   if Models(B, f, Exists(y, Exists(x, ExistsClose(Z, alpha))))
		      { Exists_Commutes_Lemma(y, x, ExistsClose(Z,alpha), f, B); }
		   }
		 Models(B, f, Exists(y, Exists(x, ExistsClose(Z, alpha))));
		 exists v :: v in B.Dom && Models(B, f[y:=v], Exists(x, ExistsClose(Z, alpha)));
		   { forall v | v in B.Dom { ExistsClosePlusVar_Lemma(B, f[y:=v], x, Z, alpha); }}
		 exists v :: v in B.Dom && Models(B, f[y:=v], ExistsClose(Z+{x}, alpha));
		   { assert Z+{x} == X; }
		 Models(B, f, Exists(y, ExistsClose(X, alpha)));
		 }
	}
}

//antes ExistsClose_Lemma
//antes ExistsCloseMinusOne_Lemma
lemma ExistsClose_Lemma<T>(B:Structure<T>, f:Valuation<T>, x:Name, X:set<Name>, alpha:Formula)
	requires wfStructure(B) && wfFormula(B.Sig, alpha) && f.Values <= B.Dom
	requires x in X 
	ensures Models(B, f, Exists(x, ExistsClose(X-{x}, alpha))) 
	        <==> Models(B, f, ExistsClose(X, alpha))
{
ExistsClosePlusVar_Lemma(B, f, x, X-{x}, alpha);
assert X == (X-{x})+{x};
}

//antes ExistsCloseIntro_Lemma
lemma ExistsClose_ExtVal_Lemma<T>(B:Structure<T>, f:Valuation<T>, W:seq<Name>, V:seq<T>, X:set<Name>, alpha:Formula)
	  requires wfStructure(B) && wfFormula(B.Sig, alpha) && f.Values <= B.Dom 
	  requires noDups(W) && |W| == |V| == |X| && setOf(V) <= B.Dom && X == setOf(W) 
	  requires extVal(f,W,V).Values <= B.Dom && Models(B, extVal(f,W,V), alpha)
	  ensures wfFormula(B.Sig, ExistsClose(X, alpha))
	  ensures Models(B, f, ExistsClose(X, alpha)) 
	  decreases X
{
if |X| > 0 {
	 var z :| z in X && ExistsClose(X, alpha) == Exists(z, ExistsClose(X-{z}, alpha));
	 var i :| 0 <= i < |W| && W[i] == z;
	 var W' := W[..i] + W[i+1..];
	 var V' := V[..i] + V[i+1..];
	 var X1 := setOf(W[..i]);
	 var X2 := setOf(W[i+1..]);
	 // assert X1 + X2 == X - {z} ;
	 extValOrder_Lemma(i,W,V,f);
	 assert noDups(W');
	 assert extVal(f[z:=V[i]], W', V') == extVal(f, W, V);	
	 assert Models(B,extVal(f[z:=V[i]],W',V'),alpha);
	 assert X-{z} == setOf(W');
	 ExistsClose_ExtVal_Lemma(B, f[z:=V[i]], W', V', X-{z}, alpha); 
	 assert Models(B,f[z:=V[i]],ExistsClose(X-{z},alpha));
	 //extValDomRange_Lemma(f,W,V);
	 if X == {z}  { 
	    assert ExistsClose(X-{z},alpha) == alpha;
		//assert wfModel(B,f[z:=V[i]],alpha);
		assert Models(B,f[z:=V[i]],alpha);
		assert V[i] in B.Dom;
		assert exists v:: v == V[i] && v in B.Dom && Models(B,f[z:=v],alpha);
		assert f[z:=V[i]].Values <= f.Values + {V[i]} <= B.Dom;
	    assert Models(B,f,ExistsClose({z},alpha)); 
	 } else { 
	    assert f[z:=V[i]] == extVal(f,[z],[V[i]]);
		ExistsClose_ExtVal_Lemma(B, f, [z],[V[i]],{z},ExistsClose(X-{z},alpha));
		// assert Models(B,f,Exists(z,ExistsClose(X-{z},alpha)));
	    ExistsClose_Lemma(B, f, z, X, alpha);
		// assert Models(B,f,ExistsClose(X,alpha));
	  }
}
}

lemma ExistsProject_Lemma<T>(B:Structure<T>, f:Valuation<T>, U:set<Name>, alpha:Formula)
	requires wfStructure(B) && wfFormula(B.Sig, alpha) && f.Values <= B.Dom
	requires U <= f.Keys 
	requires wfFormula(B.Sig,ExistsClose(freeVar(alpha)-f.Keys, alpha))
	requires Models(B,f,ExistsClose(freeVar(alpha)-f.Keys, alpha))
	ensures wfFormula(B.Sig,ExistsClose(freeVar(alpha)-U,alpha))
	ensures Models(B,projectVal(f,U),ExistsClose(freeVar(alpha)-U,alpha))
	decreases f.Keys-U
{
if f.Keys == U {
		assert projectVal(f,f.Keys) == f;
} else	{
		var x:| x in f.Keys && x !in U;
		ExistsProject_Lemma(B, f, U+{x}, alpha);
		assert Models(B,projectVal(f,U+{x}),ExistsClose(freeVar(alpha)-(U+{x}),alpha));
		assert projectVal(f,U+{x}) == projectVal(f,U)[x:=f[x]];
        assert Models(B, projectVal(f,U)[x:=f[x]],ExistsClose(freeVar(alpha)-(U+{x}),alpha));
		assert f[x] in B.Dom;
		assert Models(B, projectVal(f,U),Exists(x, ExistsClose(freeVar(alpha)-(U+{x}),alpha)));
		assert freeVar(alpha)-(U+{x}) == (freeVar(alpha)-U)-{x};
		assert Models(B, projectVal(f,U),Exists(x, ExistsClose((freeVar(alpha)-U)-{x},alpha)));
        if x in freeVar(alpha) {
				ExistsClose_Lemma(B, projectVal(f,U), x, freeVar(alpha)-U, alpha);
		} else	{ // x !in freeVar(alpha)
				assert 	(freeVar(alpha)-U)-{x} == freeVar(alpha)-U;
				assert Models(B, projectVal(f,U),Exists(x, ExistsClose((freeVar(alpha)-U),alpha)));
				NoFreeVarInExists_Lemma(B, projectVal(f,U), x, ExistsClose((freeVar(alpha)-U),alpha));
				}
		}
}

//antes ExistsDistributive_Lemma
lemma ExistsClose_Distr_And_Lemma<T>(B:Structure<T>, f:Valuation<T>, W:set<Name>, phi:Formula)
	requires wfStructure(B) && wfFormula(B.Sig,phi) && f.Values <= B.Dom 
	requires phi.And?
	requires Models(B,f, ExistsClose(W,phi))  
	ensures wfFormula(B.Sig,ExistsClose(W*freeVar(phi.0),phi.0))
	ensures wfFormula(B.Sig,ExistsClose(W*freeVar(phi.1),phi.1))
	ensures Models(B, f, ExistsClose(W*freeVar(phi.0), phi.0))
	ensures Models(B, f, ExistsClose(W*freeVar(phi.1), phi.1)) 
	decreases W
{
if W != {}
    {
    var x:| x in W ;
    ExistsClose_Lemma(B, f, x, W, phi);
    var a:| a in B.Dom && Models(B,f[x:=a],ExistsClose(W-{x},phi));
	assert f[x:=a].Values <= B.Dom;
    ExistsClose_Distr_And_Lemma(B,f[x:=a],W-{x},phi);
    //assert Models(B, f[x:=a], ExistsClose((W-{x})*freeVar(phi.0), phi.0));
    //assert Models(B, f[x:=a], ExistsClose((W-{x})*freeVar(phi.1), phi.1));
    //assert (W-{x})*freeVar(phi.0) <= freeVar(phi.0);
    //assert (W-{x})*freeVar(phi.1) <= freeVar(phi.1);
    assert Models(B, f, Exists(x, ExistsClose((W-{x})*freeVar(phi.0), phi.0)));
    assert Models(B, f, Exists(x,ExistsClose((W-{x})*freeVar(phi.1), phi.1)));
    if x !in freeVar(phi.0) {
        NoFreeVarInExists_Lemma(B,f, x, ExistsClose((W-{x})*freeVar(phi.0), phi.0));
        assert W*freeVar(phi.0) == (W-{x})*freeVar(phi.0);
        assert Models(B, f, ExistsClose(W*freeVar(phi.0), phi.0));
    } else {
        assert (W-{x})*freeVar(phi.0) == W*freeVar(phi.0)-{x};
        assert  Models(B, f, Exists(x,ExistsClose((W*freeVar(phi.0))-{x}, phi.0)));
        ExistsClose_Lemma(B, f, x, W*freeVar(phi.0), phi.0);
        assert Models(B, f, ExistsClose(W*freeVar(phi.0), phi.0));
    }
    if x !in freeVar(phi.1) {
        NoFreeVarInExists_Lemma(B,f, x, ExistsClose((W-{x})*freeVar(phi.1), phi.1));
        assert W*freeVar(phi.1) == (W-{x})*freeVar(phi.1);
        assert Models(B, f, ExistsClose(W*freeVar(phi.1), phi.1));
    } else {
        assert (W-{x})*freeVar(phi.1) == W*freeVar(phi.1)-{x};
        assert  Models(B, f, Exists(x,ExistsClose((W*freeVar(phi.1))-{x}, phi.1)));
        ExistsClose_Lemma(B, f, x, W*freeVar(phi.1), phi.1);
        assert Models(B, f, ExistsClose(W*freeVar(phi.1), phi.1));
    }
    }
}

// antes ExistsCloseEval_Lemma
lemma ExistsCloseSem_Lemma<T>(B:Structure<T>, f:Valuation<T>, X:set<Name>, alpha:Formula)
	requires wfStructure(B) && wfFormula(B.Sig, alpha) && f.Values <= B.Dom
	requires wfFormula(B.Sig, ExistsClose(X, alpha)) && X !! f.Keys
	requires Models(B, f, ExistsClose(X, alpha)) 
	ensures exists W,V :: setOf(V) <= B.Dom   && |W| == |V| == |X| && setOf(W) == X 
	                     && noDups(W) && setOf(W) !! f.Keys
						 && extVal(f,W,V).Values <= B.Dom
						 && Models(B, extVal(f,W,V), alpha)
	decreases X
{
if |X| > 0 
    {
     var z :| z in X && ExistsClose(X, alpha) 
	                    == Exists(z, ExistsClose(X-{z}, alpha));	
	 var v :| v in B.Dom && Models(B, f[z:=v], ExistsClose(X-{z}, alpha));
	 ExistsCloseSem_Lemma(B, f[z:=v], X-{z}, alpha);	
	 var W',V' :|  setOf(V') <= B.Dom 
	               && |W'|==|V'| == |X-{z}| 
	               && setOf(W') == X-{z} 
				   && noDups(W') && setOf(W') !! f[z:=v].Keys
				   && extVal(f[z:=v],W',V').Values <= B.Dom
				   && Models(B, extVal(f[z:=v], W', V'), alpha);
	 var W, V := [z] + W', [v] + V';	
	 assert setOf(V) <= B.Dom;
	 assert |W| == |V| == |X|; 
	 assert setOf(W) == setOf(W')+{z} == (X-{z})+{z} == X; 
	 assert noDups(W);
	 assert z !in f.Keys;
	 assert setOf(W) !! f.Keys;
	 extValDomRange_Lemma(f, W, V);
	 assert extVal(f,W,V).Values <= B.Dom;
	 assert extVal(f[z:=v], W', V') == extVal(f,W,V);
	 assert Models(B, extVal(f,W,V), alpha);
	} 
}

lemma WeakerExistsClose_Lemma<T>(B:Structure<T>, h:Valuation<T>, W:set<Name>, 
                                 phi:Formula, psi:Formula)
	requires wfStructure(B) && wfFormula(B.Sig,phi) && wfFormula(B.Sig,psi) && h.Values <= B.Dom
	requires forall f:Valuation<T> :: f.Values <= B.Dom && Models(B,f,phi) ==> Models(B,f,psi)
	requires Models(B,h,ExistsClose(W,phi)) && W !! h.Keys
	ensures  wfFormula(B.Sig,ExistsClose(W,psi))
	ensures  Models(B,h,ExistsClose(W,psi))
{
ExistsCloseSem_Lemma(B, h, W, phi);
var W',V :| setOf(V) <= B.Dom 
                && |W'| == |V| == |W|  
                && setOf(W') == W
				&& noDups(W') //&& setOf(W') !! h.Keys
				&& extVal(h,W',V).Values <= B.Dom
				&& Models(B,extVal(h,W',V),phi);
ExistsClose_ExtVal_Lemma(B, h, W', V, W, psi);
}

//antes fromForallToExistsClose_Lemma
lemma ExistsClose_Forall_Lemma<T>(B:Structure<T>, h:Valuation<T>, x:Name, W:set<Name>, phi:Formula)
	requires wfStructure(B) && wfFormula(B.Sig,Forall(x,phi)) && h.Values <= B.Dom 
	requires Models(B,h,ExistsClose(W,Forall(x,phi))) && W !! h.Keys
	ensures  wfFormula(B.Sig,ExistsClose(W,Exists(x,phi)))
	ensures  Models(B,h,ExistsClose(W,Exists(x,phi)))		
{
WeakerExistsClose_Lemma(B, h, W, Forall(x,phi), Exists(x,phi));
}

lemma ExistsCloseCommutes_Lemma<T>(B:Structure<T>, f:Valuation<T>, X:set<Name>, Y:set<Name>, alpha:Formula)
	requires wfStructure(B) && wfFormula(B.Sig, alpha) && f.Values <= B.Dom 
	requires Models(B, f, ExistsClose(X, ExistsClose(Y, alpha))) && (X+Y) !! f.Keys  && X!!Y
	ensures wfFormula(B.Sig, ExistsClose(Y, ExistsClose(X, alpha))) 
	ensures Models(B, f, ExistsClose(Y, ExistsClose(X, alpha))) 
	decreases X
{
if X != {} 
    {
    var x :| x in X;
	assert x !in f.Keys;
	if X == {x} { ExistsClose_Exists_Commutes_Lemma(B,f,x,Y,alpha);
	} else {
			assert Models(B, f, ExistsClose(X, ExistsClose(Y, alpha)));
			ExistsClose_Lemma(B, f, x, X, ExistsClose(Y, alpha));
			assert Models(B, f, Exists(x,ExistsClose(X-{x}, ExistsClose(Y, alpha))));
			var v :| v in B.Dom && Models(B, f[x:=v], ExistsClose(X-{x}, ExistsClose(Y, alpha)));
			assert ((X-{x})+Y) < X+Y;
			assert ((X-{x})+Y) !! f[x:=v].Keys;
			ExistsCloseCommutes_Lemma (B, f[x:=v], X-{x}, Y, alpha);
			assert Models(B, f[x:=v], ExistsClose(Y, ExistsClose(X-{x}, alpha)));
			assert Models(B, f, ExistsClose({x},ExistsClose(Y, ExistsClose(X-{x}, alpha))));
			ExistsCloseCommutes_Lemma (B, f, {x}, Y, ExistsClose(X-{x}, alpha));
			assert Models(B, f, ExistsClose(Y,Exists(x, ExistsClose(X-{x}, alpha))));
			ExistsCloseSem_Lemma(B, f, Y, Exists(x, ExistsClose(X-{x}, alpha)));
			var W,V :| setOf(V) <= B.Dom && |W| == |V| == |Y|  && setOf(W) == Y && noDups(W) 
			       && setOf(W) !! f.Keys
				   && extVal(f,W,V).Values <= B.Dom
				   && Models(B, extVal(f,W,V), Exists(x, ExistsClose(X-{x}, alpha)));
			ExistsClose_Lemma(B, extVal(f,W,V), x, X, alpha);
			assert Models(B, extVal(f,W,V), ExistsClose(X, alpha));
			ExistsClose_ExtVal_Lemma(B, f, W, V, Y, ExistsClose(X, alpha));
			assert Models(B, f, ExistsClose(Y, ExistsClose(X, alpha)));
		    }
    }
}
   
lemma ExistsClose_Sum_Intro_Lemma<T>(B:Structure<T>, f:Valuation<T>, X:set<Name>, Y:set<Name>, alpha:Formula)
	requires wfStructure(B) && wfFormula(B.Sig, alpha) && f.Values <= B.Dom
	requires X !! Y 
	requires wfFormula(B.Sig, ExistsClose(X, ExistsClose(Y, alpha))) 
	requires Models(B, f, ExistsClose(X, ExistsClose(Y, alpha))) 
	ensures wfFormula(B.Sig, ExistsClose(X+Y, alpha))
	ensures Models(B, f, ExistsClose(X+Y, alpha))
	decreases X
{
if |X| > 0 {
	var x :| x in X && ExistsClose(X, ExistsClose(Y, alpha)) 
			           == Exists(x, ExistsClose(X-{x}, ExistsClose(Y, alpha)));
	assert Models(B, f, Exists(x, ExistsClose(X-{x}, ExistsClose(Y, alpha))));
    var v:| v in B.Dom 
		    && Models(B, f[x:=v], ExistsClose(X-{x}, ExistsClose(Y, alpha)));
	ExistsClose_Sum_Intro_Lemma(B, f[x:=v], X-{x}, Y, alpha);
	assert Models(B, f[x:=v], ExistsClose((X-{x})+Y, alpha));
	assert (X-{x})+Y == (X+Y)-{x};
	assert Models(B, f, Exists(x, ExistsClose((X+Y)-{x}, alpha)));
	ExistsClose_Lemma(B, f, x, X+Y, alpha);
	assert Models(B, f, ExistsClose(X+Y, alpha));
	}
}

lemma ExistsClose_Sum_Unfold_Lemma<T>(B:Structure<T>, f:Valuation<T>, X:set<Name>, Y:set<Name>, alpha:Formula)
	requires wfStructure(B) && wfFormula(B.Sig, alpha) && f.Values <= B.Dom
	requires X !! Y  && (X+Y) !! f.Keys
	requires wfFormula(B.Sig, ExistsClose(X+Y, alpha))
	requires Models(B, f, ExistsClose(X+Y, alpha))
	ensures wfFormula(B.Sig, ExistsClose(X, ExistsClose(Y, alpha))) 
	ensures Models(B, f, ExistsClose(X, ExistsClose(Y, alpha))) 
	decreases X+Y
{
if |X+Y| > 0 {
    var z :| z in X+Y && ExistsClose(X+Y, alpha)
			           == Exists(z, ExistsClose((X+Y)-{z}, alpha));
	assert Models(B, f, Exists(z, ExistsClose((X+Y)-{z}, alpha)));
	var v:| v in B.Dom && Models(B, f[z:=v], ExistsClose((X+Y)-{z}, alpha));
	if z in X {
	   assert (X+Y)-{z} == (X-{z})+Y;
	   assert Models(B, f[z:=v], ExistsClose((X-{z})+Y, alpha));
	   ExistsClose_Sum_Unfold_Lemma(B, f[z:=v], X-{z}, Y, alpha);
	   assert Models(B, f[z:=v], ExistsClose(X-{z}, ExistsClose(Y, alpha)));
	   assert Models(B, f, Exists(z, ExistsClose(X-{z}, ExistsClose(Y, alpha))));
	   ExistsClose_Lemma(B, f, z, X, ExistsClose(Y, alpha)); 
	   assert Models(B, f, ExistsClose(X, ExistsClose(Y, alpha)));
	} else { 
	   assert z in Y && (X+Y)-{z} == (Y-{z})+X;
	   assert Models(B, f[z:=v], ExistsClose((Y-{z})+X, alpha));
	   ExistsClose_Sum_Unfold_Lemma(B, f[z:=v], Y-{z}, X, alpha);
	   assert Models(B, f[z:=v], ExistsClose(Y-{z}, ExistsClose(X, alpha)));
	   assert Models(B, f, Exists(z, ExistsClose(Y-{z}, ExistsClose(X, alpha))));
	   ExistsClose_Lemma(B, f, z, Y, ExistsClose(X, alpha)); 
	   assert Models(B, f, ExistsClose(Y, ExistsClose(X, alpha)));
	   ExistsCloseCommutes_Lemma(B, f, Y, X, alpha);
	   assert Models(B, f, ExistsClose(X, ExistsClose(Y, alpha)));
	   }
	   }
}

lemma ExistsClose_Sum_Lemma<T>(B:Structure<T>, f:Valuation<T>, X:set<Name>, Y:set<Name>, alpha:Formula)
	requires wfStructure(B) && wfFormula(B.Sig, alpha) && f.Values <= B.Dom
	requires X !! Y  && (X+Y) !! f.Keys
	ensures wfFormula(B.Sig, ExistsClose(X, ExistsClose(Y, alpha))) 
	        && wfFormula(B.Sig, ExistsClose(X+Y, alpha))
	ensures Models(B, f, ExistsClose(X, ExistsClose(Y, alpha))) 
	        <==> Models(B, f, ExistsClose(X+Y, alpha))
	decreases X
{
if Models(B, f, ExistsClose(X, ExistsClose(Y, alpha))) 
     { ExistsClose_Sum_Intro_Lemma(B, f, X, Y, alpha); }
if Models(B, f, ExistsClose(X+Y, alpha))
     { ExistsClose_Sum_Unfold_Lemma(B, f, X, Y, alpha); }
}

}