include "Proof-System.dfy"
include "PS-Correctness.dfy"

module PS_Completeness {
	import opened Utils
	import opened QCSP_Instance`Lemmas_for_PS_Completeness
	import opened Proof_System`Lemma_and_Defs 

// Operations on Judgements 
function projection<T>(j:Judgement<T>, U:set<Name>, phi:Formula, B:Structure<T>):Judgement<T>
	requires wfJudgement(j,phi,B) 
	requires U <= j.V
	ensures wfJudgement(projection(j,U,phi,B),phi,B)
	ensures is_projection(projection(j,U,phi,B),j,phi,B)
{
J(j.i, U, (set f | f in j.F  :: projectVal(f,U)))									
}
		
function join<T>(j1:Judgement<T>, j2:Judgement<T>, phi:Formula, B:Structure<T>):Judgement<T>
	requires wfJudgement(j1,phi,B) && wfJudgement(j2,phi,B)
	requires j1.i == j2.i
	ensures wfJudgement(join(j1,j2,phi,B),phi,B)  
	ensures is_join(join(j1,j2,phi,B),j1,j2,phi,B)
{
J(j1.i, j1.V+j2.V, (set f:Valuation<T> | f in AllMaps(j1.V+j2.V, B.Dom) 
                                         && projectVal(f,j1.V) in j1.F 
										 && projectVal(f,j2.V) in j2.F))
}

function dualProjection<T>(v:Name, j:Judgement<T>, phi:Formula, B:Structure<T>): Judgement<T>
	requires wfJudgement(j,phi,B)
	requires |j.i| > 0 && j.i[..|j.i|-1] + [0] ==j.i 
	requires j.i[..|j.i|-1] in setOfIndex(phi)
	requires FoI(j.i[..|j.i|-1], phi, B.Sig).Forall? && FoI(j.i[..|j.i|-1], phi, B.Sig).x == v
	requires v in j.V 
	ensures wfJudgement(dualProjection(v, j, phi, B), phi, B)
	ensures is_dualProjection(dualProjection(v, j, phi,B),v,j,phi,B)
{
indexSubformula_Lemma(j.i[..|j.i|-1],phi, B.Sig);
J(j.i[..|j.i|-1], j.V-{v}, (set f:Valuation<T> | f in AllMaps(j.V-{v},B.Dom) 
                                                 && forall b :: b in B.Dom ==> f[v:=b] in j.F))
}

function canonical_judgement<T> (i:seq<int>,phi:Formula,B:Structure<T>):Judgement<T>
	requires wfQCSP_Instance(phi,B)
	requires i in setOfIndex(phi)
	ensures canonical_judgement(i,phi,B).i == i
	ensures canonical_judgement(i,phi,B).V == freeVar(FoI(i,phi,B.Sig))
	ensures wfJudgement(canonical_judgement(i,phi,B),phi,B)  
	decreases FoI(i,phi,B.Sig)
{
var phii := FoI(i,phi,B.Sig); 
match phii
	case Atom(R,par) => var F := (set f:Valuation<T> | f in AllMaps(setOf(par),B.Dom)	
								                        &&  HOmap(f,par) in B.I[R]);
						J(i, setOf(par), F)
	case And(phi0,phi1) =>	indexSubformula_Lemma(i,phi,B.Sig);
	                        var j0' := canonical_judgement(i+[0], phi, B);
							var j1' := canonical_judgement(i+[1], phi, B);
		 					var j0 := J(i, j0'.V, j0'.F);
							var j1 := J(i, j1'.V, j1'.F);
							join(j0, j1, phi, B)
	case Forall(x,phik) =>  indexSubformula_Lemma(i,phi,B.Sig);
	                        var j0 := canonical_judgement(i+[0],phi,B);								   
							if x in j0.V then dualProjection(x,j0,phi,B) else J(i,j0.V,j0.F)
	case Exists(x,phik) => indexSubformula_Lemma(i,phi,B.Sig);
	                       var j0:= canonical_judgement (i+[0],phi,B);
						   var jp := projection(j0,j0.V-{x},phi,B);
						   if x in j0.V then  J(i, jp.V, jp.F) else J(i,j0.V,j0.F)
}

//Sets of Valuations that are models of phi in an structure B
function setOfValModels<T> (phi:Formula, B:Structure<T>):set<Valuation<T>>
	requires wfStructure(B) && wfFormula(B.Sig,phi)
{
(set f:Valuation<T> | f in AllMaps(freeVar(phi), B.Dom) && Models(B,f,phi))
}

lemma setofValModelsAnd_Lemma<T>(phi0:Formula, phi1:Formula, B:Structure<T>)
    requires wfStructure(B) && wfFormula(B.Sig, phi0) && wfFormula(B.Sig, phi1)
   	ensures setOfValModels(And(phi0,phi1),B) ==
            (set f:Valuation<T> |  f in AllMaps(freeVar(phi0)+freeVar(phi1), B.Dom) 
	                               && projectVal(f,freeVar(phi0)) in setOfValModels(phi0,B) 
							       && projectVal(f,freeVar(phi1)) in setOfValModels(phi1,B));
{
var F := (set f:Valuation<T> |  f in AllMaps(freeVar(phi0)+freeVar(phi1), B.Dom) 
	                          && projectVal(f,freeVar(phi0)) in setOfValModels(phi0,B) 
							  && projectVal(f,freeVar(phi1)) in setOfValModels(phi1,B));
forall f:Valuation<T> | f in F ensures f in setOfValModels(And(phi0,phi1),B); 
    {
	assert projectVal(f,freeVar(phi0)) in AllMaps(freeVar(phi0),B.Dom)  
		   && projectVal(f,freeVar(phi0)).Values <= B.Dom && Models(B,projectVal(f,freeVar(phi0)),phi0)
		   && projectVal(f,freeVar(phi1)) in AllMaps(freeVar(phi1),B.Dom) 
		   && projectVal(f,freeVar(phi1)).Values <= B.Dom && Models(B,projectVal(f,freeVar(phi1)),phi1);
	ModelsAnd_Lemma(B,f,And(phi0,phi1)); 
	assert f in AllMaps(freeVar(And(phi0,phi1)), B.Dom) && f.Values <= B.Dom 
				&& Models(B,f,And(phi0,phi1));
	assert f in setOfValModels(And(phi0,phi1),B);
    }
//assert forall f:Valuation<T> :: f in F ==> f in setOfValModels(And(phi0,phi1),B); 
forall f:Valuation<T> | f in setOfValModels(And(phi0,phi1),B) ensures f in F
	{ 
	// assert f in AllMaps(freeVar(And(phi0,phi1)), B.Dom) && wfModel(B,f,And(phi0,phi1)) 
	//            && Models(B,f,And(phi0,phi1));
	ModelsAnd_Lemma(B,f,And(phi0,phi1)); 
	assert projectVal(f,freeVar(phi0)).Values <= B.Dom && Models(B,projectVal(f,freeVar(phi0)),phi0)
		   && projectVal(f,freeVar(phi1)).Values <= B.Dom && Models(B,projectVal(f,freeVar(phi1)),phi1);
	AllMaps_Correct_Lemma(projectVal(f,freeVar(phi0)),B.Dom);
	assert projectVal(f,freeVar(phi0)) in AllMaps(freeVar(phi0),B.Dom);
	assert projectVal(f,freeVar(phi0)) in setOfValModels(phi0,B);
	AllMaps_Correct_Lemma(projectVal(f,freeVar(phi1)),B.Dom);
	assert projectVal(f,freeVar(phi1)) in AllMaps(freeVar(phi1),B.Dom);
	assert projectVal(f,freeVar(phi1)) in setOfValModels(phi1,B);
	assert f in F;
	}
//assert forall f:Valuation<T> :: f in setOfValModels(And(phi0,phi1),B) ==> f in F;
}

lemma setofValModelsForall_Lemma<T>(x:Name, beta:Formula,B:Structure<T>)
    requires wfStructure(B) && wfFormula(B.Sig, Forall(x,beta)) 
	requires x in freeVar(beta)
	ensures setOfValModels(Forall(x,beta),B)
            == (set f:Valuation<T> | f in AllMaps(freeVar(beta)-{x},B.Dom) 
                                     && forall b :: b in B.Dom ==> f[x:=b] in setOfValModels(beta,B));
{	
var F := (set f:Valuation<T> | f in AllMaps(freeVar(beta)-{x},B.Dom) 
                               && forall b :: b in B.Dom ==> f[x:=b] in setOfValModels(beta,B));	
forall f:Valuation<T> | f in F
	ensures f in setOfValModels(Forall(x,beta),B);
	{ 
	assert f in AllMaps(freeVar(Forall(x,beta)), B.Dom);
	assert f.Values <= B.Dom;
	assert Models(B,f,Forall(x,beta));
	}
//assert forall f:Valuation<T>:: f in F ==> f in setOfValModels(Forall(x,beta),B);
forall f:Valuation<T>  | f in setOfValModels(Forall(x,beta),B)
	ensures f in F;
	{ 
	assert f in AllMaps(freeVar(beta)-{x}, B.Dom) && Models(B,f,Forall(x,beta));
	forall b | b in B.Dom 
		ensures f[x:=b] in setOfValModels(beta,B);
		{
		assert f[x:=b].Values <= B.Dom;
		assert Models(B, f[x:=b], beta);
		ExtMap_Lemma(f, x, b, freeVar(beta), B.Dom);
		assert f[x:=b] in AllMaps(freeVar(beta), B.Dom); 
		assert f[x:=b] in setOfValModels(beta,B);
		}
	assert forall b :: b in B.Dom ==> f[x:=b] in setOfValModels(beta,B);
	assert f in F;
	}
//assert forall f:Valuation<T>:: f in setOfValModels(Forall(x,beta),B) ==> f in F;
}

lemma setofValModelsExists_Lemma<T>(x:Name, beta:Formula,B:Structure<T>)
    requires wfStructure(B) && wfFormula(B.Sig, Exists(x,beta))
	requires x in freeVar(beta)
   	ensures setOfValModels(Exists(x,beta),B) 
	        == (set h | h in setOfValModels(beta,B) :: projectVal(h,freeVar(beta)-{x}))
{
var F := (set h | h in setOfValModels(beta,B) :: projectVal(h,freeVar(beta)-{x}));
forall f:Valuation<T> | f in setOfValModels(Exists(x,beta),B) 
	ensures f in F;
    {
	var v :| v in B.Dom && Models(B,f[x:=v],beta);
	var h := f[x:=v];
	ExtMap_Lemma(f, x, v, freeVar(beta), B.Dom);
    assert h in AllMaps(freeVar(beta), B.Dom);
	assert h in setOfValModels(beta,B);
	assert f == projectVal(h,freeVar(beta)-{x});
	assert f in F;
	}
//assert forall f:Valuation<T> :: f in setOfValModels(Exists(x,beta),B) ==> f in F;
forall f:Valuation<T> | f in F
	ensures f in setOfValModels(Exists(x,beta),B);
    {
	var h :| h in setOfValModels(beta,B) && f == projectVal(h,freeVar(beta)-{x});
	assert h in AllMaps(freeVar(beta), B.Dom);
	ProyectMap_Lemma(h, freeVar(beta)-{x}, freeVar(beta), B.Dom);
	assert f in AllMaps(freeVar(beta)-{x}, B.Dom);
	// assert Models(B,h,beta);
	ExistsModels_Lemma(B, h, x, beta);
	// assert Models(B,projectVal(h,freeVar(beta)-{x}),Exists(x,beta));
	assert Models(B,f,Exists(x,beta));
	assert f in setOfValModels(Exists(x,beta),B);
	}
//assert forall f:Valuation<T> ::  f in F ==> f in setOfValModels(Exists(x,beta),B);
}

lemma canonical_judgement_Lemma<T>(i:seq<int>, phi:Formula, B:Structure<T>)
	requires wfQCSP_Instance(phi,B)
	requires i in setOfIndex(phi)
	ensures canonical_judgement(i,phi,B).i == i
	ensures canonical_judgement(i,phi,B).V == freeVar(FoI(i,phi,B.Sig))
	ensures canonical_judgement(i,phi,B).F == setOfValModels(FoI(i,phi,B.Sig),B);
	ensures is_derivable(canonical_judgement(i,phi,B),phi,B)
	decreases FoI(i,phi,B.Sig)
{
var phii := FoI(i,phi,B.Sig);
if !phii.Atom? { indexSubformula_Lemma(i,phi,B.Sig);}
var cj := canonical_judgement(i,phi,B);
match phii																					 
  case Atom(R,par) => assert is_derivable(cj,phi,B);
  case And(phi0,phi1) 
	 => var j0' := canonical_judgement(i+[0],phi,B);
		var j1' := canonical_judgement(i+[1],phi,B);
		var j0 := J(i, j0'.V, j0'.F);
		var j1 := J(i, j1'.V, j1'.F); 
		canonical_judgement_Lemma(i+[0],phi,B);
		canonical_judgement_Lemma(i+[1],phi,B);
		setofValModelsAnd_Lemma(phi0, phi1, B);
		assert  cj.F == setOfValModels(phii,B);	
		assert is_derivable(j0,phi,B) && is_derivable(j1,phi,B); 
		assert is_derivable(cj,phi,B);						
  case Forall(x,beta) 
     => var j0 := canonical_judgement(i+[0],phi,B);
		canonical_judgement_Lemma(i+[0],phi,B);
		if x !in j0.V {
			forall f:Valuation<T> | f.Values <= B.Dom
			            { NoFreeVarInForall_Lemma(B,f,x,beta); }
			assert cj.F == setOfValModels(beta,B) == setOfValModels(Forall(x, beta), B);	
			assert is_derivable(cj,phi,B);
	    } else {
			assert cj == dualProjection(x,j0,phi,B);
			setofValModelsForall_Lemma(x, beta, B);
			assert cj.F == setOfValModels(Forall(x,beta),B);		
			assert is_derivable(cj,phi,B);
		}                      
case Exists(x,beta) 
   => var j0 := canonical_judgement (i+[0],phi,B);
	  canonical_judgement_Lemma(i+[0],phi,B);
	  if x !in j0.V {
			forall f:Valuation<T> | f.Values <= B.Dom
					{ NoFreeVarInExists_Lemma(B,f,x,beta); }
			//assert setOfValModels(beta,B) == setOfValModels(Exists(x, beta), B);	
			assert cj.F == setOfValModels(beta,B);
			assert is_derivable(cj,phi,B);
		} else { 
			var jp :=  projection(j0, j0.V-{x},phi,B);
			assert cj == J(i, jp.V, jp.F);
			assert cj.F == (set h | h in setOfValModels(beta,B) :: projectVal(h,j0.V-{x}));
			setofValModelsExists_Lemma(x,beta,B); 
			//assert  setOfValModels(Exists(x,beta),B) 
			//        == (set h | h in setOfValModels(beta,B) :: projectVal(h,j0.V-{x}));
			assert cj.F == setOfValModels(Exists(x,beta),B);           
			assert is_derivable(j0,phi,B); 
			assert is_derivable(cj,phi,B);
		}  
}

lemma completeness_Theorem<T> (phi:Formula,B:Structure<T>)
	requires wfQCSP_Instance(phi,B)
	requires !Models(B,map[],phi) 
	ensures is_derivable(J([],{},{}),phi,B) 
{
canonical_judgement_Lemma([],phi,B);
forall f:Valuation<T> 
		ensures f !in canonical_judgement([],phi,B).F;
		{ calc ==>  {
					f in canonical_judgement([],phi,B).F;
					f.Values <= B.Dom && f.Keys == {} && Models(B,f,phi);
					f.Values <= B.Dom && f == map[] && Models(B,f,phi);
					f.Values <= B.Dom && Models(B,map[],phi);
					false;
					}}
assert canonical_judgement([],phi,B).F == {};
assert is_derivable(J([],{},{}),phi,B);
}

} // End Module PS_Completeness