module Utils {
  export reveals setOf, noDups, AllMaps, Choose
         provides AllMaps_Correct_Lemma, ExtMap_Lemma, ProyectMap_Lemma, NonEmpty_AllMaps_Lemma

function method setOf<T> (s:seq<T>): set<T> 
{
set x | x in s
}

predicate noDups<T(==)>(U:seq<T>)
{
forall i,j :: 0 <= i < j < |U| ==> U[i] != U[j]
}

function AllMaps<A,B>(keys: set<A>, values: set<B>): set<map<A,B>>
    ensures forall m :: m in AllMaps(keys, values) ==> m.Keys == keys && m.Values <= values
{
if keys == {} then {map[]}
else 
    var k := Choose(keys);
    var M := AllMaps(keys - {k}, values);
    set m,v | m in M && v in values :: m[k := v]
}

function Choose<A>(s: set<A>): A
    requires s != {}
{
// By putting this expression in a function, we can use this same
// function in both AllMaps and AllMaps_Correct.  (If we used this
// Hilbert epsilon operator directly in the two places, each place
// may choose a different element, which makes the proof much harder.)
var a :| a in s; a
}

// Here is a proof that AllMaps does indeed return a set of all maps
lemma AllMaps_Correct_Lemma<A,B>(p: map<A,B>, VV: set<B>)
    requires p.Values <= VV
    ensures p in AllMaps(p.Keys, VV)
{
if p.Keys == {} {
    assert p == map[];
} else {
    var k := Choose(p.Keys);
    var M := AllMaps(p.Keys - {k}, VV);
    var S := set m,v | m in M && v in VV :: m[k := v];
    assert S == AllMaps(p.Keys, VV);

    var p' := map k' | k' in p.Keys && k' != k :: p[k'];
    assert p'.Keys == p.Keys - {k};
    assert p'.Values <= VV;
    assert p == p'[k := p[k]];

    var S' := AllMaps(p'.Keys, VV);
    AllMaps_Correct_Lemma(p', VV);

    assert p' in M && p[k] in VV;
    assert exists m,v :: m in M && v in VV && p == m[k := v];
    assert p in S;
}
}

lemma ExtMap_Lemma<A,B>(p: map<A,B>, x:A, v:B, keys:set<A>, values:set<B>)
	requires p in AllMaps(keys-{x},values)
	requires x in keys && v in values
	ensures p[x:=v] in AllMaps(keys,values)
{
assert p[x:=v].Keys == p.Keys + {x} == keys-{x}+{x} == keys;
AllMaps_Correct_Lemma(p[x:=v],values);
}

lemma ProyectMap_Lemma<A,B>(p: map<A,B>, subkeys:set<A>, keys:set<A>, values:set<B>)
	requires p in AllMaps(keys,values)
	requires subkeys <= keys
	ensures (map s | s in subkeys :: p[s]) in AllMaps(subkeys,values)
{
var p' := (map s | s in subkeys :: p[s]);
assert (map s | s in subkeys :: p[s]).Keys == subkeys;
AllMaps_Correct_Lemma(p',values);
}

lemma NonEmpty_AllMaps_Lemma<A,B>(keys:set<A>, values:set<B>)
	requires values != {}
	ensures AllMaps(keys, values) != {}
/*{
if keys != {} 
	{ 
	var k := Choose(keys);
	var M := AllMaps(keys-{k}, values);
	NonEmpty_AllMaps_Lemma(keys-{k}, values);
	assert M != {};
	var am := (set m,v | m in M && v in values :: m[k := v]);
	assert (values == {} || M == {} ) <== am == {};
	assert am != {};
    }
}*/

} //End Module Utils
