/*
 * Decompiled with CFR 0.152.
 */
package fermat;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MiCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgX;
    int orgY;
    double escalaX;
    double escalaY;
    double vA;
    double vB;
    double x;
    double xA;
    double yA;
    double xB;
    double yB;
    double tOld;
    boolean bTraza = false;
    boolean bSnell = false;
    Rectangle rectBloque = new Rectangle();
    boolean bArrastrar = false;
    int xBloque;
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBackground(Color.white);
    }

    void origenEscalas(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.escalaX = (double)(this.wAncho - 5 * this.cAncho) / 10.0;
        this.escalaY = (double)(this.wAlto - 2 * this.cAncho) / 10.0;
        this.orgX = this.wAncho / 2;
        this.orgY = this.wAlto / 2;
        this.xBloque = this.orgX + (int)(this.escalaX * this.x);
        this.rectBloque.setBounds(this.xBloque - this.cAncho / 2, this.orgY - this.cAncho / 2, this.cAncho, this.cAncho);
    }

    void setNuevo(double vA, double vB) {
        this.vA = vA;
        this.vB = vB;
        this.xB = -4.5 + (double)4 * Math.random();
        this.xA = 0.5 + (double)4 * Math.random();
        this.yB = -4.5 + (double)4 * Math.random();
        this.yA = 0.5 + (double)4 * Math.random();
        this.bTraza = false;
        this.bSnell = false;
        this.tOld = 0.0;
        this.repaint();
    }

    void setTraza() {
        this.bTraza = true;
        this.bSnell = false;
        if (this.minimo()) {
            this.bSnell = true;
        }
        this.repaint();
    }

    void sistema(Graphics g) {
        int y1;
        String texto;
        int x1 = this.orgX - (int)(this.escalaX * (double)5);
        g.setColor(Color.yellow);
        g.fillRect(x1, 0, this.wAncho, this.wAlto / 2);
        g.setColor(Color.cyan);
        g.fillRect(x1, this.wAlto / 2, this.wAncho, this.wAlto / 2);
        g.setColor(Color.black);
        g.drawLine(x1, this.orgY, this.wAncho, this.orgY);
        for (int i = -5; i <= 5; ++i) {
            x1 = this.orgX + (int)((double)i * this.escalaX);
            g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho);
            texto = String.valueOf(i);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, this.orgY + this.cAncho + this.cAlto);
            for (int j = 1; j < 10; ++j) {
                x1 = this.orgX + (int)(((double)i + (double)j / (double)10) * this.escalaX);
                g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho / 2);
                if (j != 5) continue;
                g.drawLine(x1, this.orgY, x1, this.orgY + 3 * this.cAncho / 4);
            }
        }
        x1 = this.orgX - (int)(this.escalaX * (double)5);
        g.drawLine(x1, 0, x1, this.wAlto);
        for (int i = -5; i <= 5; ++i) {
            y1 = this.orgY - (int)((double)i * this.escalaY);
            g.drawLine(x1, y1, x1 - this.cAncho, y1);
            texto = String.valueOf(i);
            g.drawString(texto, x1 - this.cAncho - g.getFontMetrics().stringWidth(texto), y1 + this.cAlto / 4);
            for (int j = 1; j < 10; ++j) {
                y1 = this.orgY - (int)(((double)i + (double)j / (double)10) * this.escalaY);
                g.drawLine(x1, y1, x1 - this.cAncho / 2, y1);
                if (j != 5) continue;
                g.drawLine(x1, y1, x1 - 3 * this.cAncho / 4, y1);
            }
        }
        g.setColor(Color.red);
        g.fillRect(this.rectBloque.x, this.rectBloque.y, this.rectBloque.width, this.rectBloque.height);
        x1 = this.orgX + (int)(this.xA * this.escalaX);
        y1 = this.orgY - (int)(this.yA * this.escalaY);
        g.setColor(Color.blue);
        int y2 = y1;
        do {
            g.drawLine(x1, y2, x1, y2 + this.cAncho / 2);
        } while ((y2 += this.cAncho) < this.orgY);
        int x2 = x1;
        do {
            g.drawLine(x2, y1, x2 - this.cAncho / 2, y1);
        } while ((x2 -= this.cAncho) > this.orgX - (int)(this.escalaX * (double)5));
        g.fillOval(x1 - this.cAncho / 2, y1 - this.cAncho / 2, this.cAncho, this.cAncho);
        x1 = this.orgX + (int)(this.xB * this.escalaX);
        y1 = this.orgY - (int)(this.yB * this.escalaY);
        g.setColor(Color.blue);
        g.fillOval(x1 - this.cAncho / 2, y1 - this.cAncho / 2, this.cAncho, this.cAncho);
        y2 = y1;
        do {
            g.drawLine(x1, y2, x1, y2 + this.cAncho / 2);
        } while ((y2 -= this.cAncho) > this.orgY);
        x2 = x1;
        do {
            g.drawLine(x2, y1, x2 - this.cAncho / 2, y1);
        } while ((x2 -= this.cAncho) > this.orgX - (int)(this.escalaX * (double)5));
        if (this.bTraza) {
            x2 = this.orgX + (int)(this.x * this.escalaX);
            g.setColor(Color.black);
            g.drawLine(x1, y1, x2, this.orgY);
            x1 = this.orgX + (int)(this.xA * this.escalaX);
            y1 = this.orgY - (int)(this.yA * this.escalaY);
            g.drawLine(x1, y1, x2, this.orgY);
        }
        if (this.bSnell) {
            x2 = this.orgX + (int)(this.x * this.escalaX);
            x1 = this.orgX + (int)(this.xA * this.escalaX);
            y1 = this.orgY - (int)(this.yA * this.escalaY);
            g.drawLine(x2, 0, x2, this.wAlto);
            g.drawString("\u00e1ngulos", this.wAncho - 12 * this.cAncho, this.wAlto - 5 * this.cAlto);
            int angulo = (int)Math.round((double)180 * Math.atan((double)(x1 - x2) / (double)(this.orgY - y1)) / Math.PI);
            g.drawArc(x2 - this.cAlto, this.orgY - this.cAlto, 2 * this.cAlto, 2 * this.cAlto, 90 - angulo, angulo);
            angulo = (int)Math.round((double)180 * Math.atan((this.xA - this.x) / this.yA) / Math.PI);
            g.drawString(String.valueOf("incidente:").concat(String.valueOf(String.valueOf(angulo))), this.wAncho - 12 * this.cAncho, this.wAlto - 4 * this.cAlto);
            x1 = this.orgX + (int)(this.xB * this.escalaX);
            y1 = this.orgY - (int)(this.yB * this.escalaY);
            angulo = (int)Math.round((double)180 * Math.atan((double)(x2 - x1) / (double)(y1 - this.orgY)) / Math.PI);
            g.drawArc(x2 - this.cAlto, this.orgY - this.cAlto, 2 * this.cAlto, 2 * this.cAlto, 270 - angulo, angulo);
            angulo = (int)Math.round((double)180 * Math.atan((this.xB - this.x) / this.yB) / Math.PI);
            g.drawString(String.valueOf("refractado:").concat(String.valueOf(String.valueOf(angulo))), this.wAncho - 12 * this.cAncho, this.wAlto - 3 * this.cAlto);
        }
        g.setColor(Color.black);
        texto = String.valueOf("x: ").concat(String.valueOf(String.valueOf((double)Math.round(this.x * (double)10) / (double)10)));
        g.drawString(texto, 5 * this.cAncho, this.cAlto);
        if (this.bTraza) {
            double tNew = this.calculaTiempo(this.x);
            g.drawString("tiempos:", 5 * this.cAncho, 3 * this.cAlto);
            texto = String.valueOf("actual   : ").concat(String.valueOf(String.valueOf((double)Math.round(tNew * (double)1000) / (double)1000)));
            g.drawString(texto, 5 * this.cAncho, 4 * this.cAlto);
            texto = String.valueOf("anterior: ").concat(String.valueOf(String.valueOf((double)Math.round(this.tOld * (double)1000) / (double)1000)));
            g.drawString(texto, 5 * this.cAncho, 5 * this.cAlto);
            this.tOld = tNew;
        }
        Font oldFont = this.getFont();
        Font fuente = new Font("Times", 1, 16);
        g.setFont(fuente);
        int alto = g.getFontMetrics().getHeight();
        int ancho = g.getFontMetrics().stringWidth("0");
        g.drawString("A", this.wAncho - 2 * ancho, this.orgY - 2 * alto);
        g.drawString("B", this.wAncho - 2 * ancho, this.orgY + 3 * alto);
        g.setFont(oldFont);
    }

    double calculaTiempo(double x) {
        double t = Math.sqrt((this.xA - x) * (this.xA - x) + this.yA * this.yA) / this.vA + Math.sqrt((this.xB - x) * (this.xB - x) + this.yB * this.yB) / this.vB;
        return t;
    }

    boolean minimo() {
        double t = this.calculaTiempo(this.x);
        double t1 = this.calculaTiempo(this.x + 0.05);
        double t2 = this.calculaTiempo(this.x - 0.05);
        return t < t1 && t < t2;
    }

    public void paint(Graphics g) {
        this.origenEscalas(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, d.width, d.height);
        this.sistema(this.gBuffer);
        g.drawImage(this.imag, 0, 0, null);
    }

    public void mousePressed(MouseEvent ev) {
        if (this.rectBloque.contains(ev.getX(), ev.getY())) {
            this.xBloque = ev.getX();
            this.bArrastrar = true;
            this.bTraza = false;
        }
    }

    public void mouseReleased(MouseEvent ev) {
        if (this.bArrastrar) {
            this.bArrastrar = false;
            this.rectBloque.x += ev.getX() - this.xBloque;
            this.x = (double)(-this.orgX + this.rectBloque.x + this.cAncho / 2) / this.escalaX;
            if (this.x < -5.0) {
                this.x = -5.0;
                this.rectBloque.x = this.orgX + (int)(this.x * this.escalaX) - this.cAncho / 2;
            }
            if (this.x > 5.0) {
                this.x = 5.0;
                this.rectBloque.x = this.orgX + (int)(this.x * this.escalaX) - this.cAncho / 2;
            }
        }
        this.xBloque = ev.getX();
        this.repaint();
    }

    public void mouseDragged(MouseEvent ev) {
        int x1 = this.orgX + (int)(5.0 * this.escalaX);
        int x2 = this.orgX + (int)(-5.0 * this.escalaX);
        if (this.bArrastrar && this.rectBloque.x + this.cAncho / 2 <= x1 && this.rectBloque.x + this.cAncho / 2 >= x2) {
            this.rectBloque.x += ev.getX() - this.xBloque;
            this.x = (double)(-this.orgX + this.rectBloque.x + this.cAncho / 2) / this.escalaX;
        }
        this.xBloque = ev.getX();
        this.repaint();
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseClicked(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseMoved(MouseEvent ev) {
    }
}

