/*
 * Decompiled with CFR 0.152.
 */
package refraccion4;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;

public class MiCanvas
extends Canvas {
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgYY;
    int orgXX;
    double escalaX;
    double escalaY;
    double y0 = 3.0;
    double c1;
    double c0;
    final double alfa = 2.303;
    final double mu_0 = 1.000233;
    final double mu_1 = 0.4584;
    double k;
    final int[] color = new int[]{255, 253, 251, 249, 244, 242, 240, 236, 234, 232, 230, 225, 223, 221, 217, 215, 213, 210, 206, 204, 202, 198, 196, 193, 191, 187, 185, 183, 179, 176, 174, 170, 168, 166, 164, 159, 157, 155, 151, 149, 147, 145, 140, 138, 136, 132, 130, 128, 125, 121, 119, 117, 113, 111, 108, 106, 102, 100, 98, 94, 91, 89, 85, 83, 81, 79, 74, 72, 70, 66, 64, 62, 60, 55, 53, 51, 47, 45, 43, 40, 36, 34, 32, 28, 26, 23, 21, 17, 15, 13, 9, 6, 4, 0};
    int indice;
    Polygon[] pol = new Polygon[5];
    int nRayo;
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas() {
        this.setBackground(Color.white);
        for (int i = 0; i < this.pol.length; ++i) {
            this.pol[i] = new Polygon();
        }
    }

    void inicio(double angulo, int altura) {
        this.y0 = (double)altura / (double)100;
        this.calculaParametros(angulo);
        for (int i = 0; i < this.pol.length; ++i) {
            this.pol[i].npoints = 0;
        }
        this.nRayo = 0;
        this.repaint();
    }

    void setNuevo(double angulo) {
        this.calculaParametros(angulo);
        ++this.nRayo;
        this.repaint();
    }

    void calculaParametros(double angulo) {
        double mu_p = Math.sqrt(1.0004660542889998 + 0.21013055999999997 * (1.0 - Math.exp(-2.303 * this.y0)));
        this.k = Math.sqrt(1.210596614289 - mu_p * mu_p * Math.sin(angulo) * Math.sin(angulo)) / 0.4584;
        double aux = this.k * Math.exp(2.303 * this.y0 / (double)2);
        this.c0 = Math.log(aux + Math.sqrt(aux * aux - 1.0));
        this.c1 = 1.0556952 * this.k / ((double)2 * mu_p * Math.sin(angulo));
    }

    void origen(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.escalaY = (double)(this.wAlto - this.cAncho - this.cAlto - this.cAncho) / 3.0;
        this.escalaX = (double)(this.wAncho - 4 * this.cAncho) / 20.0;
        this.orgXX = 4 * this.cAncho;
        this.orgYY = this.wAlto - this.cAncho - this.cAlto;
    }

    void grafica(Graphics g) {
        String texto;
        int x1;
        int y1;
        for (int i = y1 = this.orgYY - (int)(3.0 * this.escalaY); i <= this.orgYY; ++i) {
            double y = (double)(this.orgYY - i) / this.escalaY;
            int indice = this.color.length - 1 - (int)((double)(this.color.length - 1) * (this.n(y) - this.n(0.0)) / (this.n(3.0) - this.n(0.0)));
            g.setColor(new Color(255, this.color[indice], this.color[indice]));
            g.fillRect(this.orgXX, i - 1, this.wAncho - this.orgXX, 1);
        }
        g.setColor(Color.black);
        g.drawLine(this.orgXX, this.orgYY, this.wAncho, this.orgYY);
        g.drawLine(this.orgXX, 0, this.orgXX, this.wAlto);
        for (int i = 0; i <= 20; i += 2) {
            x1 = this.orgXX + (int)((double)i * this.escalaX);
            g.drawLine(x1, this.orgYY, x1, this.orgYY + this.cAncho);
            texto = String.valueOf(i);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, this.orgYY + this.cAlto + this.cAncho);
            x1 = this.orgXX + (int)((double)(i + 1) * this.escalaX);
            g.drawLine(x1, this.orgYY, x1, this.orgYY + this.cAncho);
        }
        for (int i = 0; i <= 3; ++i) {
            y1 = this.orgYY - (int)((double)i * this.escalaY);
            g.drawLine(this.orgXX, y1, this.orgXX - this.cAncho, y1);
            texto = String.valueOf((double)i);
            g.drawString(texto, this.orgXX - this.cAncho - g.getFontMetrics().stringWidth(texto), y1 + this.cAlto / 4);
            if (i == 3) break;
            for (int j = 1; j < 10; ++j) {
                y1 = this.orgYY - (int)(((double)i + (double)j / (double)10) * this.escalaY);
                g.drawLine(this.orgXX, y1, this.orgXX - this.cAncho / 2, y1);
                if (j != 5) continue;
                g.drawLine(this.orgXX - 3 * this.cAncho / 4, y1, this.orgXX, y1);
            }
        }
        g.drawString("Y", this.orgXX + this.cAncho, this.cAlto);
        g.drawString("X", this.wAncho - 3 * this.cAncho, this.orgYY - 2);
        g.drawString("Y", this.orgXX + this.cAncho, this.cAlto);
        g.drawString("X", this.wAncho - 3 * this.cAncho, this.orgYY - 2);
        g.setColor(Color.blue);
        for (double x = 0.0; x < (double)20; x += 0.1) {
            x1 = this.orgXX + (int)(x * this.escalaX);
            y1 = this.orgYY - (int)(this.f(x) * this.escalaY);
            this.pol[this.nRayo].addPoint(x1, y1);
        }
        for (int i = 0; i <= this.nRayo; ++i) {
            g.drawPolyline(this.pol[i].xpoints, this.pol[i].ypoints, this.pol[i].npoints);
        }
    }

    double f(double x) {
        double aux = -this.c1 * x + this.c0;
        double y = (double)2 * Math.log((Math.exp(aux) + Math.exp(-aux)) / ((double)2 * this.k)) / 2.303;
        return y;
    }

    double n(double y) {
        double z = 1.0004660542889998 + 0.21013055999999997 * (1.0 - Math.exp(-2.303 * y));
        return Math.sqrt(z);
    }

    public void paint(Graphics g) {
        this.origen(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, d.width, d.height);
        this.grafica(this.gBuffer);
        g.drawImage(this.imag, 0, 0, null);
    }
}

