/*
 * Decompiled with CFR 0.152.
 */
package viga4;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;

public class MiCanvas
extends Canvas {
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgY;
    int orgX;
    int escalaX;
    int escalaY;
    final double CERO = 1.0E-10;
    final double ERROR = 0.001;
    final int MAXITER = 200;
    double[] raices = new double[5];
    double q;
    double c;
    double area;
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas() {
        this.setBackground(Color.white);
        this.explorar(1.0, 50.0, 1.0);
        this.q = this.raices[0];
        this.c = (this.sinh(this.q) + Math.sin(this.q)) / (this.cosh(this.q) + Math.cos(this.q));
        this.area = this.integral(0.0, 1.0, 100);
    }

    void explorar(double xIni, double xFin, double dx) {
        int iRaiz = 0;
        double y1 = this.f(xIni);
        for (double x = xIni; x < xFin; x += dx) {
            double y2 = this.f(x + dx);
            if (Math.abs(y1) < 1.0E-10 && iRaiz < this.raices.length) {
                this.raices[iRaiz++] = x;
                y1 = y2;
                continue;
            }
            if (y1 * y2 >= 0.0) {
                y1 = y2;
                continue;
            }
            if (iRaiz < this.raices.length) {
                this.raices[iRaiz] = this.puntoMedio(x, x + dx);
                ++iRaiz;
            } else {
                return;
            }
            y1 = y2;
        }
    }

    double puntoMedio(double a, double b) {
        double m;
        double ym;
        int iter = 0;
        while (!(Math.abs(ym = this.f(m = (a + b) / (double)2)) < 1.0E-10) && !(Math.abs((a - b) / m) < 0.001)) {
            if (this.f(a) * ym < 0.0) {
                b = m;
            } else {
                a = m;
            }
            if (++iter < 200) continue;
        }
        if (iter == 200) {
            System.out.println("No se ha encontrado la ra\u00edz");
        }
        return m;
    }

    double f(double x) {
        double y = this.cosh(x) * Math.cos(x) + 1.0;
        return y;
    }

    double sinh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / (double)2;
    }

    double cosh(double x) {
        return (Math.exp(x) + Math.exp(-x)) / (double)2;
    }

    public double integral(double a, double b, int n) {
        if (n % 2 == 1) {
            ++n;
        }
        double h = (b - a) / (double)n;
        double suma = this.g(a) + this.g(b);
        for (int i = 1; i < n; i += 2) {
            suma += (double)4 * this.g(a + (double)i * h);
        }
        for (int i = 2; i < n; i += 2) {
            suma += (double)2 * this.g(a + (double)i * h);
        }
        return suma * h / (double)3;
    }

    public double g(double x) {
        return this.fOnda(x) * this.fOnda(x);
    }

    double fOnda(double x) {
        double y = this.sinh(this.q * x) - Math.sin(this.q * x) - this.c * (this.cosh(this.q * x) - Math.cos(this.q * x));
        return y;
    }

    void setModo(int iModo) {
        this.q = this.raices[iModo];
        this.c = (this.sinh(this.q) + Math.sin(this.q)) / (this.cosh(this.q) + Math.cos(this.q));
        this.area = this.integral(0.0, 1.0, 100);
        this.repaint();
    }

    void origen(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgX = 4 * this.cAncho;
        this.orgY = this.wAlto / 2;
        this.escalaX = this.wAncho - 8 * this.cAncho;
        this.escalaY = 20;
        g.setColor(Color.blue);
        g.drawLine(this.orgX, this.orgY, this.wAncho - 4 * this.cAncho, this.orgY);
    }

    void onda(Graphics g) {
        int x1 = this.orgX;
        int y1 = this.orgY;
        g.setColor(Color.blue);
        for (double x = 0.0; x < 1.0; x += 0.01) {
            int x2 = this.orgX + (int)((double)this.escalaX * x);
            int y2 = this.orgY + (int)(this.fOnda(x) * (double)this.escalaY / Math.sqrt(this.area));
            g.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
        }
        g.setColor(Color.black);
        g.fillRect(this.orgX - 2 * this.cAlto, this.orgY - 2 * this.cAlto, 2 * this.cAlto, 4 * this.cAlto);
        Font oldFont = g.getFont();
        Font fuente = new Font("Times", 1, 14);
        g.setFont(fuente);
        g.setColor(Color.black);
        g.drawString(String.valueOf("Coeficiente: ").concat(String.valueOf(String.valueOf((double)Math.round((double)100 * this.q * this.q / (Math.PI * 2)) / (double)100))), this.cAncho, g.getFontMetrics().getHeight());
        g.setFont(oldFont);
    }

    public void paint(Graphics g) {
        this.origen(g);
        this.update(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, this.wAncho, this.wAlto);
        this.onda(this.gBuffer);
        g.drawImage(this.imag, 0, 0, null);
    }
}

