/*
 * Decompiled with CFR 0.152.
 */
package ondasEstacionarias6;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import ondasEstacionarias6.OndasEstacionariasApplet6;

public class MiCanvas
extends Canvas {
    OndasEstacionariasApplet6 parent;
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgY;
    int orgX;
    double escalaX;
    int escalaY;
    double v1 = 40.0;
    double v2 = 80.0;
    double t;
    final double dt = 1.0E-4;
    int iModo = 0;
    double A;
    double[] raices = new double[6];
    final double longitud = 1.0;
    final double CERO = 1.0E-10;
    final double ERROR = 0.001;
    final int MAXITER = 200;
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas(OndasEstacionariasApplet6 p) {
        this.parent = p;
        this.setBackground(Color.white);
    }

    void setNuevo(double v1, double v2) {
        this.v2 = v2;
        this.v1 = v1;
        this.explorar(1.0, 10000.0, 1.0);
        this.t = 0.0;
        this.iModo = 0;
        this.normaliza();
        this.repaint();
    }

    void setModo(int iModo) {
        this.iModo = iModo;
        this.normaliza();
        this.t = 0.0;
        this.repaint();
    }

    void normaliza() {
        double k1 = Math.PI * 2 * this.raices[this.iModo] / this.v1;
        double k2 = Math.PI * 2 * this.raices[this.iModo] / this.v2;
        this.A = 1.0 / Math.sqrt(this.fAuxiliar(k1) + this.fAuxiliar(k2));
        if (Math.abs(Math.sin(Math.PI * 2 * this.raices[this.iModo] * 1.0 / this.v1)) < 1.0E-6 && Math.abs(Math.sin(Math.PI * 2 * this.raices[this.iModo] * 1.0 / this.v2)) < 1.0E-6) {
            this.A = 1.0 / Math.sqrt(1.0 * (1.0 + this.v2 * this.v2 / (this.v1 * this.v1)) / (double)2);
        }
    }

    double fAuxiliar(double k) {
        double cot = Math.cos(k * 1.0) / Math.sin(k * 1.0);
        double y = (1.0 + Math.sin((double)2 * k * 1.0) / ((double)2 * k)) / (double)2 + cot * cot * (1.0 - Math.sin((double)2 * k * 1.0) / ((double)2 * k)) / (double)2 - cot * (1.0 - Math.cos((double)2 * k * 1.0)) / ((double)2 * k);
        return y;
    }

    void explorar(double xIni, double xFin, double dx) {
        int iRaiz = 0;
        double y1 = this.f(xIni);
        for (double x = xIni; x < xFin; x += dx) {
            double y2 = this.f(x + dx);
            if (Math.abs(y1) < 1.0E-10 && iRaiz < this.raices.length) {
                this.raices[iRaiz++] = x;
                y1 = y2;
                continue;
            }
            if (y1 * y2 >= 0.0) {
                y1 = y2;
                continue;
            }
            if (iRaiz < this.raices.length) {
                this.raices[iRaiz] = this.puntoMedio(x, x + dx);
                ++iRaiz;
            } else {
                return;
            }
            y1 = y2;
        }
    }

    double puntoMedio(double a, double b) {
        double m;
        double ym;
        int iter = 0;
        while (!(Math.abs(ym = this.f(m = (a + b) / (double)2)) < 1.0E-10) && !(Math.abs((a - b) / m) < 0.001)) {
            if (this.f(a) * ym < 0.0) {
                b = m;
            } else {
                a = m;
            }
            if (++iter < 200) continue;
        }
        if (iter == 200) {
            System.out.println("No se ha encontrado la ra\u00edz");
        }
        return m;
    }

    double f(double x) {
        double y = this.v1 * Math.sin(Math.PI * 2 * x / this.v1) * Math.cos(Math.PI * 2 * x / this.v2) + this.v2 * Math.sin(Math.PI * 2 * x / this.v2) * Math.cos(Math.PI * 2 * x / this.v1);
        return y;
    }

    void origen(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgX = this.wAncho / 2;
        this.orgY = this.wAlto / 2;
        this.escalaX = (double)(this.wAncho - 2 * this.cAncho) / 2.0;
        this.escalaY = this.wAlto / 2 - 2 * this.cAlto;
    }

    void mover() {
        this.t += 1.0E-4;
        this.repaint();
    }

    void onda(Graphics g) {
        int y2;
        int x2;
        int x1;
        g.setColor(Color.black);
        g.drawLine(0, this.orgY, this.wAncho, this.orgY);
        for (int i = -10; i <= 10; i += 2) {
            x1 = this.orgX + (int)((double)i * this.escalaX / (double)10);
            g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho);
            String texto = String.valueOf((double)i / (double)10);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, this.orgY + this.cAlto + this.cAncho / 2);
            x1 = this.orgX + (int)((double)(i + 1) * this.escalaX / (double)10);
            g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho);
        }
        x1 = this.orgX - (int)(1.0 * this.escalaX);
        int y1 = this.orgY;
        g.setColor(Color.blue);
        for (double x = -1.0; x < 0.0; x += 0.01) {
            x2 = this.orgX + (int)(this.escalaX * x);
            y2 = this.orgY - (int)(this.onda_1(x) * (double)this.escalaY * this.A);
            g.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
        }
        x2 = this.orgX;
        y2 = this.orgY - (int)(this.onda_1(0.0) * (double)this.escalaY * this.A);
        g.drawLine(x1, y1, x2, y2);
        x1 = this.orgX + (int)(1.0 * this.escalaX);
        y1 = this.orgY;
        g.setColor(Color.red);
        for (double x = 1.0; x > 0.0; x -= 0.01) {
            x2 = this.orgX + (int)(this.escalaX * x);
            y2 = this.orgY - (int)(this.onda_2(x) * (double)this.escalaY * this.A);
            g.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
        }
        x2 = this.orgX;
        y2 = this.orgY - (int)(this.onda_2(0.0) * (double)this.escalaY * this.A);
        g.drawLine(x1, y1, x2, y2);
        g.setColor(Color.black);
        g.drawString(String.valueOf("Modo: ").concat(String.valueOf(String.valueOf(this.iModo))), this.cAncho, this.cAlto);
        g.drawString(String.valueOf("Frecuencia(Hz): ").concat(String.valueOf(String.valueOf((double)Math.round(this.raices[this.iModo] * (double)100) / (double)100))), 12 * this.cAncho, this.cAlto);
    }

    double onda_1(double x) {
        double y = 0.0;
        y = Math.abs(Math.sin(Math.PI * 2 * this.raices[this.iModo] * 1.0 / this.v1)) < 1.0E-6 ? Math.sin(Math.PI * 2 * this.raices[this.iModo] * x / this.v1) * Math.cos(Math.PI * 2 * this.raices[this.iModo] * this.t) : (Math.cos(Math.PI * 2 * this.raices[this.iModo] * x / this.v1) + Math.cos(Math.PI * 2 * this.raices[this.iModo] * 1.0 / this.v1) * Math.sin(Math.PI * 2 * this.raices[this.iModo] * x / this.v1) / Math.sin(Math.PI * 2 * this.raices[this.iModo] * 1.0 / this.v1)) * Math.cos(Math.PI * 2 * this.raices[this.iModo] * this.t);
        return y;
    }

    double onda_2(double x) {
        double y = 0.0;
        y = Math.abs(Math.sin(Math.PI * 2 * this.raices[this.iModo] * 1.0 / this.v2)) < 1.0E-6 ? this.v2 / this.v1 * Math.sin(Math.PI * 2 * this.raices[this.iModo] * x / this.v2) * Math.cos(Math.PI * 2 * this.raices[this.iModo] * this.t) : (Math.cos(Math.PI * 2 * this.raices[this.iModo] * x / this.v2) - Math.cos(Math.PI * 2 * this.raices[this.iModo] * 1.0 / this.v2) * Math.sin(Math.PI * 2 * this.raices[this.iModo] * x / this.v2) / Math.sin(Math.PI * 2 * this.raices[this.iModo] * 1.0 / this.v2)) * Math.cos(Math.PI * 2 * this.raices[this.iModo] * this.t);
        return y;
    }

    public void paint(Graphics g) {
        this.origen(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, this.wAncho, this.wAlto);
        this.onda(this.gBuffer);
        g.drawImage(this.imag, 0, 0, null);
    }
}

