/*
 * Decompiled with CFR 0.152.
 */
package resonador1;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import resonador1.ResonadorApplet1;

public class MiCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    ResonadorApplet1 parent;
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgX;
    int orgY;
    double escala;
    int anchoTubo;
    double h = 0.2;
    double t = 0.0;
    double dt = 2.0E-4;
    final double cte = 646.0;
    double x;
    boolean bArrastrarIzq = false;
    Rectangle marcaIzq = new Rectangle();
    int yMarca;
    Polygon grafica = new Polygon();
    Polygon pol = new Polygon();
    boolean bAmplitud = false;
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas(ResonadorApplet1 p) {
        this.parent = p;
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.marcaIzq.setSize(16, 8);
    }

    void origenEscalas(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgY = this.wAlto - this.cAncho;
        this.escala = (double)(this.orgY - 3 * this.cAlto) / 0.7;
        this.anchoTubo = 10 * this.cAncho;
        this.orgX = this.anchoTubo + this.cAncho + 5 * this.cAncho;
        this.posicionInicialMarcas();
    }

    void posicionInicialMarcas() {
        this.marcaIzq.x = this.orgX + this.anchoTubo + this.cAncho / 2;
        this.marcaIzq.y = this.orgY - (int)(this.escala * this.h) - this.marcaIzq.height / 2;
    }

    void setNuevo(boolean bAmplitud) {
        this.bAmplitud = bAmplitud;
        this.posicionInicialMarcas();
        this.bArrastrarIzq = false;
        this.t = 0.0;
        this.grafica.npoints = 0;
        this.pol.npoints = 0;
        this.repaint();
    }

    void verAmplitud(boolean bAmplitud) {
        this.bAmplitud = bAmplitud;
        this.repaint();
    }

    void mover() {
        this.x = Math.cos(646.0 * this.t * (-1.0 / Math.sqrt(0.7) + 1.0 / Math.sqrt(0.7 - this.h)) / (double)2) * Math.sin(646.0 * this.t * (1.0 / Math.sqrt(0.7) + 1.0 / Math.sqrt(0.7 - this.h)) / (double)2);
        this.t += this.dt;
        this.repaint();
    }

    void dispositivo(Graphics g) {
        this.tubo(g);
        this.grafico(g);
    }

    void tubo(Graphics g) {
        int y1 = this.orgY - (int)(0.7 * this.escala);
        g.setColor(Color.black);
        g.drawLine(this.orgX, this.orgY, this.orgX, y1);
        g.drawLine(this.orgX - 1, this.orgY, this.orgX - 1, y1);
        g.drawLine(this.orgX + this.anchoTubo, this.orgY, this.orgX + this.anchoTubo, y1);
        g.drawLine(this.orgX + this.anchoTubo + 1, this.orgY, this.orgX + this.anchoTubo + 1, y1);
        g.drawLine(this.orgX, this.orgY, this.orgX + this.anchoTubo, this.orgY);
        g.drawLine(this.orgX, this.orgY + 1, this.orgX + this.anchoTubo, this.orgY + 1);
        g.drawLine(this.orgX, y1 - 1, this.orgX + this.anchoTubo / 2 - this.cAncho, y1 - 1);
        g.drawLine(this.orgX, y1 - 2, this.orgX + this.anchoTubo / 2 - this.cAncho, y1 - 2);
        g.drawLine(this.orgX + this.anchoTubo / 2 + this.cAncho, y1 - 1, this.orgX + this.anchoTubo, y1 - 1);
        g.drawLine(this.orgX + this.anchoTubo / 2 + this.cAncho, y1 - 2, this.orgX + this.anchoTubo, y1 - 2);
        g.drawLine(this.orgX + this.anchoTubo / 2 + this.cAncho, y1 - 1, this.orgX + this.anchoTubo / 2 + this.cAncho, 0);
        g.drawLine(this.orgX + this.anchoTubo / 2 + this.cAncho + 1, y1 - 1, this.orgX + this.anchoTubo / 2 + this.cAncho + 1, 0);
        g.drawLine(this.orgX + this.anchoTubo / 2 - this.cAncho, y1 - 1, this.orgX + this.anchoTubo / 2 - this.cAncho, 0);
        g.drawLine(this.orgX + this.anchoTubo / 2 - this.cAncho - 1, y1 - 1, this.orgX + this.anchoTubo / 2 - this.cAncho - 1, 0);
        int y2 = y1 / 2 + (int)((double)y1 * Math.sin(646.0 * this.t / Math.sqrt(0.7 - this.h)) / (double)2);
        g.setColor(Color.blue);
        g.fillRect(this.orgX + this.anchoTubo / 2 - this.cAncho, y2 - this.cAncho / 4, 2 * this.cAncho, this.cAncho / 2);
        g.setColor(Color.black);
        g.drawLine(this.cAncho, this.orgY, this.cAncho, y1);
        g.drawLine(this.cAncho - 1, this.orgY, this.cAncho - 1, y1);
        g.drawLine(this.cAncho + this.anchoTubo, this.orgY, this.cAncho + this.anchoTubo, y1);
        g.drawLine(this.cAncho + this.anchoTubo + 1, this.orgY, this.cAncho + this.anchoTubo + 1, y1);
        g.drawLine(this.cAncho, this.orgY, this.cAncho + this.anchoTubo, this.orgY);
        g.drawLine(this.cAncho, this.orgY + 1, this.cAncho + this.anchoTubo, this.orgY + 1);
        g.drawLine(this.cAncho, y1 - 1, this.cAncho + this.anchoTubo / 2 - this.cAncho, y1 - 1);
        g.drawLine(this.cAncho, y1 - 2, this.cAncho + this.anchoTubo / 2 - this.cAncho, y1 - 2);
        g.drawLine(this.cAncho + this.anchoTubo / 2 + this.cAncho, y1 - 1, this.cAncho + this.anchoTubo, y1 - 1);
        g.drawLine(this.cAncho + this.anchoTubo / 2 + this.cAncho, y1 - 2, this.cAncho + this.anchoTubo, y1 - 2);
        g.drawLine(this.cAncho + this.anchoTubo / 2 + this.cAncho, y1 - 1, this.cAncho + this.anchoTubo / 2 + this.cAncho, 0);
        g.drawLine(this.cAncho + this.anchoTubo / 2 + this.cAncho + 1, y1 - 1, this.cAncho + this.anchoTubo / 2 + this.cAncho + 1, 0);
        g.drawLine(this.cAncho + this.anchoTubo / 2 - this.cAncho, y1 - 1, this.cAncho + this.anchoTubo / 2 - this.cAncho, 0);
        g.drawLine(this.cAncho + this.anchoTubo / 2 - this.cAncho - 1, y1 - 1, this.cAncho + this.anchoTubo / 2 - this.cAncho - 1, 0);
        y2 = y1 / 2 + (int)((double)y1 * Math.sin(646.0 * this.t / Math.sqrt(0.7)) / (double)2);
        g.setColor(Color.blue);
        g.fillRect(this.cAncho + this.anchoTubo / 2 - this.cAncho, y2 - this.cAncho / 4, 2 * this.cAncho, this.cAncho / 2);
        g.setColor(Color.red);
        g.fillOval(this.cAncho + this.anchoTubo + 3 * this.cAncho / 2, this.cAlto, 2 * this.cAncho, 2 * this.cAncho);
        g.setColor(Color.cyan);
        y1 = (int)(this.escala * this.h);
        g.fillRect(this.orgX + 1, this.orgY - y1, this.anchoTubo - 1, y1);
        g.setColor(Color.black);
        String texto = String.valueOf((double)Math.round(this.h * (double)1000) / (double)10);
        g.drawString(texto, this.orgX + this.anchoTubo - 4 * this.cAncho, this.orgY - y1);
        for (int i = 0; i <= 70; i += 10) {
            y1 = this.orgY - (int)((double)i * this.escala / (double)100);
            g.drawLine(this.orgX, y1, this.orgX - this.cAncho, y1);
            texto = String.valueOf(i);
            g.drawString(texto, this.orgX - this.cAncho - g.getFontMetrics().stringWidth(texto), y1 + this.cAlto / 4);
            if (i == 70) break;
            for (int j = 1; j < 5; ++j) {
                y1 = this.orgY - (int)((double)(i + 2 * j) * this.escala / (double)100);
                g.drawLine(this.orgX, y1, this.orgX - this.cAncho / 2, y1);
            }
        }
        g.drawImage(this.parent.marca, this.marcaIzq.x, this.marcaIzq.y, this);
    }

    void grafico(Graphics g) {
        String texto;
        int y1;
        int x1;
        int orgXGraf = this.orgX + this.anchoTubo + 5 * this.cAncho;
        int orgYGraf = this.wAlto / 2;
        double escTiempo = (double)(this.wAncho - orgXGraf) / 0.1;
        double escalaY = (double)(orgYGraf - this.cAlto) / 1.0;
        g.setColor(Color.black);
        g.setColor(Color.lightGray);
        for (int i = 0; i < 10; ++i) {
            x1 = orgXGraf + (int)(escTiempo * (double)i / (double)100);
            g.drawLine(x1, this.cAncho, x1, this.wAlto - this.cAncho);
        }
        for (int i = -10; i <= 10; ++i) {
            y1 = orgYGraf - (int)(escalaY * (double)i / (double)10);
            g.drawLine(orgXGraf, y1, this.wAncho, y1);
        }
        g.setColor(Color.black);
        g.drawLine(orgXGraf, orgYGraf, this.wAncho, orgYGraf);
        g.drawLine(orgXGraf, this.wAlto, orgXGraf, 0);
        g.drawString("I", orgXGraf + this.cAncho, this.cAlto);
        g.drawString("t(s)", this.wAncho - 4 * this.cAncho, orgYGraf - this.cAncho / 2);
        for (int i = 0; i <= 100; i += 10) {
            x1 = orgXGraf + (int)((double)i * escTiempo / (double)1000);
            g.drawLine(x1, orgYGraf + this.cAncho, x1, orgYGraf);
            texto = String.valueOf((double)i / (double)1000);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, orgYGraf + this.cAncho + this.cAlto);
            for (int j = 1; j < 5; ++j) {
                x1 = orgXGraf + (int)((double)(i + 2 * j) * escTiempo / (double)1000);
                g.drawLine(x1, orgYGraf + this.cAncho / 2, x1, orgYGraf);
            }
        }
        texto = String.valueOf((double)Math.round(this.t * (double)1000) / (double)1000);
        g.drawString(String.valueOf("tiempo (s) :").concat(String.valueOf(texto)), this.wAncho - 14 * this.cAncho, this.cAlto);
        x1 = orgXGraf + (int)(escTiempo * this.t);
        y1 = orgYGraf - (int)(escalaY * this.x);
        int y2 = orgYGraf - (int)(escalaY * Math.cos(646.0 * this.t * (-1.0 / Math.sqrt(0.7) + 1.0 / Math.sqrt(0.7 - this.h)) / (double)2));
        if (x1 < this.wAncho) {
            this.grafica.addPoint(x1, y1);
            this.pol.addPoint(x1, y2);
        } else {
            this.parent.hilo.putMsg(0);
        }
        g.setColor(Color.red);
        g.fillOval(x1 - 2, y1 - 2, 4, 4);
        g.setColor(Color.blue);
        g.drawPolyline(this.grafica.xpoints, this.grafica.ypoints, this.grafica.npoints);
        if (this.bAmplitud) {
            g.setColor(Color.red);
            g.drawPolyline(this.pol.xpoints, this.pol.ypoints, this.pol.npoints);
        }
    }

    public void paint(Graphics g) {
        this.origenEscalas(g);
        this.update(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, d.width, d.height);
        this.gBuffer.setColor(Color.black);
        this.dispositivo(this.gBuffer);
        g.drawImage(this.imag, 0, 0, null);
    }

    public void mousePressed(MouseEvent ev) {
        this.parent.hilo.putMsg(0);
        if (this.marcaIzq.contains(ev.getX(), ev.getY())) {
            this.yMarca = ev.getY();
            this.bArrastrarIzq = true;
            this.pol.npoints = 0;
            this.grafica.npoints = 0;
        }
    }

    public void mouseReleased(MouseEvent ev) {
        if (this.bArrastrarIzq) {
            this.bArrastrarIzq = false;
            this.marcaIzq.y += ev.getY() - this.yMarca;
            this.h = (double)(this.orgY - this.marcaIzq.y - this.marcaIzq.height / 2) / this.escala;
            if (this.h < 0.04) {
                this.h = 0.04;
            }
            if (this.h > 0.6) {
                this.h = 0.6;
            }
            this.marcaIzq.y = this.orgY - (int)(this.h * this.escala) - this.marcaIzq.height / 2;
        }
        this.yMarca = ev.getY();
        this.repaint();
    }

    public void mouseDragged(MouseEvent ev) {
        int y1 = this.orgY - (int)(0.6 * this.escala);
        if (this.bArrastrarIzq && this.marcaIzq.y + this.marcaIzq.height / 2 <= this.orgY && this.marcaIzq.y + this.marcaIzq.height / 2 >= y1) {
            this.marcaIzq.y += ev.getY() - this.yMarca;
            this.h = (double)(this.orgY - this.marcaIzq.y - this.marcaIzq.height / 2) / this.escala;
            if (this.h < 0.04) {
                this.h = 0.04;
            }
            if (this.h > 0.6) {
                this.h = 0.6;
            }
            this.marcaIzq.y = this.orgY - (int)(this.h * this.escala) - this.marcaIzq.height / 2;
        }
        this.yMarca = ev.getY();
        this.repaint();
    }

    public void mouseClicked(MouseEvent ev) {
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseMoved(MouseEvent ev) {
    }
}

