/*
 * Decompiled with CFR 0.152.
 */
package gris8;

public class Bessel {
    private static double bessj0(double x) {
        double ans;
        double d;
        double ax = Math.abs(x);
        if (d < 8.0) {
            double y = x * x;
            double ans1 = 5.7568490574E10 + y * (-1.3362590354E10 + y * (6.516196407E8 + y * (-1.121442418E7 + y * (77392.33017 + y * -184.9052456))));
            double ans2 = 5.7568490411E10 + y * (1.029532985E9 + y * (9494680.718 + y * (59272.64853 + y * (267.8532712 + y * 1.0))));
            ans = ans1 / ans2;
        } else {
            double z = 8.0 / ax;
            double y = z * z;
            double xx = ax - 0.785398164;
            double ans1 = 1.0 + y * (-0.001098628627 + y * (2.734510407E-5 + y * (-2.073370639E-6 + y * 2.093887211E-7)));
            double ans2 = -0.01562499995 + y * (1.430488765E-4 + y * (-6.911147651E-6 + y * (7.621095161E-7 - y * 9.34935152E-8)));
            ans = Math.sqrt(0.636619772 / ax) * (Math.cos(xx) * ans1 - z * Math.sin(xx) * ans2);
        }
        return ans;
    }

    private static double bessj1(double x) {
        double ans;
        double d;
        double ax = Math.abs(x);
        if (d < 8.0) {
            double y = x * x;
            double ans1 = x * (7.2362614232E10 + y * (-7.895059235E9 + y * (2.423968531E8 + y * (-2972611.439 + y * (15704.4826 + y * -30.16036606)))));
            double ans2 = 1.44725228442E11 + y * (2.300535178E9 + y * (1.858330474E7 + y * (99447.43394 + y * (376.9991397 + y * 1.0))));
            ans = ans1 / ans2;
        } else {
            double z = 8.0 / ax;
            double y = z * z;
            double xx = ax - 2.356194491;
            double ans1 = 1.0 + y * (0.00183105 + y * (-3.516396496E-5 + y * (2.457520174E-6 + y * -2.40337019E-7)));
            double ans2 = 0.04687499995 + y * (-2.002690873E-4 + y * (8.449199096E-6 + y * (-8.8228987E-7 + y * 1.05787412E-7)));
            ans = Math.sqrt(0.636619772 / ax) * (Math.cos(xx) * ans1 - z * Math.sin(xx) * ans2);
            if (x < 0.0) {
                ans = -ans;
            }
        }
        return ans;
    }

    public static double bessj(int n, double x) {
        double ans;
        if (n == 0) {
            return Bessel.bessj0(x);
        }
        if (n == 1) {
            return Bessel.bessj1(x);
        }
        if (n == -1) {
            return -Bessel.bessj1(x);
        }
        double ax = Math.abs(x);
        if (ax == 0.0) {
            return 0.0;
        }
        if (ax > (double)n) {
            double tox = 2.0 / ax;
            double bjm = Bessel.bessj0(ax);
            double bj = Bessel.bessj1(ax);
            for (int j = 1; j < n; ++j) {
                double bjp = (double)j * tox * bj - bjm;
                bjm = bj;
                bj = bjp;
            }
            ans = bj;
        } else {
            double tox = 2.0 / ax;
            int m = 2 * ((n + (int)Math.sqrt(40.0 * (double)n)) / 2);
            boolean jsum = false;
            double sum = 0.0;
            ans = 0.0;
            double bjp = 0.0;
            double bj = 1.0;
            for (int j = m; j > 0; --j) {
                double bjm = (double)j * tox * bj - bjp;
                bjp = bj;
                bj = bjm;
                if (Math.abs(bj) > 1.0E10) {
                    bj *= 1.0E-10;
                    bjp *= 1.0E-10;
                    ans *= 1.0E-10;
                    sum *= 1.0E-10;
                }
                if (jsum) {
                    sum += bj;
                }
                boolean bl = jsum = !jsum;
                if (j != n) continue;
                ans = bjp;
            }
            sum = 2.0 * sum - bj;
            ans /= sum;
        }
        boolean bRes = (n & 1) != 0;
        return x < 0.0 && bRes ? -ans : ans;
    }

    static void nrerror(String texto) {
        System.out.println(texto);
    }
}

