/*
 * Decompiled with CFR 0.152.
 */
package gris8;

import gris8.Bessel;
import gris8.GrisApplet8;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;

public class MiCanvas
extends Canvas {
    GrisApplet8 parent;
    int cAncho;
    int cAlto;
    int wAncho;
    int wAlto;
    double escalaX;
    double escalaY;
    int orgX;
    int orgY;
    int radio;
    int rMax = 1;
    int iMax = 4;
    final int[] gris = new int[]{0, 2, 3, 4, 6, 7, 8, 10, 11, 12, 13, 15, 17, 18, 20, 21, 22, 23, 25, 26, 27, 29, 30, 31, 32, 35, 36, 37, 39, 40, 41, 42, 44, 45, 46, 48, 49, 51, 53, 54, 55, 56, 58, 59, 60, 62, 63, 64, 65, 68, 69, 70, 72, 73, 74, 75, 77, 78, 79, 81, 82, 83, 85, 87, 88, 89, 91, 92, 93, 95, 96, 97, 98, 100, 102, 103, 105, 106, 107, 108, 110, 111, 112, 114, 115, 116, 117, 120, 121, 122, 124, 125, 126, 127, 129, 130, 131, 133, 134, 136, 138, 139, 140, 141, 143, 144, 145, 147, 148, 149, 150, 153, 154, 155, 157, 158, 159, 160, 162, 163, 164, 166, 167, 168, 170, 172, 173, 174, 176, 177, 178, 180, 181, 182, 183, 185, 187, 188, 190, 191, 192, 193, 195, 196, 197, 199, 200, 201, 202, 205, 206, 207, 209, 210, 211, 212, 214, 215, 216, 218, 219, 221, 223, 224, 225, 226, 228, 229, 230, 232, 233, 234, 235, 238, 239, 240, 242, 243, 244, 245, 247, 248, 249, 251, 252, 253, 255};
    double u = 31.0;
    final double intenMax = 4.0;
    boolean bTermina = false;
    final double MINIMO = 1.0E-10;
    Polygon pol = new Polygon();
    Image imagenIntensidad;
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas(GrisApplet8 p) {
        this.parent = p;
        this.setBackground(Color.white);
    }

    void origenEscalas(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgX = this.wAncho / 2 + 3 * this.cAncho;
        this.orgY = this.wAlto - this.cAlto - this.cAncho;
        this.escalaX = (double)(this.wAncho - this.orgX - this.cAncho) / (double)this.rMax;
        this.escalaY = (double)this.orgY / (double)this.iMax;
        this.radio = this.wAncho / 4 - this.cAncho;
    }

    void setNuevo(int u1, int r, int escVert) {
        this.u = u1;
        this.rMax = r;
        this.iMax = escVert;
        this.escalaX = (double)(this.wAncho - this.orgX - this.cAncho) / (double)this.rMax;
        this.escalaY = (double)this.orgY / (double)this.iMax;
        this.crearImagenes();
        this.graficaIntensidad();
        this.repaint();
    }

    void crearImagenes() {
        this.parent.setCursor(Cursor.getPredefinedCursor(3));
        this.imagenIntensidad = this.createImage(2 * this.radio, 2 * this.radio);
        this.gBuffer = this.imagenIntensidad.getGraphics();
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, 2 * this.radio, 2 * this.radio);
        this.intensidad(this.gBuffer);
        this.gBuffer = null;
        this.parent.setCursor(Cursor.getPredefinedCursor(0));
    }

    void intensidad(Graphics g) {
        for (int i = this.radio; i > 0; --i) {
            double x = (double)(this.rMax * i) / (double)this.radio;
            int nivel = (int)((double)(this.gris.length - 1) * this.calculaIntensidad(x * this.u) / 4.0);
            g.setColor(new Color(this.gris[nivel], this.gris[nivel], this.gris[nivel]));
            g.fillOval(this.radio - i, this.radio - i, 2 * i, 2 * i);
        }
    }

    double calculaIntensidad(double v) {
        if (v == 0.0) {
            return (double)2 * (1.0 - Math.cos(this.u / (double)2));
        }
        if (v < this.u) {
            double v0 = this.V0(v);
            double v1 = this.V1(v);
            double fL = Math.sin(v * v / ((double)2 * this.u)) + v0 * Math.sin(this.u / (double)2) - v1 * Math.cos(this.u / (double)2);
            double fM = Math.cos(v * v / ((double)2 * this.u)) - v0 * Math.cos(this.u / (double)2) - v1 * Math.sin(this.u / (double)2);
            return fL * fL + fM * fM;
        }
        if (v > this.u) {
            double u1 = this.U1(v);
            double u2 = this.U2(v);
            double fL = u1 * Math.cos(this.u / (double)2) + u2 * Math.sin(this.u / (double)2);
            double fM = u1 * Math.sin(this.u / (double)2) - u2 * Math.cos(this.u / (double)2);
            return fL * fL + fM * fM;
        }
        double temp = Bessel.bessj(0, this.u);
        return (1.0 - (double)2 * temp * Math.cos(this.u) + temp * temp) / (double)4;
    }

    double V0(double v) {
        double suma = Bessel.bessj(0, v);
        int i = 1;
        do {
            this.bTermina = false;
            int signo = i % 2 == 0 ? 1 : -1;
            suma += (double)signo * this.potencia(v / this.u, 2 * i) * this.bessel(2 * i, v);
            ++i;
        } while (!this.bTermina);
        return suma;
    }

    double V1(double v) {
        double suma = 0.0;
        int i = 0;
        do {
            this.bTermina = false;
            int signo = i % 2 == 0 ? 1 : -1;
            suma += (double)signo * this.potencia(v / this.u, 2 * i + 1) * this.bessel(2 * i + 1, v);
            ++i;
        } while (!this.bTermina);
        return suma;
    }

    double U1(double v) {
        double suma = 0.0;
        int i = 0;
        do {
            this.bTermina = false;
            int signo = i % 2 == 0 ? 1 : -1;
            suma += (double)signo * this.potencia(this.u / v, 2 * i + 1) * this.bessel(2 * i + 1, v);
            ++i;
        } while (!this.bTermina);
        return suma;
    }

    double U2(double v) {
        double suma = 0.0;
        int i = 1;
        do {
            this.bTermina = false;
            int signo = i % 2 == 0 ? -1 : 1;
            suma += (double)signo * this.potencia(this.u / v, 2 * i) * this.bessel(2 * i, v);
            ++i;
        } while (!this.bTermina);
        return suma;
    }

    double bessel(int n, double v) {
        double temp = Bessel.bessj(n, v);
        if ((double)n > v && temp < 1.0E-10) {
            this.bTermina = true;
        }
        return temp;
    }

    double potencia(double x, double n) {
        double pot = 1.0;
        int i = 1;
        while ((double)i <= n) {
            pot *= x;
            ++i;
        }
        if (pot < 1.0E-10) {
            this.bTermina = true;
        }
        return pot;
    }

    void graficaIntensidad() {
        this.pol.npoints = 0;
        for (double x = 0.0; x < (double)this.rMax; x += (double)this.rMax / (double)100) {
            int x1 = this.orgX + (int)(x * this.escalaX);
            int y1 = this.orgY - (int)(this.calculaIntensidad(x * this.u) * this.escalaY);
            this.pol.addPoint(x1, y1);
        }
    }

    void grafica(Graphics g) {
        String texto;
        g.setColor(Color.black);
        g.drawLine(this.orgX, 0, this.orgX, this.orgY);
        g.drawString("In", this.orgX + this.cAncho, this.cAlto);
        g.drawLine(this.orgX, this.orgY, this.wAncho, this.orgY);
        for (int i = 0; i <= this.rMax; ++i) {
            int x1 = this.orgX + (int)((double)i * this.escalaX);
            texto = String.valueOf(i);
            g.drawLine(x1, this.orgY + this.cAncho, x1, this.orgY);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, this.orgY + this.cAncho + this.cAlto);
            for (int j = 1; j < 5; ++j) {
                x1 = this.orgX + (int)(((double)i + (double)j / (double)5) * this.escalaX);
                g.drawLine(x1, this.orgY + this.cAncho / 2, x1, this.orgY);
            }
        }
        for (int i = 0; i <= this.iMax * 10; i += 5) {
            int y1 = this.orgY - (int)((double)i * this.escalaY / (double)10);
            g.drawLine(this.orgX, y1, this.orgX - this.cAncho, y1);
            texto = String.valueOf((double)Math.round((double)i * (double)10) / (double)100);
            g.drawString(texto, this.orgX - this.cAncho - g.getFontMetrics().stringWidth(texto), y1 + this.cAlto / 4);
            for (int j = 1; j < 5; ++j) {
                y1 = this.orgY - (int)((double)(i + j) * this.escalaY / (double)10);
                g.drawLine(this.orgX, y1, this.orgX - this.cAncho / 2, y1);
            }
        }
        g.setColor(Color.blue);
        g.drawPolyline(this.pol.xpoints, this.pol.ypoints, this.pol.npoints);
    }

    void dispositivo(Graphics g) {
        g.drawImage(this.imagenIntensidad, this.cAncho, this.wAlto / 2 - this.radio, null);
        this.grafica(g);
    }

    public void paint(Graphics g) {
        this.origenEscalas(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, d.width, d.height);
        this.dispositivo(this.gBuffer);
        g.drawImage(this.imag, 0, 0, null);
    }
}

