/*
 * Decompiled with CFR 0.152.
 */
package kundt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MiCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    int cAncho;
    int cAlto;
    int wAncho;
    int wAlto;
    int orgX;
    int orgY;
    double escala;
    int rTubo;
    final double lonVarilla = 160.0;
    final double lonTubo = 50.0;
    double frecuencia;
    double xEmbolo;
    int nArmonico;
    boolean bOnda = false;
    boolean bArrastrar = false;
    Rectangle rect = new Rectangle();
    int xPos;
    final String[] str = new String[]{"Acero", "Aluminio", "Cinc", "Cobre", "Esta\u00f1o", "Hierro", "Lat\u00f3n", "Plomo", "Cuarzo"};
    int indice = 0;
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas() {
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    void origenEscalas(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgX = 3 * this.wAncho / 4;
        this.orgY = this.wAlto / 2;
        this.rTubo = 2 * this.cAlto;
        this.rect.setBounds(this.orgX - this.cAncho, this.orgY - this.rTubo, this.cAncho, 2 * this.rTubo);
        this.escala = (double)(this.orgX - this.cAlto) / 50.0;
    }

    void setNuevo(int velocidad, int indice) {
        this.indice = indice;
        this.frecuencia = (double)(velocidad * 100) / 160.0;
        this.bArrastrar = false;
        this.xEmbolo = 0.0;
        this.nArmonico = 0;
        this.bOnda = false;
        this.rect.x = this.orgX - this.rect.width;
        this.repaint();
    }

    void recipiente(Graphics g) {
        int y1;
        int x1;
        g.setColor(Color.gray);
        int nPolvos = (int)(this.xEmbolo * (double)2);
        if (this.bOnda) {
            double lonOnda = (double)2 * this.xEmbolo / (double)this.nArmonico;
            for (int i = 0; i <= this.nArmonico; ++i) {
                x1 = this.orgX - (int)((double)i * lonOnda * this.escala / (double)2);
                for (int j = 0; j < nPolvos / (this.nArmonico + 1); ++j) {
                    int x2 = x1 + this.cAncho / 4 - (int)((double)this.cAncho * Math.random() / (double)2);
                    int y2 = this.orgY + this.rTubo - 2 - (int)((double)this.cAncho * Math.random());
                    g.fillOval(x2 - 2, y2 - 2, 4, 4);
                }
            }
        } else {
            for (int i = 0; i < nPolvos; ++i) {
                x1 = this.orgX - (int)(this.xEmbolo * this.escala * Math.random());
                y1 = this.orgY + this.rTubo - 2 - (int)((double)this.cAncho * Math.random());
                g.fillOval(x1 - 2, y1 - 2, 4, 4);
            }
        }
        nPolvos = (int)((50.0 - this.xEmbolo) * (double)2);
        for (int i = 0; i < nPolvos; ++i) {
            x1 = this.orgX - (int)((this.xEmbolo + (50.0 - this.xEmbolo) * Math.random()) * this.escala);
            y1 = this.orgY + this.rTubo - 2 - (int)((double)this.cAncho * Math.random());
            g.fillOval(x1 - 2, y1 - 2, 4, 4);
        }
        g.setColor(Color.black);
        g.drawString(String.valueOf(String.valueOf("Longitud de la varilla:").concat(String.valueOf(String.valueOf(160.0)))).concat(String.valueOf(" cm")), this.cAncho, 3 * this.cAlto / 2);
        g.drawString("Velocidad del sonido: 340 m/s", this.cAncho, 5 * this.cAlto / 2);
        g.drawString("Mover con el puntero del rat\u00f3n el \u00e9mbolo de color rojo", this.cAncho, this.orgY + this.rTubo + 4 * this.cAlto);
        g.drawLine(0, this.orgY - this.rTubo, this.orgX + this.cAlto, this.orgY - this.rTubo);
        g.drawLine(0, this.orgY - this.rTubo - 1, this.orgX + this.cAlto, this.orgY - this.rTubo - 1);
        g.drawLine(0, this.orgY + this.rTubo, this.orgX + this.cAlto, this.orgY + this.rTubo);
        g.drawLine(0, this.orgY + this.rTubo + 1, this.orgX + this.cAlto, this.orgY + this.rTubo + 1);
        g.setColor(Color.blue);
        g.fillRect(this.orgX, this.orgY - this.rTubo + 2, this.cAncho / 2, 2 * this.rTubo - 4);
        g.fillRect(this.orgX + this.cAncho / 2, this.orgY - 2, this.wAncho - this.orgX, 4);
        g.setColor(Color.black);
        g.drawString("varilla", this.orgX + 3 * this.cAlto, this.orgY - this.cAncho);
        g.setColor(Color.red);
        g.fillRect(this.rect.x, this.rect.y + 2, this.rect.width, this.rect.height - 4);
        g.fillRect(0, this.orgY - 2, this.rect.x, 4);
        g.drawLine(this.rect.x + this.rect.width, this.orgY + this.rTubo + this.cAncho, this.rect.x + this.rect.width, this.orgY + this.rTubo + 2 * this.cAncho);
        g.setColor(Color.black);
        int i = 0;
        while ((double)i <= 50.0) {
            x1 = this.orgX - (int)((double)i * this.escala);
            g.drawLine(x1, this.orgY + this.rTubo + 1, x1, this.orgY + this.rTubo + 1 + this.cAncho);
            String texto = String.valueOf(i);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, this.orgY + this.rTubo + 1 + this.cAncho + this.cAlto);
            if (i == 50) break;
            for (int j = 1; j < 10; ++j) {
                x1 = this.orgX - (int)((double)(i + j) * this.escala);
                g.drawLine(x1, this.orgY + this.rTubo + 1, x1, this.orgY + this.rTubo + 1 + this.cAncho / 2);
                if (j != 5) continue;
                g.drawLine(x1, this.orgY + this.rTubo + 1, x1, this.orgY + this.rTubo + 1 + 3 * this.cAncho / 4);
            }
            i += 10;
        }
        g.drawString("cm", this.orgX + this.cAncho, this.orgY + this.rTubo + this.cAlto);
    }

    void dibujaOnda(Graphics g) {
        double y = 0.0;
        int y1 = this.orgY;
        int x1 = this.orgX;
        int y3 = this.orgY;
        g.setColor(Color.blue);
        double lonOnda = (double)2 * this.xEmbolo / (double)this.nArmonico;
        for (double x = 0.0; x < this.xEmbolo; x += 0.5) {
            y = Math.sin(Math.PI * 2 * x / lonOnda);
            int x2 = this.orgX - (int)(this.escala * x);
            int y2 = this.orgY - (int)(y * (double)3 * (double)this.rTubo / (double)4);
            g.drawLine(x1, y1, x2, y2);
            int y4 = this.orgY + (int)(y * (double)3 * (double)this.rTubo / (double)4);
            g.drawLine(x1, y3, x2, y4);
            x1 = x2;
            y1 = y2;
            y3 = y4;
        }
    }

    void dispositivo(Graphics g) {
        this.recipiente(g);
        if (this.bOnda) {
            this.dibujaOnda(g);
        }
    }

    public void paint(Graphics g) {
        this.origenEscalas(g);
        this.dispositivo(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, d.width, d.height);
        this.dispositivo(this.gBuffer);
        g.drawImage(this.imag, 0, 0, null);
    }

    public void mousePressed(MouseEvent ev) {
        if (this.rect.contains(ev.getX(), ev.getY())) {
            this.xPos = ev.getX();
            this.bArrastrar = true;
        }
    }

    public void mouseReleased(MouseEvent ev) {
        this.bArrastrar = false;
        this.verificar();
    }

    public void mouseDragged(MouseEvent ev) {
        int x2 = ev.getX();
        if (this.bArrastrar && ev.getX() < this.orgX - this.rect.width && ev.getX() > 0) {
            this.verificar();
            this.rect.x = this.rect.x + x2 - this.xPos;
            this.xPos = x2;
            this.repaint();
        }
    }

    void verificar() {
        this.xEmbolo = (double)(this.orgX - this.rect.x - this.rect.width) / this.escala;
        double frecFundamental = 34000.0 / ((double)2 * this.xEmbolo);
        this.nArmonico = (int)Math.round(this.frecuencia / frecFundamental);
        double xCalcula = (double)this.nArmonico * 340.0 / ((double)2 * this.frecuencia);
        this.bOnda = false;
        if (Math.abs(this.xEmbolo - xCalcula * (double)100) < 0.25) {
            this.bOnda = true;
        }
    }

    public void mouseClicked(MouseEvent ev) {
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseMoved(MouseEvent ev) {
    }

    void respuesta(int velocidad, int indice) {
        Graphics g = this.getGraphics();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.wAncho, this.wAlto);
        g.setColor(Color.black);
        Font oldFont = this.getFont();
        Font fuente = new Font("Times", 1, 16);
        g.setFont(fuente);
        int alto = g.getFontMetrics().getHeight();
        String texto = "La velocidad de propagaci\u00f3n de las ondas";
        int ancho = g.getFontMetrics().stringWidth(texto);
        g.drawString(texto, this.wAncho / 2 - ancho / 2, this.wAlto / 2 + alto / 4 - 2 * alto);
        texto = String.valueOf(String.valueOf("longitudinales en el ").concat(String.valueOf(this.str[indice]))).concat(String.valueOf(" es"));
        ancho = g.getFontMetrics().stringWidth(texto);
        g.drawString(texto, this.wAncho / 2 - ancho / 2, this.wAlto / 2 + alto / 4 - alto);
        texto = String.valueOf(String.valueOf(velocidad)).concat(String.valueOf(" m/s"));
        ancho = g.getFontMetrics().stringWidth(texto);
        g.drawString(texto, this.wAncho / 2 - ancho / 2, this.wAlto / 2 + alto / 4 + alto);
        g.setFont(oldFont);
        g.dispose();
    }
}

