/*
 * Decompiled with CFR 0.152.
 */
package gris4;

public class Complejo {
    double real;
    double imag;

    public Complejo() {
        this.real = 0.0;
        this.imag = 0.0;
    }

    public Complejo(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public static Complejo conjugado(Complejo c) {
        return new Complejo(c.real, -c.imag);
    }

    public static Complejo opuesto(Complejo c) {
        return new Complejo(-c.real, -c.imag);
    }

    public double modulo() {
        return Math.sqrt(this.real * this.real + this.imag * this.imag);
    }

    public double argumento() {
        double angulo = Math.atan2(this.imag, this.real);
        if (angulo < 0.0) {
            angulo = Math.PI * 2 + angulo;
        }
        return angulo * (double)180 / Math.PI;
    }

    public static Complejo suma(Complejo c1, Complejo c2) {
        double x = c1.real + c2.real;
        double y = c1.imag + c2.imag;
        return new Complejo(x, y);
    }

    public static Complejo diferencia(Complejo c1, Complejo c2) {
        double x = c1.real - c2.real;
        double y = c1.imag - c2.imag;
        return new Complejo(x, y);
    }

    public static Complejo producto(Complejo c1, Complejo c2) {
        double x = c1.real * c2.real - c1.imag * c2.imag;
        double y = c1.real * c2.imag + c1.imag * c2.real;
        return new Complejo(x, y);
    }

    public static Complejo producto(Complejo c, double d) {
        double x = c.real * d;
        double y = c.imag * d;
        return new Complejo(x, y);
    }

    public static Complejo producto(double d, Complejo c) {
        double x = c.real * d;
        double y = c.imag * d;
        return new Complejo(x, y);
    }

    public static Complejo cociente(Complejo c1, Complejo c2) {
        double aux = c2.real * c2.real + c2.imag * c2.imag;
        double x = (c1.real * c2.real + c1.imag * c2.imag) / aux;
        double y = (c1.imag * c2.real - c1.real * c2.imag) / aux;
        return new Complejo(x, y);
    }

    public static Complejo cociente(Complejo c, double d) {
        double x = c.real / d;
        double y = c.imag / d;
        return new Complejo(x, y);
    }

    public static Complejo exponencial(Complejo c) {
        double x = Math.cos(c.imag) * Math.exp(c.real);
        double y = Math.sin(c.imag) * Math.exp(c.real);
        return new Complejo(x, y);
    }

    public static Complejo csqrt(double d) {
        if (d >= 0.0) {
            return new Complejo(Math.sqrt(d), 0.0);
        }
        return new Complejo(0.0, Math.sqrt(-d));
    }

    private static double potencia(double base, int exponente) {
        double resultado = 1.0;
        for (int i = 0; i < exponente; ++i) {
            resultado *= base;
        }
        return resultado;
    }

    private static double combinatorio(int m, int n) {
        long num = 1L;
        long den = 1L;
        for (int i = m; i > m - n; --i) {
            num *= (long)i;
        }
        for (int i = 2; i <= n; ++i) {
            den *= (long)i;
        }
        return (double)num / (double)den;
    }

    public static Complejo potencia(Complejo c, int exponente) {
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i <= exponente; ++i) {
            int signo = i % 2 == 0 ? 1 : -1;
            x += Complejo.combinatorio(exponente, 2 * i) * Complejo.potencia(c.real, exponente - 2 * i) * Complejo.potencia(c.imag, 2 * i) * (double)signo;
            if (exponente == 2 * i) break;
            y += Complejo.combinatorio(exponente, 2 * i + 1) * Complejo.potencia(c.real, exponente - (2 * i + 1)) * Complejo.potencia(c.imag, 2 * i + 1) * (double)signo;
        }
        return new Complejo(x, y);
    }

    public String toString() {
        if (this.imag > 0.0) {
            return new String(String.valueOf(String.valueOf(String.valueOf((double)Math.round((double)100 * this.real) / (double)100).concat(String.valueOf(" + "))).concat(String.valueOf((double)Math.round((double)100 * this.imag) / (double)100))).concat(String.valueOf("*i")));
        }
        return new String(String.valueOf(String.valueOf(String.valueOf((double)Math.round((double)100 * this.real) / (double)100).concat(String.valueOf(" - "))).concat(String.valueOf((double)Math.round((double)-100 * this.imag) / (double)100))).concat(String.valueOf("*i")));
    }
}

