/*
 * Decompiled with CFR 0.152.
 */
package viga5;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class MiCanvas
extends Canvas {
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgX;
    int orgY;
    double escalaX;
    double escalaY;
    double dt = 0.001;
    double t = 0.0;
    final double c;
    double longitud = 0.1;
    double frecuencia;
    double cte;
    double fArmonico;
    double amplitud;
    double[] x = new double[10];
    double[] y = new double[10];
    int nDatos;
    boolean bGrafica;
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas() {
        this.c = (this.sinh(1.875) + Math.sin(1.875)) / (this.cosh(1.875) + Math.cos(1.875));
        this.setBackground(Color.white);
    }

    void origenEscalas(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgX = 4 * this.cAncho;
        this.orgY = this.wAlto / 2;
        this.escalaX = (double)(this.wAncho - 8 * this.cAncho) / 0.2;
        this.escalaY = 20.0;
        g.setColor(Color.blue);
        g.drawLine(this.orgX, this.orgY, this.wAncho - 4 * this.cAncho, this.orgY);
    }

    void setInicio() {
        this.nDatos = 0;
        double Y = (double)160 + (double)50 * Math.random();
        this.cte = 3.515625 * Math.sqrt(Y * 0.76 * 0.76 / 93.6) / (Math.PI * 2);
    }

    void setNuevo(double frecuencia, double longitud) {
        this.longitud = longitud;
        this.frecuencia = frecuencia;
        this.fArmonico = this.cte / (longitud * longitud);
        this.amplitud = Math.exp(-20.0 * (frecuencia - this.fArmonico) * (frecuencia - this.fArmonico));
        this.repaint();
    }

    void setGrafica() {
        this.bGrafica = true;
        this.repaint();
    }

    void setDatos() {
        if (this.nDatos < this.x.length) {
            this.x[this.nDatos] = this.longitud;
            this.y[this.nDatos] = this.frecuencia;
            ++this.nDatos;
        }
    }

    void mover() {
        this.t += this.dt;
        this.repaint();
    }

    double fOnda(double x) {
        double y = this.sinh(1.875 * x) - Math.sin(1.875 * x) - this.c * (this.cosh(1.875 * x) - Math.cos(1.875 * x));
        return y;
    }

    double sinh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / (double)2;
    }

    double cosh(double x) {
        return (Math.exp(x) + Math.exp(-x)) / (double)2;
    }

    void onda(Graphics g) {
        int y1;
        int x1;
        g.setColor(Color.black);
        g.fillRect(this.orgX - this.cAlto, this.orgY - 2 * this.cAlto, this.cAlto, 4 * this.cAlto);
        g.setColor(Color.blue);
        g.drawLine(this.orgX - this.cAlto, this.orgY, this.orgX, this.orgY);
        int x2 = this.orgX;
        int y2 = this.orgY;
        for (double x = 0.0; x < this.longitud; x += 0.01) {
            x1 = this.orgX + (int)(this.escalaX * x);
            y1 = this.orgY - (int)(this.fOnda(x / this.longitud) * this.escalaY * Math.sin(Math.PI * 2 * this.fArmonico * this.t) * this.amplitud);
            g.drawLine(x1, y1, x2, y2);
            x2 = x1;
            y2 = y1;
        }
        x1 = this.orgX + (int)(this.escalaX * this.longitud);
        y1 = this.orgY - (int)(this.fOnda(1.0) * this.escalaY * Math.sin(Math.PI * 2 * this.fArmonico * this.t) * this.amplitud);
        g.drawLine(x1, y1, x2, y2);
        g.setColor(Color.yellow);
        g.fillRect(x1, this.cAlto, 5 * this.cAncho, this.wAlto - 2 * this.cAlto);
        g.setColor(Color.black);
        for (int i = -5; i <= 5; ++i) {
            y1 = this.orgY - i * (this.wAlto - 2 * this.cAlto) / 10;
            g.drawLine(x1, y1, x1 + this.cAncho, y1);
            g.drawString(String.valueOf(Math.abs(i)), x1 + 2 * this.cAncho, y1 + this.cAlto / 4);
            if (i == 5) break;
            for (int j = 1; j < 10; ++j) {
                y1 = this.orgY - (int)(((double)i + (double)j / (double)10) * (double)(this.wAlto - 2 * this.cAlto) / (double)10);
                g.drawLine(x1, y1, x1 + this.cAncho / 2, y1);
                if (j != 5) continue;
                g.drawLine(x1, y1, x1 + 3 * this.cAncho / 4, y1);
            }
        }
    }

    public void paint(Graphics g) {
        this.origenEscalas(g);
        this.onda(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, d.width, d.height);
        if (this.bGrafica) {
            this.grafica(this.gBuffer);
            this.bGrafica = false;
        } else {
            this.onda(this.gBuffer);
        }
        g.drawImage(this.imag, 0, 0, null);
    }

    void grafica(Graphics g) {
        int y1;
        int x1;
        int orgXX = 5 * this.cAncho;
        int orgYY = this.wAlto - this.cAlto - this.cAncho;
        double escalaXX = (double)(this.wAncho - orgXX - 3 * this.cAncho) / (double)20;
        double escalaYY = (double)orgYY / 65.0;
        g.setColor(Color.black);
        g.drawLine(orgXX - this.cAncho, orgYY, this.wAncho, orgYY);
        g.drawString("l cm", this.wAncho - 6 * this.cAncho, orgYY);
        for (int i = 0; i <= 20; i += 2) {
            x1 = orgXX + (int)((double)i * escalaXX);
            g.drawLine(x1, orgYY, x1, orgYY + this.cAncho);
            String str = String.valueOf(i);
            g.drawString(str, x1 - g.getFontMetrics().stringWidth(str) / 2, orgYY + this.cAlto + this.cAncho);
        }
        g.drawLine(orgXX, 0, orgXX, this.wAlto - this.cAlto);
        g.drawString("f", orgXX + this.cAncho, this.cAlto);
        for (int i = 0; i <= 65; i += 10) {
            y1 = orgYY - (int)((double)i * escalaYY);
            g.drawLine(orgXX, y1, orgXX - this.cAncho, y1);
            String str = String.valueOf(i);
            g.drawString(str, orgXX - g.getFontMetrics().stringWidth(str) - this.cAncho, y1 + this.cAlto / 2);
            for (int j = 1; j < 10; ++j) {
                y1 = orgYY - (int)((double)(i + j) * escalaYY);
                g.drawLine(orgXX, y1, orgXX - this.cAncho / 2, y1);
                if (j != 5) continue;
                g.drawLine(orgXX, y1, orgXX - 3 * this.cAncho / 4, y1);
            }
        }
        g.setColor(Color.red);
        for (int i = 0; i < this.nDatos; ++i) {
            x1 = orgXX + (int)(this.x[i] * (double)100 * escalaXX);
            y1 = orgYY - (int)(this.y[i] * escalaYY);
            g.fillOval(x1 - 2, y1 - 2, 4, 4);
        }
        x1 = orgXX + (int)((double)10 * escalaXX);
        y1 = orgYY - (int)(this.cte / 0.010000000000000002 * escalaYY);
        g.setColor(Color.blue);
        for (double x = 0.1; x < 0.2; x += 0.002) {
            int x2 = orgXX + (int)(x * (double)100 * escalaXX);
            int y2 = orgYY - (int)(this.cte / (x * x) * escalaYY);
            g.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
        }
    }
}

