/*
 * Decompiled with CFR 0.152.
 */
package movOndulatorio3;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import movOndulatorio3.MovOndulatorioApplet3;

public class MiCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    MovOndulatorioApplet3 parent;
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgXMicro;
    int orgYMicro;
    double escDistancia;
    double distancia = 11.33;
    boolean bArrastrar = false;
    Rectangle flecha1 = new Rectangle();
    int frecuencia = 3000;
    final double vSonido;
    int orgX;
    int orgY;
    double escalaX;
    double escalaY;
    final int PUNTOS = 100;
    int[] xTrayec = new int[101];
    int[] yTrayec = new int[101];
    int nPuntos = 0;
    int xMouse;
    boolean bOnda;
    boolean bRespuesta = false;
    double t;
    double dt;
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas(MovOndulatorioApplet3 p) {
        this.parent = p;
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.flecha1.setSize(8, 16);
        this.vSonido = (double)310 + (double)60 * Math.random();
        this.dt = 2.9411764705882355E-6;
    }

    void origenEscalas(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgX = 3 * this.wAncho / 4;
        this.orgY = this.wAlto / 2;
        this.escalaX = (double)((this.wAncho / 2 - 2 * this.cAncho) / 2) / 1.0;
        this.escalaY = (double)((this.wAlto - 4 * this.cAncho) / 2) / 1.0;
        this.orgXMicro = 2 * this.cAncho;
        this.orgYMicro = 2 * this.wAlto / 3;
        this.escDistancia = (double)(this.wAncho / 2 - 2 * this.cAncho) / 20.0;
        int x1 = this.orgXMicro + (int)(this.distancia * this.escDistancia);
        this.flecha1.setLocation(x1, this.orgYMicro + this.cAlto + this.cAncho / 2);
    }

    void setNuevo(int frec) {
        this.frecuencia = frec;
        this.calcula();
        this.t = 0.0;
        this.bRespuesta = false;
        this.repaint();
    }

    void setOnda(boolean bOnda) {
        this.bOnda = bOnda;
        this.repaint();
    }

    void setRespuesta() {
        this.bRespuesta = true;
        this.repaint();
    }

    void calcula() {
        double tt = 0.0;
        this.nPuntos = 0;
        double nOnda = Math.PI * 2 * (double)this.frecuencia / this.vSonido;
        for (int i = 0; i < 100; ++i) {
            double x = Math.sin(Math.PI * 2 * (tt += 0.01));
            double y = Math.sin(Math.PI * 2 * tt + nOnda * this.distancia / (double)100);
            this.yTrayec[i] = this.orgY - (int)(this.escalaY * y);
            this.xTrayec[i] = this.orgX + (int)(this.escalaX * x);
        }
    }

    void mover() {
        this.t += this.dt;
        ++this.nPuntos;
        if (this.nPuntos > 100) {
            this.nPuntos = 0;
        }
        this.repaint();
    }

    void composicion(Graphics g) {
        g.setColor(Color.cyan);
        g.fillRoundRect(this.wAncho / 2 + this.cAncho, this.cAncho, this.wAncho / 2 - 2 * this.cAncho, this.wAlto - 2 * this.cAncho, this.cAlto, this.cAlto);
        g.setColor(Color.black);
        g.drawRoundRect(this.wAncho / 2 + this.cAncho, this.cAncho, this.wAncho / 2 - 2 * this.cAncho, this.wAlto - 2 * this.cAncho, this.cAlto, this.cAlto);
        g.setColor(Color.lightGray);
        int nLineas = (this.wAncho - this.cAncho - this.orgX) / (2 * this.cAlto);
        for (int i = -nLineas; i <= nLineas; ++i) {
            g.drawLine(this.orgX + i * 2 * this.cAlto, this.cAncho, this.orgX + i * 2 * this.cAlto, this.wAlto - this.cAncho);
        }
        nLineas = (this.wAlto - this.cAncho - this.orgY) / (2 * this.cAlto);
        for (int i = -nLineas; i <= nLineas; ++i) {
            g.drawLine(this.wAncho / 2 + this.cAncho, this.orgY + i * 2 * this.cAlto, this.wAncho - this.cAncho, this.orgY + i * 2 * this.cAlto);
        }
        g.setColor(Color.black);
        int i = 0;
        for (i = 1; i < this.nPuntos; ++i) {
            g.drawLine(this.xTrayec[i - 1], this.yTrayec[i - 1], this.xTrayec[i], this.yTrayec[i]);
        }
        g.fillOval(this.xTrayec[i] - 2, this.yTrayec[i] - 2, 4, 4);
    }

    void microfono(Graphics g) {
        int x1;
        g.setColor(Color.black);
        g.drawLine(this.orgXMicro, this.orgYMicro, this.wAncho / 2, this.orgYMicro);
        for (int i = 0; i <= 20; i += 5) {
            x1 = this.orgXMicro + (int)(this.escDistancia * (double)i);
            g.drawLine(x1, this.orgYMicro - this.cAncho / 2, x1, this.orgYMicro + this.cAncho / 2);
            String etiqueta = String.valueOf(i);
            g.drawString(etiqueta, x1 - g.getFontMetrics().stringWidth(etiqueta) / 2, this.orgYMicro + this.cAlto);
            if (i == 50) break;
            for (int j = 1; j < 5; ++j) {
                x1 = this.orgXMicro + (int)(this.escDistancia * (double)(i + j));
                g.drawLine(x1, this.orgYMicro - this.cAncho / 4, x1, this.orgYMicro + this.cAncho / 4);
            }
        }
        g.drawString("cm", this.wAncho / 2 - 2 * this.cAncho, this.orgYMicro - this.cAncho);
        g.drawImage(this.parent.oscila, 0, 0, null);
        x1 = this.orgXMicro + (int)(this.escDistancia * this.distancia);
        g.drawLine(x1, this.orgYMicro, x1, this.parent.oscila.getHeight(this) + this.cAlto);
        g.drawLine(this.parent.oscila.getWidth(this) - 2 * this.cAlto, this.parent.oscila.getHeight(this), this.parent.oscila.getWidth(this) - 2 * this.cAlto, this.parent.oscila.getHeight(this) + this.cAlto);
        g.drawLine(x1, this.parent.oscila.getHeight(this) + this.cAlto, this.parent.oscila.getWidth(this) - 2 * this.cAlto, this.parent.oscila.getHeight(this) + this.cAlto);
        String texto = String.valueOf((double)Math.round(this.distancia * (double)10) / (double)10);
        g.drawString(texto, this.flecha1.x - g.getFontMetrics().stringWidth(texto) / 2, this.flecha1.y + this.flecha1.height + this.cAlto);
        g.setColor(Color.red);
        g.fillOval(x1 - this.cAncho / 2, this.orgYMicro - this.cAlto - this.cAncho, this.cAncho, this.cAncho);
        g.drawImage(this.parent.marca1, this.flecha1.x - this.flecha1.width / 2, this.flecha1.y, this);
        g.setColor(Color.blue);
        Polygon pol = new Polygon();
        pol.addPoint(this.orgXMicro - 2, this.orgYMicro - 2 * this.cAlto);
        pol.addPoint(this.orgXMicro - 2, this.orgYMicro + this.cAlto);
        pol.addPoint(this.orgXMicro - 2 * this.cAncho, this.orgYMicro + this.cAlto - this.cAncho);
        pol.addPoint(this.orgXMicro - 2 * this.cAncho, this.orgYMicro - 2 * this.cAlto + this.cAncho);
        g.fillPolygon(pol);
        g.setColor(Color.black);
        g.drawLine(this.cAncho / 2, this.orgYMicro - 2 * this.cAlto, this.cAncho / 2, this.parent.oscila.getHeight(this));
    }

    void onda(Graphics g) {
        int x2 = 0;
        int y2 = 0;
        double escOnda = 4 * this.cAlto;
        g.setColor(Color.black);
        g.drawLine(0, this.orgYMicro, this.wAncho / 2, this.orgYMicro);
        double nOnda = Math.PI * 2 * (double)this.frecuencia / this.vSonido;
        double y = Math.sin(nOnda * (this.distancia / (double)100 - this.vSonido * this.t));
        g.setColor(Color.red);
        int y1 = this.orgYMicro - (int)(y * escOnda);
        int x1 = this.orgXMicro + (int)(this.distancia * this.escDistancia);
        g.fillOval(x1 - this.cAncho / 2, y1 - this.cAncho / 2, this.cAncho, this.cAncho);
        y = Math.sin(nOnda * (0.0 - this.vSonido * this.t));
        x1 = this.orgXMicro;
        y1 = this.orgYMicro - (int)(y * escOnda);
        g.fillOval(x1 - this.cAncho / 2, y1 - this.cAncho / 2, this.cAncho, this.cAncho);
        g.setColor(Color.blue);
        for (double x = 0.0; x < 0.2; x += 0.005) {
            y = Math.sin(nOnda * (x - this.vSonido * this.t));
            x2 = this.orgXMicro + (int)(this.escDistancia * x * (double)100);
            y2 = this.orgYMicro - (int)(y * escOnda);
            g.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
        }
    }

    public void paint(Graphics g) {
        this.origenEscalas(g);
        this.update(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, d.width, d.height);
        if (this.bOnda) {
            this.onda(this.gBuffer);
        } else {
            this.microfono(this.gBuffer);
        }
        if (this.bRespuesta) {
            this.respuesta(this.gBuffer);
        }
        this.composicion(this.gBuffer);
        g.drawImage(this.imag, 0, 0, null);
    }

    public void mousePressed(MouseEvent ev) {
        this.bRespuesta = false;
        if (this.flecha1.contains(ev.getX(), ev.getY())) {
            this.xMouse = ev.getX();
            this.bArrastrar = true;
            this.parent.hilo.putMsg(0);
        }
    }

    public void mouseReleased(MouseEvent ev) {
        if (this.bArrastrar) {
            this.xMouse = ev.getX();
            this.distancia = (double)(this.xMouse - this.orgXMicro) / this.escDistancia;
            if (this.distancia < 0.0) {
                this.distancia = 0.0;
            }
            if (this.distancia > 50.0) {
                this.distancia = 50.0;
            }
            this.bArrastrar = false;
            this.calcula();
            this.parent.hilo.putMsg(2);
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent ev) {
        if (ev.getX() < this.orgXMicro || ev.getX() > this.wAncho / 2) {
            return;
        }
        if (this.bArrastrar) {
            this.flecha1.x = ev.getX();
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent ev) {
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseMoved(MouseEvent ev) {
    }

    void respuesta(Graphics g) {
        g.setColor(Color.black);
        Font oldFont = this.getFont();
        Font fuente = new Font("Times", 1, 16);
        g.setFont(fuente);
        int alto = g.getFontMetrics().getHeight();
        String texto = "la velocidad del sonido es";
        g.drawString(texto, this.cAlto, this.wAlto - alto - this.cAncho);
        texto = String.valueOf(String.valueOf(Math.round(this.vSonido))).concat(String.valueOf(" m/s"));
        g.drawString(texto, this.cAlto, this.wAlto - this.cAncho);
        g.setFont(oldFont);
    }
}

