/*
 * Decompiled with CFR 0.152.
 */
package doppler4;

import doppler4.DopplerApplet4;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;

public class MiCanvas
extends Canvas {
    DopplerApplet4 parent;
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgY;
    int orgX;
    double escala;
    double vEmisor;
    double vEspejo;
    double t;
    int xEmisor;
    int xEspejo;
    double xIniEmisor;
    double xIniEspejo;
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas(DopplerApplet4 p) {
        this.parent = p;
        this.setBackground(Color.white);
    }

    void setNuevo(double vEmisor, double vEspejo) {
        this.vEmisor = vEmisor;
        this.vEspejo = vEspejo;
        this.xIniEmisor = 0.0;
        this.xIniEspejo = vEspejo < 0.0 ? 5.5 : (1.0 - vEspejo) * (double)3;
        this.t = 0.0;
    }

    void origen(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgX = this.wAncho / 4;
        this.orgY = this.wAlto / 2;
        this.escala = (double)(this.wAncho - this.orgX) / (double)6;
    }

    void ejes(Graphics g) {
        g.setColor(Color.black);
        g.drawLine(0, this.orgY, this.wAncho, this.orgY);
        for (int i = -2; i < 6; ++i) {
            int x1 = this.orgX + (int)((double)i * this.escala);
            g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho);
            String texto = String.valueOf(i);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, this.orgY + this.cAlto + this.cAncho / 2);
            for (int j = 0; j < 10; ++j) {
                int x2 = x1 + (int)((double)j * this.escala / (double)10);
                g.drawLine(x2, this.orgY, x2, this.orgY + this.cAncho / 2);
                if (j != 5) continue;
                g.drawLine(x2, this.orgY, x2, this.orgY + 3 * this.cAncho / 4);
            }
        }
    }

    void mover() {
        this.xEmisor = this.orgX + (int)((this.xIniEmisor + this.vEmisor * this.t) * this.escala);
        this.xEspejo = this.orgX + (int)((this.xIniEspejo + this.vEspejo * this.t) * this.escala);
        if (this.xEspejo > this.wAncho || this.xEmisor > 5 * this.wAncho / 4 || this.xEspejo < 0 || this.xEmisor < -this.wAncho / 4) {
            this.parent.hilo.putMsg(0);
            return;
        }
        this.repaint();
        this.t += 0.005;
    }

    void funcionOnda(Graphics g) {
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        g.setColor(Color.red);
        if (this.vEmisor * this.t < this.xIniEspejo + this.vEspejo * this.t) {
            double xFin = 1.0 * this.t;
            if (1.0 * this.t >= this.xIniEspejo + this.vEspejo * this.t) {
                xFin = this.xIniEspejo + this.vEspejo * this.t;
            }
            x2 = this.orgX + (int)(this.vEmisor * this.t * this.escala);
            y2 = this.orgY - (int)((double)(3 * this.cAlto) * Math.cos(Math.PI * 2 * (this.vEmisor * this.t - 1.0 * this.t) / (1.0 - this.vEmisor)));
            for (double x = this.vEmisor * this.t; x < xFin; x += 0.01) {
                x1 = this.orgX + (int)(x * this.escala);
                y1 = this.orgY - (int)((double)(3 * this.cAlto) * Math.cos(Math.PI * 2 * (x - 1.0 * this.t) / (1.0 - this.vEmisor)));
                g.drawLine(x1, y1, x2, y2);
                x2 = x1;
                y2 = y1;
            }
            x1 = this.orgX + (int)(xFin * this.escala);
            y1 = this.orgY - (int)((double)(3 * this.cAlto) * Math.cos(Math.PI * 2 * (xFin - 1.0 * this.t) / (1.0 - this.vEmisor)));
            g.drawLine(x2, y2, x1, y1);
            if (1.0 * this.t >= this.xIniEspejo + this.vEspejo * this.t) {
                g.setColor(Color.blue);
                xFin = (double)2 * this.xIniEspejo * 1.0 / (1.0 - this.vEspejo) - 1.0 * this.t;
                x2 = this.orgX + (int)((this.xIniEspejo + this.vEspejo * this.t) * this.escala);
                y2 = this.orgY - (int)((double)(3 * this.cAlto) * Math.cos(Math.PI * 2 * (this.xIniEspejo + this.vEspejo * this.t + 1.0 * this.t) * (1.0 - this.vEspejo) / ((1.0 - this.vEmisor) * (1.0 + this.vEspejo))));
                for (double x = this.xIniEspejo + this.vEspejo * this.t; x > xFin; x -= 0.01) {
                    x1 = this.orgX + (int)(x * this.escala);
                    y1 = this.orgY - (int)((double)(3 * this.cAlto) * Math.cos(Math.PI * 2 * (x + 1.0 * this.t) * (1.0 - this.vEspejo) / ((1.0 - this.vEmisor) * (1.0 + this.vEspejo))));
                    g.drawLine(x1, y1, x2, y2);
                    x2 = x1;
                    y2 = y1;
                }
                x1 = this.orgX + (int)(xFin * this.escala);
                y1 = this.orgY - (int)((double)(3 * this.cAlto) * Math.cos(Math.PI * 2 * (xFin + 1.0 * this.t) * (1.0 - this.vEspejo) / ((1.0 - this.vEmisor) * (1.0 + this.vEspejo))));
                g.drawLine(x2, y2, x1, y1);
            }
        } else {
            double xFin = 1.0 * this.t - (1.0 - this.vEmisor) * this.xIniEspejo / (this.vEmisor - this.vEspejo);
            x2 = this.orgX + (int)(this.vEmisor * this.t * this.escala);
            y2 = this.orgY - (int)((double)(3 * this.cAlto) * Math.cos(Math.PI * 2 * (this.vEmisor * this.t - 1.0 * this.t) / (1.0 - this.vEmisor)));
            for (double x = this.vEmisor * this.t; x < xFin; x += 0.01) {
                x1 = this.orgX + (int)(x * this.escala);
                y1 = this.orgY - (int)((double)(3 * this.cAlto) * Math.cos(Math.PI * 2 * (x - 1.0 * this.t) / (1.0 - this.vEmisor)));
                g.drawLine(x1, y1, x2, y2);
                x2 = x1;
                y2 = y1;
            }
            x1 = this.orgX + (int)(xFin * this.escala);
            y1 = this.orgY - (int)((double)(3 * this.cAlto) * Math.cos(Math.PI * 2 * (xFin - 1.0 * this.t) / (1.0 - this.vEmisor)));
            g.drawLine(x1, y1, x2, y2);
            g.setColor(Color.blue);
            xFin = (double)2 * this.xIniEspejo * 1.0 / (1.0 - this.vEspejo) - 1.0 * this.t;
            double xIni = (1.0 + this.vEmisor) * this.xIniEspejo / (this.vEmisor - this.vEspejo) - 1.0 * this.t;
            x2 = this.orgX + (int)(xIni * this.escala);
            y2 = this.orgY - (int)((double)(3 * this.cAlto) * Math.cos(Math.PI * 2 * (xIni + 1.0 * this.t) * (1.0 - this.vEspejo) / ((1.0 - this.vEmisor) * (1.0 + this.vEspejo))));
            for (double x = xIni; x > xFin; x -= 0.01) {
                x1 = this.orgX + (int)(x * this.escala);
                y1 = this.orgY - (int)((double)(3 * this.cAlto) * Math.cos(Math.PI * 2 * (x + 1.0 * this.t) * (1.0 - this.vEspejo) / ((1.0 - this.vEmisor) * (1.0 + this.vEspejo))));
                g.drawLine(x1, y1, x2, y2);
                x2 = x1;
                y2 = y1;
            }
            x1 = this.orgX + (int)(xFin * this.escala);
            y1 = this.orgY - (int)((double)(3 * this.cAlto) * Math.cos(Math.PI * 2 * (xFin + 1.0 * this.t) * (1.0 - this.vEspejo) / ((1.0 - this.vEmisor) * (1.0 + this.vEspejo))));
            g.drawLine(x2, y2, x1, y1);
        }
    }

    void emiteOndas(Graphics g) {
        g.setColor(Color.red);
        g.fillOval(this.xEmisor - this.cAncho / 2, this.orgY + this.cAlto + this.cAncho / 2, this.cAncho, this.cAncho);
        g.drawLine(this.xEmisor, this.orgY, this.xEmisor, this.orgY + this.cAlto + this.cAncho);
        g.setColor(Color.blue);
        g.fillRect(this.xEspejo - 2, this.orgY - 4 * this.cAlto, 4, 8 * this.cAlto);
        g.setColor(Color.black);
        g.setColor(Color.black);
        Font oldFont = g.getFont();
        Font fuente = new Font("Times", 1, 14);
        g.setFont(fuente);
        g.drawString(String.valueOf("tiempo: ").concat(String.valueOf(String.valueOf((double)Math.round(this.t * (double)100) / (double)100))), this.cAncho, g.getFontMetrics().getHeight());
        double f = 1.0 * (1.0 - this.vEspejo) / ((1.0 - this.vEmisor) * (1.0 + this.vEspejo));
        g.drawString(String.valueOf("frecuencia: ").concat(String.valueOf(String.valueOf((double)Math.round(f * (double)100) / (double)100))), this.wAncho / 2, g.getFontMetrics().getHeight());
        g.setFont(oldFont);
    }

    public void paint(Graphics g) {
        this.origen(g);
        this.ejes(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, d.width, d.height);
        this.ejes(this.gBuffer);
        this.emiteOndas(this.gBuffer);
        this.funcionOnda(this.gBuffer);
        g.drawImage(this.imag, 0, 0, null);
    }
}

