/*
 * Decompiled with CFR 0.152.
 */
package refraccion1;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Vector;
import refraccion1.Reflexion;
import refraccion1.Refraccion;
import refraccion1.Snell;

public class MiCanvas
extends Canvas {
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgX;
    int orgY;
    double escalaX;
    double escalaY;
    long contador;
    boolean bReflexTotal = false;
    boolean bInvertir;
    double indiceIn;
    double indiceRe;
    double anguloIn;
    Vector ondas = new Vector(20, 5);
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas() {
        this.setBackground(Color.white);
    }

    void origenEscalas(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.escalaX = (double)(this.wAncho - 5 * this.cAncho) / 10.0;
        this.escalaY = (double)(this.wAlto - 2 * this.cAncho) / 10.0;
        this.orgX = this.wAncho / 2;
        this.orgY = this.wAlto / 2;
    }

    void setNuevo(int angulo, double indice, boolean bInvertir) {
        this.indiceIn = 1.0;
        this.indiceRe = indice;
        this.bReflexTotal = false;
        this.bInvertir = bInvertir;
        this.anguloIn = (double)angulo * Math.PI / (double)180;
        this.ondas.removeAllElements();
        if (bInvertir) {
            this.indiceIn = indice;
            this.indiceRe = 1.0;
            if (this.indiceIn * Math.sin(this.anguloIn) / this.indiceRe > 1.0) {
                this.bReflexTotal = true;
            }
        }
        this.contador = 0L;
        this.repaint();
    }

    void sistema(Graphics g) {
        int y1;
        int x1;
        Color color1 = Color.yellow;
        Color color2 = Color.cyan;
        if (this.bInvertir) {
            color1 = Color.cyan;
            color2 = Color.yellow;
        }
        g.setColor(color1);
        g.fillRect(0, 0, this.wAncho, this.wAlto / 2);
        g.setColor(color2);
        g.fillRect(0, this.wAlto / 2, this.wAncho, this.wAlto / 2);
        g.setColor(Color.black);
        g.drawLine(0, this.orgY, this.wAncho, this.orgY);
        String texto = String.valueOf((double)Math.round(Snell.anguloRe * (double)1800 / Math.PI) / (double)10);
        g.drawString(String.valueOf("\u00e1ngulo:").concat(String.valueOf(texto)), this.cAncho, this.orgY + this.cAlto);
        texto = String.valueOf((double)Math.round(this.anguloIn * (double)1800 / Math.PI) / (double)10);
        g.drawString(String.valueOf("\u00e1ngulo:").concat(String.valueOf(texto)), this.cAncho, this.orgY - this.cAncho);
        if (this.bReflexTotal) {
            x1 = this.orgX + (int)(5.0 * this.escalaX);
            y1 = this.orgY - (int)(5.0 * this.escalaY / Math.tan(Snell.anguloIn));
            g.drawLine(x1, y1, this.orgX, this.orgY);
            x1 = this.orgX + (int)(-5.0 * this.escalaX);
            g.drawLine(x1, y1, this.orgX, this.orgY);
        } else {
            x1 = this.orgX + (int)(5.0 * this.escalaX);
            y1 = this.orgY - (int)(5.0 * this.escalaY / Math.tan(Snell.anguloIn));
            g.drawLine(x1, y1, this.orgX, this.orgY);
            x1 = this.orgX + (int)(-5.0 * this.escalaX);
            y1 = this.orgY - (int)(-5.0 * this.escalaY / Math.tan(Snell.anguloRe));
            g.drawLine(x1, y1, this.orgX, this.orgY);
        }
        g.setColor(Color.red);
        Enumeration enumeration = this.ondas.elements();
        while (enumeration.hasMoreElements()) {
            Snell obj = (Snell)enumeration.nextElement();
            x1 = this.orgX + (int)(obj.xA * this.escalaX);
            y1 = this.orgY - (int)(obj.yA * this.escalaY);
            int x2 = this.orgX + (int)(obj.xB * this.escalaX);
            int y2 = this.orgY - (int)(obj.yB * this.escalaY);
            int x0 = this.orgX + (int)(obj.xI * this.escalaX);
            switch (obj.opcion) {
                case 0: {
                    g.drawLine(x1, y1, x2, y2);
                    break;
                }
                case 1: {
                    g.drawLine(x1, y1, x0, this.orgY);
                    g.drawLine(x2, y2, x0, this.orgY);
                    break;
                }
                case 2: {
                    g.drawLine(x1, y1, x0, this.orgY);
                    g.drawLine(x2, y2, x0, this.orgY);
                    break;
                }
                case 3: {
                    g.drawLine(x1, y1, x2, y2);
                    break;
                }
                case 4: {
                    break;
                }
            }
            x1 = this.orgX + (int)(obj.xC * this.escalaX);
            y1 = this.orgY - (int)(obj.yC * this.escalaY);
            g.fillOval(x1 - 2, y1 - 2, 4, 4);
        }
    }

    void mover() {
        if (this.contador % (long)10 == (long)0) {
            if (this.bReflexTotal) {
                this.ondas.addElement(new Reflexion(this.anguloIn, 1.0 / this.indiceIn));
            } else {
                this.ondas.addElement(new Refraccion(this.anguloIn, 1.0 / this.indiceIn, 1.0 / this.indiceRe));
            }
        }
        Enumeration enumeration = this.ondas.elements();
        while (enumeration.hasMoreElements()) {
            Snell obj = (Snell)enumeration.nextElement();
            if (obj.opcion == 4) {
                this.ondas.removeElement(obj);
            }
            obj.mover();
        }
        ++this.contador;
        this.repaint();
    }

    public void paint(Graphics g) {
        this.origenEscalas(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, d.width, d.height);
        this.sistema(this.gBuffer);
        g.drawImage(this.imag, 0, 0, null);
    }
}

