/*
 * Decompiled with CFR 0.152.
 */
package doppler2;

import doppler2.DopplerApplet2;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;

public class MiCanvas
extends Canvas {
    DopplerApplet2 parent;
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgY;
    int orgX;
    int orgXgraf;
    int orgYgraf;
    double escala;
    double escX;
    double escY;
    final double rDisco = 1.0;
    final int frecuencia = 4;
    double velocidad = 0.5;
    double t;
    double angulo;
    Polygon pol = new Polygon();
    Polygon polFrec = new Polygon();
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas(DopplerApplet2 p) {
        this.parent = p;
        this.setBackground(Color.white);
    }

    void setNuevo(double velocidad) {
        this.velocidad = velocidad;
        this.t = 0.0;
        this.frecuencia();
        this.repaint();
    }

    void origen(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgX = this.wAncho / 4;
        this.orgY = this.wAlto / 2;
        this.orgYgraf = 2 * this.wAlto / 3;
        this.escala = (double)(this.wAncho / 2 - 2 * this.cAlto) / 2.0;
        this.orgXgraf = (int)((double)this.orgX + 1.0 * this.escala + (double)(10 * this.cAncho));
        this.escX = (double)(this.wAncho - this.orgXgraf - 2 * this.cAncho) / (Math.PI * 2);
        this.escY = (double)(2 * this.wAlto / 3) / 15.0;
    }

    void frecuencia() {
        this.polFrec.npoints = 0;
        int x1 = 0;
        this.polFrec.npoints = 0;
        for (double tt = 0.0; tt < Math.PI * 2; tt += 0.10471975511965977) {
            x1 = this.orgXgraf + (int)(tt * this.escX);
            int y1 = this.orgYgraf - (int)(this.funcion(tt / this.velocidad) * this.escY);
            this.polFrec.addPoint(x1, y1);
        }
        this.polFrec.addPoint(x1, this.polFrec.ypoints[0]);
    }

    double funcion(double tt) {
        double y = 1.0 / (0.25 + 4.0 * Math.sin(this.velocidad / (double)16) * Math.cos(this.velocidad / (double)16 + this.velocidad * tt / (double)2));
        return y;
    }

    void graficaFrec(Graphics g) {
        int y1;
        String texto;
        int x1;
        g.setColor(Color.black);
        g.drawLine(this.orgXgraf, this.orgYgraf, this.wAncho, this.orgYgraf);
        g.drawString("f '", this.orgXgraf + this.cAncho, this.cAlto);
        g.setColor(Color.black);
        g.drawString(String.valueOf("tiempo:").concat(String.valueOf(String.valueOf(Math.floor(this.t * (double)100) / (double)100))), this.wAncho - 11 * this.cAncho, this.cAlto);
        for (int i = 1; i <= 2; ++i) {
            x1 = this.orgXgraf + (int)((double)i * this.escX * Math.PI);
            g.drawLine(x1, this.orgYgraf, x1, this.orgYgraf + this.cAncho);
            texto = String.valueOf(String.valueOf(i)).concat(String.valueOf("pi"));
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, this.orgYgraf + this.cAlto + this.cAncho / 2);
            for (int j = 0; j < 2; ++j) {
                x1 = this.orgXgraf + (int)((double)(i + j) * this.escX * Math.PI / (double)2);
                g.drawLine(x1, this.orgYgraf, x1, this.orgYgraf + this.cAncho / 2);
            }
        }
        g.drawLine(this.orgXgraf, 0, this.orgXgraf, this.orgYgraf);
        for (int i = 0; i <= 16; i += 4) {
            y1 = this.orgYgraf - (int)((double)i * this.escY);
            g.drawLine(this.orgXgraf, y1, this.orgXgraf - this.cAncho, y1);
            texto = String.valueOf(i);
            g.drawString(texto, this.orgXgraf - this.cAncho - g.getFontMetrics().stringWidth(texto), y1 + this.cAlto / 2);
            for (int j = 1; j < 4; ++j) {
                y1 = this.orgYgraf - (int)((double)(i + j) * this.escY);
                g.drawLine(this.orgXgraf, y1, this.orgXgraf - this.cAncho / 2, y1);
            }
        }
        g.setColor(Color.red);
        g.drawPolyline(this.polFrec.xpoints, this.polFrec.ypoints, this.polFrec.npoints);
        double ang = this.velocidad * this.t % (Math.PI * 2);
        x1 = this.orgXgraf + (int)(ang * this.escX);
        y1 = this.orgYgraf - (int)(this.funcion(ang / this.velocidad) * this.escY);
        g.fillOval(x1 - 2, y1 - 2, 4, 4);
        g.setColor(Color.black);
        int y2 = y1;
        do {
            g.drawLine(x1, y2, x1, y2 + this.cAncho / 2);
        } while ((y2 += this.cAncho) < this.orgYgraf);
        int x2 = x1;
        do {
            g.drawLine(x2, y1, x2 - this.cAncho / 2, y1);
        } while ((x2 -= this.cAncho) > this.orgXgraf);
    }

    void mover() {
        this.angulo = this.velocidad * this.t;
        this.t += 0.01;
        this.repaint();
    }

    void emiteOndas(Graphics g) {
        g.setClip(0, 0, this.orgXgraf - 2 * this.cAncho, this.wAlto - 2 * this.cAlto - this.cAncho);
        Polygon barra = new Polygon();
        double coseno = Math.cos(this.angulo);
        double seno = Math.sin(this.angulo);
        int x1 = this.orgX + (int)((1.0 * coseno - 0.05 * seno) * this.escala);
        int y1 = this.orgY - (int)((1.0 * seno + 0.05 * coseno) * this.escala);
        barra.addPoint(x1, y1);
        x1 = this.orgX + (int)((1.0 * coseno + 0.05 * seno) * this.escala);
        y1 = this.orgY - (int)((1.0 * seno - 0.05 * coseno) * this.escala);
        barra.addPoint(x1, y1);
        x1 = this.orgX - (int)((1.0 * coseno - 0.05 * seno) * this.escala);
        y1 = this.orgY + (int)((1.0 * seno + 0.05 * coseno) * this.escala);
        barra.addPoint(x1, y1);
        x1 = this.orgX - (int)((1.0 * coseno + 0.05 * seno) * this.escala);
        y1 = this.orgY + (int)((1.0 * seno - 0.05 * coseno) * this.escala);
        barra.addPoint(x1, y1);
        g.setColor(Color.gray);
        g.fillPolygon(barra);
        g.setColor(Color.black);
        g.fillOval(this.orgX - 4, this.orgY - 4, 8, 8);
        double pendienteRecta = 1.0 / Math.tan(this.velocidad * this.t / (double)2);
        if (Math.abs(pendienteRecta) > (double)100) {
            x1 = this.orgX + (int)(1.0 * this.escala);
            g.drawLine(x1, 0, x1, this.wAlto);
        } else {
            x1 = this.orgX + (int)(2.0 * this.escala);
            y1 = this.orgY + (int)(this.escala * 1.0 * pendienteRecta);
            int x2 = this.orgX - (int)(2.0 * this.escala);
            int y2 = this.orgY - (int)(this.escala * (double)3 * 1.0 * pendienteRecta);
            g.drawLine(x1, y1, x2, y2);
        }
        g.setColor(Color.blue);
        x1 = this.orgX + (int)(1.0 * this.escala);
        g.fillOval(x1 - this.cAncho / 2, this.orgY - this.cAncho / 2, this.cAncho, this.cAncho);
        g.setColor(Color.red);
        x1 = this.orgX + (int)(1.0 * this.escala * coseno);
        y1 = this.orgY - (int)(1.0 * seno * this.escala);
        g.fillOval(x1 - this.cAncho / 2, y1 - this.cAncho / 2, this.cAncho, this.cAncho);
        int lon = (int)((double)(3 * this.cAlto) * Math.cos(this.velocidad * this.t / (double)2));
        double ang = (Math.PI + this.velocidad * this.t) / (double)2;
        if (lon < 0) {
            lon = -lon;
            ang = Math.PI + ang;
        }
        this.dibujaFlecha(g, 1.5707963267948966 + this.velocidad * this.t, x1, y1, 3 * this.cAlto, Color.black);
        this.dibujaFlecha(g, ang, x1, y1, lon, Color.red);
        g.setColor(Color.red);
        for (double tt = 0.0; tt < this.t; tt += 0.25) {
            ang = this.velocidad * tt;
            int radio = (int)((this.t - tt) * this.escala);
            x1 = this.orgX + (int)(1.0 * this.escala * Math.cos(ang));
            y1 = this.orgY - (int)(1.0 * this.escala * Math.sin(ang));
            if (radio > this.wAncho / 2) continue;
            g.drawOval(x1 - radio, y1 - radio, 2 * radio, 2 * radio);
        }
    }

    void funcOnda(Graphics g) {
        int x2;
        int y1;
        g.setClip(0, 0, this.wAncho, this.wAlto);
        this.pol.npoints = 0;
        int x1 = this.orgX + (int)(1.0 * this.escala);
        double dist = 2.0 * Math.sin(this.velocidad * this.t / (double)2 % Math.PI);
        for (double tt = 0.0; tt < this.t; tt += 0.01) {
            y1 = this.wAlto - this.cAlto - 2 - (int)((double)this.cAlto * Math.cos(Math.PI * 8 * tt));
            x2 = x1 - (int)(this.distEmisor(tt, -1) * this.escala);
            if (x2 <= 0 && x2 >= this.wAncho) continue;
            this.pol.addPoint(x2, y1);
        }
        for (double tt = this.t - 0.01; tt > 0.0; tt -= 0.01) {
            y1 = this.wAlto - this.cAlto - 2 - (int)((double)this.cAlto * Math.cos(Math.PI * 8 * tt));
            x2 = x1 - (int)(this.distEmisor(tt, 1) * this.escala);
            if (x2 <= 0 && x2 >= this.wAncho) continue;
            this.pol.addPoint(x2, y1);
        }
        g.setColor(Color.blue);
        g.fillOval(x1 - this.cAncho / 2, this.wAlto - this.cAlto - this.cAncho / 2, this.cAncho, this.cAncho);
        g.setColor(Color.red);
        x2 = x1 - (int)(dist * this.escala);
        g.fillOval(x2 - this.cAncho / 2, this.wAlto - this.cAlto - this.cAncho / 2, this.cAncho, this.cAncho);
        g.setColor(Color.black);
        g.drawPolyline(this.pol.xpoints, this.pol.ypoints, this.pol.npoints);
        g.drawLine(0, this.wAlto - 2 * this.cAlto - this.cAncho - 1, this.wAncho, this.wAlto - 2 * this.cAlto - this.cAncho - 1);
    }

    double distEmisor(double tt, int j) {
        double m = 1.0 / Math.tan(this.velocidad * this.t / (double)2);
        double a = 1.0 + m * m;
        double b = -2.0 * Math.cos(this.velocidad * tt) - (double)2 * m * m * 1.0 + (double)2 * m * 1.0 * Math.sin(this.velocidad * tt);
        double c = 1.0 * (1.0 + m * m) - (double)2 * m * 1.0 * 1.0 * Math.sin(this.velocidad * tt) - (tt - this.t) * (tt - this.t);
        double x = (-b + (double)j * Math.sqrt(b * b - (double)4 * a * c)) / ((double)2 * a);
        double y = m * (-x + 1.0);
        double xOnda = Math.sqrt((1.0 - x) * (1.0 - x) + y * y);
        if (x > 1.0) {
            xOnda = -xOnda;
        }
        return xOnda;
    }

    void dibujaFlecha(Graphics g, double fi, int x1, int y1, int longitud, Color color) {
        int cap = g.getFontMetrics().stringWidth("0");
        if (longitud < cap) {
            return;
        }
        int x2 = x1 + (int)((double)longitud * Math.cos(fi));
        int y2 = y1 - (int)((double)longitud * Math.sin(fi));
        g.setColor(color);
        g.fillOval(x1 - 2, y1 - 2, 4, 4);
        if (longitud == 0) {
            return;
        }
        g.drawLine(x1, y1, x2, y2);
        int x3 = x2 - (int)((double)cap * Math.cos(fi - 0.5235987755982988));
        int y3 = y2 + (int)((double)cap * Math.sin(fi - 0.5235987755982988));
        g.drawLine(x2, y2, x3, y3);
        x3 = x2 - (int)((double)cap * Math.sin(-fi + 1.0471975511965976));
        y3 = y2 + (int)((double)cap * Math.cos(-fi + 1.0471975511965976));
        g.drawLine(x2, y2, x3, y3);
    }

    public void paint(Graphics g) {
        this.origen(g);
        this.emiteOndas(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, d.width, d.height);
        this.emiteOndas(this.gBuffer);
        this.funcOnda(this.gBuffer);
        this.graficaFrec(this.gBuffer);
        g.drawImage(this.imag, 0, 0, null);
    }
}

