/*
 * Decompiled with CFR 0.152.
 */
package adiabatico4;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MiCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    int cAncho;
    int cAlto;
    int wAncho;
    int wAlto;
    int orgX;
    int orgY;
    double escala;
    double lonOnda;
    double yNivel;
    int nArmonico;
    boolean bOnda = false;
    boolean bArrastrar = false;
    Rectangle rect = new Rectangle();
    int yPos;
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas() {
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    void origenEscalas(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgX = 3 * this.wAncho / 4;
        this.orgY = 2 * this.cAlto;
        this.rect.setBounds(this.orgX + 3 * this.cAlto, this.orgY - this.cAncho, 2 * this.cAncho, 2 * this.cAncho);
        this.escala = (double)(this.wAlto - this.cAlto - this.orgY) / 100.0;
    }

    void setNuevo(int frecuencia) {
        this.lonOnda = 34000.0 / (double)frecuencia;
        this.bArrastrar = false;
        this.yNivel = 0.0;
        this.nArmonico = 0;
        this.bOnda = false;
        this.rect.y = this.orgY - this.rect.height / 2;
        this.repaint();
    }

    void recipiente(Graphics g) {
        g.setColor(Color.black);
        g.drawRect(this.orgX - this.wAncho / 2, this.orgY, this.wAncho / 2, this.wAlto - this.cAlto - this.orgY);
        g.setColor(this.getBackground());
        g.drawLine(this.orgX - this.wAncho / 2, this.orgY, this.orgX, this.orgY);
        g.setColor(Color.cyan);
        int y1 = this.rect.y + this.rect.height / 2;
        g.fillRect(this.orgX - this.wAncho / 2 + 1, y1, this.wAncho / 2 - 2, this.wAlto - this.cAlto - y1 - 1);
        g.setColor(Color.black);
        for (int i = 0; i <= 100; i += 10) {
            y1 = this.orgY + (int)((double)i * this.escala);
            g.drawLine(this.orgX, y1, this.orgX + this.cAncho, y1);
            String texto = String.valueOf(i);
            g.drawString(texto, this.orgX + this.cAncho, y1 + this.cAlto / 4);
            if (i == 100) break;
            for (int j = 1; j < 10; ++j) {
                y1 = this.orgY + (int)((double)(i + j) * this.escala);
                g.drawLine(this.orgX, y1, this.orgX + this.cAncho / 2, y1);
                if (j != 5) continue;
                g.drawLine(this.orgX, y1, this.orgX + 3 * this.cAncho / 4, y1);
            }
        }
        g.drawString("cm", this.orgX + this.cAncho, this.wAlto);
        g.setColor(Color.black);
        g.drawLine(this.wAncho / 2 - this.cAncho / 2, this.wAlto - this.cAlto - 2 * this.cAncho, this.wAncho / 2 - this.cAncho / 2, this.wAlto);
        g.drawLine(this.wAncho / 2 + this.cAncho / 2, this.wAlto - this.cAlto - 2 * this.cAncho, this.wAncho / 2 + this.cAncho / 2, this.wAlto);
        g.setColor(Color.cyan);
        g.fillRect(this.wAncho / 2 - this.cAncho / 2 + 1, this.wAlto - this.cAlto, this.cAncho - 2, this.cAlto);
        g.setColor(Color.black);
        g.fillOval(this.wAncho / 2 - this.cAncho, this.wAlto - this.cAlto - this.cAncho, 2 * this.cAncho, 2 * this.cAncho);
        g.setColor(Color.white);
        if (this.bArrastrar) {
            g.fillRect(this.wAncho / 2 - 2, this.wAlto - this.cAlto - this.cAncho / 2, 4, this.cAncho);
        } else {
            g.fillRect(this.wAncho / 2 - this.cAncho / 2, this.wAlto - this.cAlto - 2, this.cAncho, 4);
        }
        g.setColor(Color.red);
        g.fillOval(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
        g.drawLine(this.rect.x, this.rect.y + this.rect.height / 2, this.orgX + this.cAncho, this.rect.y + this.rect.height / 2);
    }

    void diapason(Graphics g) {
        g.setColor(Color.black);
        g.drawLine(this.orgX - 3 * this.cAlto, this.cAncho - 1, this.orgX, this.cAncho - 1);
        g.drawLine(this.orgX - 3 * this.cAlto, this.cAncho, this.orgX, this.cAncho);
        g.drawLine(this.orgX - 3 * this.cAlto, 2 * this.cAncho, this.orgX, 2 * this.cAncho);
        g.drawLine(this.orgX - 3 * this.cAlto, 2 * this.cAncho + 1, this.orgX, 2 * this.cAncho + 1);
        g.drawArc(this.orgX - 2, this.cAncho, this.cAncho, this.cAncho, -90, 180);
        g.drawArc(this.orgX - 1, this.cAncho - 1, this.cAncho + 2, this.cAncho + 2, -90, 180);
        g.fillRect(this.orgX + this.cAncho, 3 * this.cAncho / 2 - 2, 2 * this.cAlto, 4);
    }

    void dibujaOnda(Graphics g) {
        double y = 0.0;
        int y1 = this.rect.y + this.rect.height / 2;
        int x1 = this.wAncho / 2;
        int x3 = this.wAncho / 2;
        g.setColor(Color.red);
        for (double x = 0.0; x < this.yNivel; x += 0.5) {
            y = Math.sin(Math.PI * 2 * x / this.lonOnda);
            int x2 = this.wAncho / 2 + (int)((double)(4 * this.cAlto) * y);
            int y2 = this.rect.y + this.rect.height / 2 - (int)(this.escala * x);
            g.drawLine(x1, y1, x2, y2);
            int x4 = this.wAncho / 2 - (int)((double)(4 * this.cAlto) * y);
            g.drawLine(x3, y1, x4, y2);
            x1 = x2;
            y1 = y2;
            x3 = x4;
        }
    }

    void dispositivo(Graphics g) {
        this.diapason(g);
        this.recipiente(g);
        if (this.bOnda) {
            this.dibujaOnda(g);
        }
    }

    public void paint(Graphics g) {
        this.origenEscalas(g);
        this.dispositivo(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, d.width, d.height);
        this.dispositivo(this.gBuffer);
        g.drawImage(this.imag, 0, 0, null);
    }

    public void mousePressed(MouseEvent ev) {
        if (this.rect.contains(ev.getX(), ev.getY())) {
            this.yPos = ev.getY();
            this.bArrastrar = true;
        }
    }

    public void mouseReleased(MouseEvent ev) {
        this.bArrastrar = false;
        this.verificar();
    }

    public void mouseDragged(MouseEvent ev) {
        int y2 = ev.getY();
        if (this.bArrastrar && ev.getY() > this.orgY - this.cAncho / 2 && ev.getY() < this.wAlto - this.cAlto) {
            this.verificar();
            this.rect.y = this.rect.y + y2 - this.yPos;
            this.yPos = y2;
            this.repaint();
        }
    }

    void verificar() {
        this.yNivel = (double)(this.rect.y + this.rect.height / 2 - this.orgY) / this.escala;
        this.nArmonico = (int)Math.round(this.yNivel * (double)4 / this.lonOnda);
        this.bOnda = false;
        if (this.nArmonico % 2 == 1 && Math.abs(this.yNivel - (double)this.nArmonico * this.lonOnda / (double)4) < 0.5) {
            this.bOnda = true;
        }
    }

    public void mouseClicked(MouseEvent ev) {
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseMoved(MouseEvent ev) {
    }
}

