/*
 * Decompiled with CFR 0.152.
 */
package interferencia2;

import interferencia2.InterferenciaApplet2;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MiCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    InterferenciaApplet2 parent;
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgY;
    int orgX;
    double escala;
    int frecuencia;
    final double velocidad = 340.0;
    final double amplitud = 0.0125;
    double xRegla = 0.085;
    double t;
    double dt = 5.0E-6;
    int xMarca;
    boolean bArrastrar = false;
    Rectangle flecha = new Rectangle();
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas(InterferenciaApplet2 p) {
        this.parent = p;
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    void setNuevo(int frecuencia) {
        this.frecuencia = frecuencia;
        this.t = 0.0;
    }

    void origen(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgX = this.wAncho / 3;
        this.orgY = this.wAlto / 2;
        this.escala = (double)(this.orgX - this.cAncho) / 0.6;
        this.flecha.setSize(2 * this.cAncho, 2 * this.cAncho);
        this.flecha.x = this.orgX + (int)((this.xRegla + 0.6) * this.escala) - this.cAncho;
        this.flecha.y = this.orgY + (int)(0.35 * this.escala) + 2 + this.cAlto + this.cAncho;
    }

    void mover() {
        this.repaint();
        this.t += this.dt;
    }

    void dispositivo(Graphics g) {
        String texto;
        g.setColor(Color.black);
        int x1 = this.orgX - (int)(0.5 * this.escala);
        int y1 = this.orgY + (int)(0.25 * this.escala);
        g.drawLine(this.orgX, y1, x1, y1);
        y1 = this.orgY + (int)(0.35 * this.escala);
        x1 = this.orgX - (int)(0.6 * this.escala);
        g.drawLine(this.orgX - this.cAncho, y1, x1, y1);
        g.drawLine(this.orgX - this.cAncho, y1 + 5 * this.cAncho, this.orgX - this.cAncho, y1);
        int y2 = this.orgY - (int)(0.35 * this.escala);
        g.drawLine(x1, y1, x1, y1);
        x1 = this.orgX - (int)(0.5 * this.escala);
        y1 = this.orgY + (int)(0.25 * this.escala);
        y2 = this.orgY - (int)(0.25 * this.escala);
        g.drawLine(x1, y1, x1, y2);
        x1 = this.orgX - (int)(0.6 * this.escala);
        y1 = this.orgY + (int)(0.35 * this.escala);
        y2 = this.orgY - (int)(0.35 * this.escala);
        g.drawLine(x1, y1, x1, y2);
        g.drawLine(x1, y2, this.orgX - this.cAncho, y2);
        g.drawLine(this.orgX - this.cAncho, y2, this.orgX - this.cAncho, this.cAncho);
        x1 = this.orgX - (int)(0.5 * this.escala);
        y1 = this.orgY - (int)(0.25 * this.escala);
        g.drawLine(x1, y1, this.orgX, y1);
        x1 = this.orgX + (int)(0.5 * this.escala);
        y1 = this.orgY - (int)(0.35 * this.escala);
        g.drawLine(x1, y1, this.orgX + this.cAncho, y1);
        g.drawLine(this.orgX + this.cAncho, y1, this.orgX + this.cAncho, this.cAncho);
        y1 = this.orgY - (int)(0.25 * this.escala);
        g.drawLine(x1, y1, this.orgX, y1);
        x1 = this.orgX + (int)(0.5 * this.escala);
        y1 = this.orgY + (int)(0.35 * this.escala);
        g.drawLine(x1, y1, this.orgX + this.cAncho, y1);
        g.drawLine(this.orgX + this.cAncho, y1, this.orgX + this.cAncho, y1 + 5 * this.cAncho);
        y1 = this.orgY + (int)(0.25 * this.escala);
        g.drawLine(x1, y1, this.orgX, y1);
        x1 = this.orgX + (int)(0.6 * this.escala);
        int x2 = this.orgX + (int)(1.2 * this.escala);
        y1 = this.orgY + (int)(0.35 * this.escala) + 4;
        g.setColor(Color.yellow);
        g.fillRect(x1 - this.cAlto, y1, x2 - x1 + this.cAlto, 3 * this.cAlto);
        g.setColor(Color.black);
        for (int i = 0; i <= 5; ++i) {
            x1 = this.orgX + (int)((0.6 + 0.1 * (double)i) * this.escala);
            g.drawLine(x1, y1, x1, y1 + this.cAncho);
            texto = String.valueOf(i * 10);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, y1 + this.cAncho + this.cAlto);
            if (i == 5) break;
            for (int j = 1; j < 5; ++j) {
                x1 = this.orgX + (int)((0.6 + 0.1 * (double)i + 0.02 * (double)j) * this.escala);
                g.drawLine(x1, y1, x1, y1 + this.cAncho / 2);
            }
        }
        g.drawString("cm", x2 - 2 * this.cAncho, y1 - 2);
        x1 = this.orgX + (int)((0.5 + this.xRegla) * this.escala);
        x2 = this.orgX + (int)(this.xRegla * this.escala) + this.cAncho + 4;
        y1 = this.orgY - (int)(0.25 * this.escala) + 2;
        g.drawLine(x1, y1, x2, y1);
        y1 = this.orgY + (int)(0.25 * this.escala) - 2;
        g.drawLine(x1, y1, x2, y1);
        x1 = this.orgX + (int)((0.6 + this.xRegla) * this.escala);
        y1 = this.orgY - (int)(0.35 * this.escala) - 2;
        g.drawLine(x1, y1, x2, y1);
        y1 = this.orgY + (int)(0.35 * this.escala) + 2;
        g.drawLine(x1, y1, x2, y1);
        x1 = this.orgX + (int)((0.5 + this.xRegla) * this.escala);
        y1 = this.orgY - (int)(0.25 * this.escala) + 2;
        y2 = this.orgY + (int)(0.25 * this.escala) - 2;
        g.drawLine(x1, y1, x1, y2);
        x1 = this.orgX + (int)((0.6 + this.xRegla) * this.escala);
        y1 = this.orgY - (int)(0.35 * this.escala) - 2;
        y2 = this.orgY + (int)(0.35 * this.escala) + 2;
        g.drawLine(x1, y1, x1, y2);
        g.setColor(Color.red);
        g.fillOval(this.flecha.x, this.flecha.y, this.flecha.width, this.flecha.height);
        g.drawLine(this.flecha.x + this.flecha.width / 2, this.flecha.y, this.flecha.x + this.flecha.width / 2, this.flecha.y - this.cAlto);
        g.setColor(Color.black);
        texto = String.valueOf((double)Math.round(this.xRegla * (double)1000) / (double)10);
        g.drawString(texto, this.flecha.x + this.flecha.width, this.flecha.y - this.cAncho - this.cAlto - 2);
    }

    void particulasIzq(Graphics g) {
        double dx;
        int x1 = 0;
        int y1 = 0;
        g.setColor(Color.red);
        for (double x = 0.0; x < 1.6570796326794897; x += 0.025) {
            int j;
            dx = 0.0125 * Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (x - 340.0 * this.t));
            if (x + dx > 0.5 && x + dx < 0.5785398163397448) {
                double ang = (x + dx - 0.5) / 0.05;
                for (j = -1; j <= 1; ++j) {
                    x1 = this.orgX - (int)((0.5 + (0.05 + (double)j * 0.025) * Math.sin(ang)) * this.escala);
                    y1 = this.orgY + (int)((0.25 + (0.05 + (double)j * 0.025) * Math.cos(ang)) * this.escala);
                    g.fillOval(x1 - 2, y1 - 2, 4, 4);
                }
                continue;
            }
            if (x + dx > 0.5785398163397448 && x + dx < 1.0785398163397448) {
                y1 = this.orgY - (int)((x + dx - 0.25 - 0.5785398163397448) * this.escala);
                for (int j2 = -1; j2 <= 1; ++j2) {
                    x1 = this.orgX - (int)((0.55 + (double)j2 * 0.025) * this.escala);
                    g.fillOval(x1 - 2, y1 - 2, 4, 4);
                }
                continue;
            }
            if (x + dx > 1.0785398163397448 && x + dx < 1.1570796326794897) {
                double ang = (x + dx - 1.0785398163397448) / 0.05;
                for (j = -1; j <= 1; ++j) {
                    x1 = this.orgX - (int)((0.5 + (0.05 + (double)j * 0.025) * Math.cos(ang)) * this.escala);
                    y1 = this.orgY - (int)((0.25 + (0.05 + (double)j * 0.025) * Math.sin(ang)) * this.escala);
                    g.fillOval(x1 - 2, y1 - 2, 4, 4);
                }
                continue;
            }
            if (x + dx > 1.1570796326794897 && x + dx < 1.6570796326794897) {
                x1 = this.orgX + (int)((x + dx - 0.5 - 1.1570796326794897) * this.escala);
                for (int j3 = -1; j3 <= 1; ++j3) {
                    y1 = this.orgY - (int)((0.3 + (double)j3 * 0.025) * this.escala);
                    g.fillOval(x1 - 2, y1 - 2, 4, 4);
                }
                continue;
            }
            x1 = this.orgX - (int)((x + dx) * this.escala);
            for (int j4 = -1; j4 <= 1; ++j4) {
                y1 = this.orgY + (int)((0.3 + 0.025 * (double)j4) * this.escala);
                g.fillOval(x1 - 2, y1 - 2, 4, 4);
            }
        }
        x1 = this.orgX - (int)(0.49 * this.escala);
        g.setColor(Color.black);
        g.drawLine(x1, this.orgY, this.orgX, this.orgY);
        g.setColor(Color.red);
        int x2 = this.orgX + (int)(-0.45 * this.escala);
        dx = 0.05 * Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (1.2070796326794897 - 340.0 * this.t));
        int y2 = this.orgY - (int)(dx * this.escala);
        for (double z = -0.45; z < 0.0; z += 0.005) {
            dx = 0.05 * Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (1.6570796326794897 + z - 340.0 * this.t));
            y1 = this.orgY - (int)(dx * this.escala);
            x1 = this.orgX + (int)(z * this.escala);
            g.drawLine(x1, y1, x2, y2);
            x2 = x1;
            y2 = y1;
        }
        x1 = this.orgX;
        dx = 0.05 * Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (1.6570796326794897 - 340.0 * this.t));
        y1 = this.orgY - (int)(dx * this.escala);
        g.drawLine(x1, y1, x2, y2);
        g.fillOval(x1 - 2, y1 - 2, 4, 4);
        g.setColor(Color.black);
        x1 = this.orgX;
        for (y1 = this.orgY - (int)(0.2 * this.escala); y1 < this.orgY + (int)(0.2 * this.escala); y1 += this.cAncho) {
            g.drawLine(x1, y1, x1, y1 + this.cAncho / 2);
        }
        dx = 0.0125 * Math.sin(Math.PI * -2 * (double)this.frecuencia * this.t);
        y1 = this.orgY + (int)((0.375 + dx) * this.escala) + this.cAncho;
        g.fillRect(this.orgX - this.cAncho, y1 - 2, 2 * this.cAncho, 4);
    }

    void particulasDcha(Graphics g) {
        double dx;
        int x1 = 0;
        int y1 = 0;
        g.setColor(Color.blue);
        for (double x = 0.0; x < 1.6570796326794897 + (double)2 * this.xRegla; x += 0.025) {
            int j;
            dx = 0.0125 * Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (x - 340.0 * this.t));
            if (x + dx > 0.5 + this.xRegla && x + dx < 0.5 + this.xRegla + 0.07853981633974483) {
                double ang = (x + dx - 0.5 - this.xRegla) / 0.05;
                for (j = -1; j <= 1; ++j) {
                    x1 = this.orgX + (int)((0.5 + this.xRegla + (0.05 + (double)j * 0.025) * Math.sin(ang)) * this.escala);
                    y1 = this.orgY + (int)((0.25 + (0.05 + (double)j * 0.025) * Math.cos(ang)) * this.escala);
                    g.fillOval(x1 - 2, y1 - 2, 4, 4);
                }
                continue;
            }
            if (x + dx > 0.5 + this.xRegla + 0.07853981633974483 && x + dx < 1.0 + this.xRegla + 0.07853981633974483) {
                y1 = this.orgY - (int)((x + dx - 0.25 - (0.5 + this.xRegla + 0.07853981633974483)) * this.escala);
                for (int j2 = -1; j2 <= 1; ++j2) {
                    x1 = this.orgX + (int)((this.xRegla + 0.55 + (double)j2 * 0.025) * this.escala);
                    g.fillOval(x1 - 2, y1 - 2, 4, 4);
                }
                continue;
            }
            if (x + dx > 1.0 + this.xRegla + 0.07853981633974483 && x + dx < 1.0 + this.xRegla + 0.15707963267948966) {
                double ang = (x + dx - (1.0 + this.xRegla + 0.07853981633974483)) / 0.05;
                for (j = -1; j <= 1; ++j) {
                    x1 = this.orgX + (int)((0.5 + this.xRegla + (0.05 + (double)j * 0.025) * Math.cos(ang)) * this.escala);
                    y1 = this.orgY - (int)((0.25 + (0.05 + (double)j * 0.025) * Math.sin(ang)) * this.escala);
                    g.fillOval(x1 - 2, y1 - 2, 4, 4);
                }
                continue;
            }
            if (x + dx > 1.0 + this.xRegla + 0.15707963267948966 && x + dx < 1.5 + (double)2 * this.xRegla + 0.15707963267948966) {
                x1 = this.orgX + (int)((-x - dx + 0.5 + this.xRegla + (1.0 + this.xRegla + 0.15707963267948966)) * this.escala);
                for (int j3 = -1; j3 <= 1; ++j3) {
                    y1 = this.orgY - (int)((0.3 + (double)j3 * 0.025) * this.escala);
                    g.fillOval(x1 - 2, y1 - 2, 4, 4);
                }
                continue;
            }
            x1 = this.orgX + (int)((x + dx) * this.escala);
            for (int j4 = -1; j4 <= 1; ++j4) {
                y1 = this.orgY + (int)((0.3 + 0.025 * (double)j4) * this.escala);
                g.fillOval(x1 - 2, y1 - 2, 4, 4);
            }
        }
        x1 = this.orgX + (int)(0.49 * this.escala);
        g.setColor(Color.black);
        g.drawLine(x1, this.orgY, this.orgX, this.orgY);
        g.setColor(Color.blue);
        int x2 = this.orgX + (int)(0.45 * this.escala);
        dx = 0.05 * Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (1.6570796326794897 + (double)2 * this.xRegla - 0.45 - 340.0 * this.t));
        int y2 = this.orgY - (int)(dx * this.escala);
        for (double z = 0.45; z > 0.0; z -= 0.005) {
            dx = 0.05 * Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (1.6570796326794897 + (double)2 * this.xRegla - z - 340.0 * this.t));
            y1 = this.orgY - (int)(dx * this.escala);
            x1 = this.orgX + (int)(z * this.escala);
            g.drawLine(x1, y1, x2, y2);
            x2 = x1;
            y2 = y1;
        }
        x1 = this.orgX;
        dx = 0.05 * Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (1.6570796326794897 + (double)2 * this.xRegla - 340.0 * this.t));
        y1 = this.orgY - (int)(dx * this.escala);
        g.drawLine(x1, y1, x2, y2);
        g.fillOval(x1 - 2, y1 - 2, 4, 4);
        dx = 0.0125 * Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (1.6570796326794897 - 340.0 * this.t)) + 0.0125 * Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (1.6570796326794897 + (double)2 * this.xRegla - 340.0 * this.t));
        y1 = this.orgY - (int)((0.375 + dx) * this.escala) - this.cAncho;
        g.setColor(Color.black);
        g.fillRect(this.orgX - this.cAncho, y1 - 2, 2 * this.cAncho, 4);
    }

    public void paint(Graphics g) {
        this.origen(g);
        this.dispositivo(g);
        this.particulasIzq(g);
        this.particulasDcha(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, this.wAncho, this.wAlto);
        this.dispositivo(this.gBuffer);
        this.particulasIzq(this.gBuffer);
        this.particulasDcha(this.gBuffer);
        g.drawImage(this.imag, 0, 0, null);
    }

    public void mousePressed(MouseEvent ev) {
        if (this.flecha.contains(ev.getX(), ev.getY())) {
            this.xMarca = ev.getX();
            this.bArrastrar = true;
        }
    }

    public void mouseReleased(MouseEvent ev) {
        if (this.bArrastrar) {
            this.bArrastrar = false;
            this.flecha.x += ev.getX() - this.xMarca;
            this.xRegla = (double)(this.flecha.x + this.flecha.width / 2 - this.orgX) / this.escala - 0.6;
            if (this.xRegla < 0.0) {
                this.xRegla = 0.0;
            }
            if (this.xRegla > 0.45) {
                this.xRegla = 0.45;
            }
            this.flecha.x = this.orgX + (int)((this.xRegla + 0.6) * this.escala) - this.flecha.width / 2;
        }
        this.xMarca = ev.getX();
        this.repaint();
    }

    public void mouseDragged(MouseEvent ev) {
        int x1 = this.orgX + (int)(1.05 * this.escala);
        int x2 = this.orgX + (int)(0.6 * this.escala);
        if (this.bArrastrar && this.flecha.x + this.flecha.width / 2 <= x1 && this.flecha.x + this.flecha.width / 2 >= x2) {
            this.flecha.x += ev.getX() - this.xMarca;
            this.xRegla = (double)(this.flecha.x + this.flecha.width / 2 - this.orgX) / this.escala - 0.6;
            if (this.xRegla < 0.0) {
                this.xRegla = 0.0;
            }
            if (this.xRegla > 0.45) {
                this.xRegla = 0.45;
            }
            this.flecha.x = this.orgX + (int)((this.xRegla + 0.6) * this.escala) - this.flecha.width / 2;
        }
        this.xMarca = ev.getX();
        this.repaint();
    }

    public void mouseClicked(MouseEvent ev) {
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseMoved(MouseEvent ev) {
    }
}

