/*
 * Decompiled with CFR 0.152.
 */
package ondasEstacionarias3;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class MiCanvas
extends Canvas {
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgY;
    int orgX;
    int orgYY;
    double escalaX;
    double escalaY;
    double frecuencia;
    final double v1 = 1.0;
    double t;
    double dt;
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas() {
        this.setBackground(Color.white);
        this.dt = 0.01;
    }

    void setNuevo(double frecuencia) {
        this.frecuencia = frecuencia;
        this.t = 0.0;
    }

    void origen(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgX = this.wAncho - this.cAlto;
        this.orgY = this.wAlto / 6 + this.cAlto;
        this.orgYY = 2 * this.wAlto / 3;
        this.escalaX = (double)(this.wAncho - this.cAlto) / 7.0;
        this.escalaY = this.wAlto / 6 - this.cAlto;
    }

    void ejes(Graphics g) {
        int x2;
        String texto;
        int x1;
        g.setColor(Color.pink);
        g.fillRect(this.orgX, 0, this.wAncho - this.orgX, this.wAlto);
        g.setColor(Color.black);
        g.drawLine(0, this.orgY, this.wAncho, this.orgY);
        g.drawLine(0, this.orgYY, this.wAncho, this.orgYY);
        for (int i = -7; i <= 0; ++i) {
            x1 = this.orgX + (int)((double)i * this.escalaX);
            g.drawLine(x1, this.orgY - this.cAncho, x1, this.orgY + this.cAncho);
            texto = String.valueOf(i);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, this.orgY + this.cAlto + this.cAncho / 2);
            if (i == 3) break;
            for (int j = 0; j < 5; ++j) {
                x2 = x1 + (int)((double)j * this.escalaX / (double)5);
                g.drawLine(x2, this.orgY - this.cAncho / 2, x2, this.orgY + this.cAncho / 2);
            }
        }
        for (int i = -7; i <= 0; ++i) {
            x1 = this.orgX + (int)((double)i * this.escalaX);
            g.drawLine(x1, this.orgYY - this.cAncho, x1, this.orgYY + this.cAncho);
            texto = String.valueOf(i);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, this.orgYY + this.cAlto + this.cAncho / 2);
            if (i == 0) break;
            for (int j = 0; j < 5; ++j) {
                x2 = x1 + (int)((double)j * this.escalaX / (double)5);
                g.drawLine(x2, this.orgYY - this.cAncho / 2, x2, this.orgYY + this.cAncho / 2);
            }
        }
    }

    void mover() {
        this.repaint();
        this.t += this.dt;
    }

    void ondaIncidente(Graphics g) {
        double x = -7.0;
        double y = Math.sin(Math.PI * 2 * this.frecuencia / 1.0 * (x - 1.0 * this.t));
        int x1 = this.orgX + (int)(this.escalaX * x);
        int y1 = this.orgY - (int)(y * this.escalaY);
        g.setColor(Color.red);
        for (x = -7.0; x < 0.0; x += 0.02) {
            y = Math.sin(Math.PI * 2 * this.frecuencia / 1.0 * (x - 1.0 * this.t));
            int x2 = this.orgX + (int)(this.escalaX * x);
            int y2 = this.orgY - (int)(y * this.escalaY);
            g.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
        }
        this.dibujaFlecha(g, Color.red, "incidente", true, this.cAncho, this.wAlto - this.cAlto);
        g.setColor(Color.black);
        g.drawString(String.valueOf("Longitud de onda : ").concat(String.valueOf(String.valueOf(Math.floor(100.0 / this.frecuencia) / (double)100))), this.cAncho, this.cAlto);
    }

    void ondaIncidenteReflejada(Graphics g) {
        double x = -7.0;
        double y = Math.sin(Math.PI * 2 * this.frecuencia / 1.0 * (x + 1.0 * this.t)) + Math.sin(Math.PI * 2 * this.frecuencia / 1.0 * (x - 1.0 * this.t));
        int x1 = this.orgX + (int)(this.escalaX * x);
        int y1 = this.orgYY - (int)(y * this.escalaY);
        g.setColor(Color.black);
        for (x = -7.0; x < 0.0; x += 0.02) {
            y = Math.sin(Math.PI * 2 * this.frecuencia / 1.0 * (x + 1.0 * this.t)) + Math.sin(Math.PI * 2 * this.frecuencia / 1.0 * (x - 1.0 * this.t));
            int x2 = this.orgX + (int)(this.escalaX * x);
            int y2 = this.orgYY - (int)(y * this.escalaY);
            g.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
        }
        this.dibujaFlecha(g, Color.black, "incidente+reflejada", true, this.orgX - 20 * this.cAncho, this.wAlto - this.cAlto);
    }

    void ondaReflejada(Graphics g) {
        double x = -7.0;
        double y = Math.sin(Math.PI * 2 * this.frecuencia / 1.0 * (x + 1.0 * this.t));
        int x1 = this.orgX + (int)(this.escalaX * x);
        int y1 = this.orgY - (int)(y * this.escalaY);
        g.setColor(Color.blue);
        for (x = -7.0; x < 0.0; x += 0.02) {
            y = Math.sin(Math.PI * 2 * this.frecuencia / 1.0 * (x + 1.0 * this.t));
            int x2 = this.orgX + (int)(this.escalaX * x);
            int y2 = this.orgY - (int)(y * this.escalaY);
            g.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
        }
        this.dibujaFlecha(g, Color.blue, "reflejada", false, 30 * this.cAncho, this.wAlto - this.cAlto);
    }

    private void dibujaFlecha(Graphics g, Color color, String texto, boolean orientacion, int x1, int y1) {
        int lon = 4 * this.cAncho;
        double fi = 0.0;
        fi = orientacion ? 0.0 : Math.PI;
        int x2 = x1 + (int)((double)lon * Math.cos(fi));
        g.setColor(Color.black);
        if (orientacion) {
            g.drawString(texto, x2 + this.cAncho, y1 + this.cAlto / 2);
        } else {
            g.drawString(texto, x2 - this.cAncho - g.getFontMetrics().stringWidth(texto), y1 + this.cAlto / 2);
        }
        g.setColor(color);
        g.drawLine(x1, y1, x2, y1);
        g.drawLine(x1, y1 - 1, x2, y1 - 1);
        g.drawLine(x1, y1 + 1, x2, y1 + 1);
        int x3 = x2 - (int)((double)(this.cAncho + this.cAncho / 2) * Math.cos(fi - 0.5235987755982988));
        int y3 = y1 + (int)((double)(this.cAncho + this.cAncho / 2) * Math.sin(fi - 0.5235987755982988));
        g.drawLine(x2, y1, x3, y3);
        g.drawLine(x2 - 1, y1, x3 - 1, y3);
        x3 = x2 - (int)((double)(this.cAncho + this.cAncho / 2) * Math.sin(-fi + 1.0471975511965976));
        y3 = y1 + (int)((double)(this.cAncho + this.cAncho / 2) * Math.cos(-fi + 1.0471975511965976));
        g.drawLine(x2, y1, x3, y3);
        g.drawLine(x2 - 1, y1, x3 - 1, y3);
    }

    public void paint(Graphics g) {
        this.origen(g);
        this.ejes(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, this.wAncho, this.wAlto);
        this.ejes(this.gBuffer);
        this.ondaIncidente(this.gBuffer);
        this.ondaReflejada(this.gBuffer);
        this.ondaIncidenteReflejada(this.gBuffer);
        g.drawImage(this.imag, 0, 0, null);
    }
}

