/*
 * Decompiled with CFR 0.152.
 */
package fourier;

public abstract class Fourier {
    static final int MAX_ARMONICOS = 11;
    double[] a = new double[11];
    double[] b = new double[11];
    double[] x;
    int nDiscont;
    int iDiscont;
    double P;
    int iArmonico = 0;
    int q = 1;
    int[] nDivisiones;

    public Fourier(double[] tiempo, int nDiscont) {
        this.nDiscont = nDiscont;
        this.P = tiempo[nDiscont - 1] - tiempo[0];
        this.x = new double[nDiscont];
        this.x[0] = -Math.PI;
        this.x[nDiscont - 1] = Math.PI;
        for (int i = 1; i < nDiscont - 1; ++i) {
            this.x[i] = (tiempo[i] - tiempo[0]) * (double)2 * Math.PI / (tiempo[nDiscont - 1] - tiempo[0]) - Math.PI;
        }
        for (int i = 0; i < 11; ++i) {
            this.b[i] = 0.0;
            this.a[i] = 0.0;
        }
        this.nDivisiones = new int[nDiscont - 1];
    }

    void setDiscontinuidad(int iDiscont) {
        this.iDiscont = iDiscont;
    }

    private double integral(double a, double b, int n) {
        if (n % 2 == 1) {
            ++n;
        }
        double h = (b - a) / (double)n;
        double s = this.f(a) - this.f(b);
        for (int i = 1; i < n; i += 2) {
            s += (double)4 * this.f(a + (double)i * h) + (double)2 * this.f(a + (double)(i + 1) * h);
        }
        return s * h / (double)3;
    }

    abstract double funcion(double var1);

    double f(double x) {
        double y = this.funcion(x * this.P / (Math.PI * 2)) * Math.sin((double)this.iArmonico * x + (double)this.q * Math.PI / (double)2);
        return y;
    }

    void calcular() {
        for (int i = 0; i < this.nDiscont - 1; ++i) {
            this.nDivisiones[i] = (int)((this.x[i + 1] - this.x[i]) * (double)50 / Math.PI);
        }
        this.q = 1;
        this.iArmonico = 0;
        while (this.iArmonico < 11) {
            this.iDiscont = 0;
            while (this.iDiscont < this.nDiscont - 1) {
                int n = this.iArmonico;
                this.a[n] = this.a[n] + this.integral(this.x[this.iDiscont], this.x[this.iDiscont + 1], this.nDivisiones[this.iDiscont]) / Math.PI;
                ++this.iDiscont;
            }
            ++this.iArmonico;
        }
        this.q = 0;
        this.iArmonico = 0;
        while (this.iArmonico < 11) {
            this.iDiscont = 0;
            while (this.iDiscont < this.nDiscont - 1) {
                int n = this.iArmonico;
                this.b[n] = this.b[n] + this.integral(this.x[this.iDiscont], this.x[this.iDiscont + 1], this.nDivisiones[this.iDiscont]) / Math.PI;
                ++this.iDiscont;
            }
            ++this.iArmonico;
        }
    }

    double valorMaximo() {
        double maximo = 0.0;
        for (int i = 0; i < 11; ++i) {
            if (Math.abs(this.a[i]) > maximo) {
                maximo = Math.abs(this.a[i]);
            }
            if (!(Math.abs(this.b[i]) > maximo)) continue;
            maximo = Math.abs(this.b[i]);
        }
        return maximo;
    }
}

