/*
 * Decompiled with CFR 0.152.
 */
package fourier;

import fourier.Fourier;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;

public class MiCanvas
extends Canvas {
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgY;
    int orgX;
    int orgYA;
    int orgXA;
    int orgXB;
    int orgYC;
    double escalaX;
    int escalaY;
    int iArmonico;
    Fourier analisis;

    public MiCanvas() {
        this.setBackground(Color.white);
    }

    void setNuevo(Fourier analisis) {
        this.analisis = analisis;
        analisis.calcular();
        this.iArmonico = -1;
        this.dibujaTodo();
    }

    void setArmonico(int iArmonico) {
        this.iArmonico = iArmonico;
        this.dibujaTodo();
    }

    void origen(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgX = this.wAncho / 2;
        this.orgY = this.wAlto / 4;
        this.escalaX = (double)(this.wAncho - 8 * this.cAncho) / (Math.PI * 2);
        this.escalaY = 4 * this.cAlto;
        this.orgYA = 5 * this.wAlto / 8;
        this.orgXA = 4 * this.cAncho;
        this.orgXB = this.wAncho / 2 + 4 * this.cAncho;
        this.orgYC = 7 * this.wAlto / 8;
    }

    void dibujaTodo() {
        Graphics g = this.getGraphics();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.wAncho, this.wAlto);
        if (this.iArmonico >= 0) {
            this.dibujaResultante(g);
            this.dibujaArmonicos(g);
            this.dibujaCoeficientes(g);
        }
        this.dibujaFuncion(g);
        g.dispose();
    }

    void dibujaFuncion(Graphics g) {
        int x1 = this.orgX;
        int y1 = this.orgY;
        g.setColor(Color.black);
        this.analisis.setDiscontinuidad(0);
        double x = -Math.PI;
        x1 = this.orgX + (int)(x * this.escalaX);
        y1 = this.orgY - (int)(this.analisis.funcion(x * this.analisis.P / (Math.PI * 2)) * (double)this.escalaY);
        for (int i = 0; i < this.analisis.nDiscont - 1; ++i) {
            this.analisis.setDiscontinuidad(i);
            for (x = this.analisis.x[i]; x < this.analisis.x[i + 1]; x += 0.031415926535897934) {
                int x2 = this.orgX + (int)(x * this.escalaX);
                int y2 = this.orgY - (int)(this.analisis.funcion(x * this.analisis.P / (Math.PI * 2)) * (double)this.escalaY);
                g.drawLine(x1, y1, x2, y2);
                x1 = x2;
                y1 = y2;
            }
        }
    }

    void dibujaResultante(Graphics g) {
        g.setColor(Color.magenta);
        if (this.iArmonico == 0) {
            int y1 = this.orgY - (int)(this.analisis.a[0] * (double)this.escalaY / (double)2);
            int x1 = this.orgX - (int)(this.escalaX * Math.PI);
            int x2 = this.orgX + (int)(this.escalaX * Math.PI);
            g.drawLine(x1, y1, x2, y1);
        } else {
            double x = -Math.PI;
            double suma = this.analisis.a[0] / (double)2;
            for (int i = 1; i <= this.iArmonico; ++i) {
                suma += this.analisis.a[i] * Math.cos((double)i * x);
            }
            int x1 = this.orgX + (int)(x * this.escalaX);
            int y1 = this.orgY - (int)(suma * (double)this.escalaY);
            for (x = -Math.PI; x < Math.PI; x += 0.031415926535897934) {
                suma = this.analisis.a[0] / (double)2;
                for (int i = 1; i <= this.iArmonico; ++i) {
                    suma += this.analisis.a[i] * Math.cos((double)i * x) + this.analisis.b[i] * Math.sin((double)i * x);
                }
                int x2 = this.orgX + (int)(x * this.escalaX);
                int y2 = this.orgY - (int)(suma * (double)this.escalaY);
                g.drawLine(x1, y1, x2, y2);
                x1 = x2;
                y1 = y2;
            }
        }
    }

    void dibujaArmonicos(Graphics g) {
        g.setColor(Color.black);
        int x1 = this.orgX - (int)(this.escalaX * Math.PI);
        int x2 = this.orgX + (int)(this.escalaX * Math.PI);
        g.drawLine(x1, this.orgYA, x2, this.orgYA);
        g.drawString(String.valueOf("Arm\u00f3nico: ").concat(String.valueOf(String.valueOf(this.iArmonico))), this.cAncho, this.cAlto);
        if (this.iArmonico == 0) {
            g.setColor(Color.blue);
            String texto = String.valueOf("a[0]=").concat(String.valueOf(String.valueOf(Math.floor(this.analisis.a[0] * (double)1000) / (double)1000)));
            g.drawString(texto, this.cAncho, this.orgYA - 5 * this.cAlto);
            int y1 = this.orgYA - (int)(this.analisis.a[0] * (double)this.escalaY / (double)2);
            x1 = this.orgX - (int)(this.escalaX * Math.PI);
            x2 = this.orgX + (int)(this.escalaX * Math.PI);
            g.drawLine(x1, y1, x2, y1);
        } else {
            int y2;
            g.setColor(Color.blue);
            String texto = String.valueOf(String.valueOf(String.valueOf("a[").concat(String.valueOf(this.iArmonico))).concat(String.valueOf("]="))).concat(String.valueOf(String.valueOf(Math.floor(this.analisis.a[this.iArmonico] * (double)1000) / (double)1000)));
            g.drawString(texto, this.cAncho, this.orgYA - 5 * this.cAlto);
            double x = -Math.PI;
            x1 = this.orgX + (int)(x * this.escalaX);
            double y = this.analisis.a[this.iArmonico] * Math.cos((double)this.iArmonico * x);
            int y1 = this.orgYA - (int)(y * (double)this.escalaY);
            for (x = -Math.PI; x < Math.PI; x += 0.031415926535897934) {
                y = this.analisis.a[this.iArmonico] * Math.cos((double)this.iArmonico * x);
                x2 = this.orgX + (int)(x * this.escalaX);
                y2 = this.orgYA - (int)(y * (double)this.escalaY);
                g.drawLine(x1, y1, x2, y2);
                x1 = x2;
                y1 = y2;
            }
            g.setColor(Color.red);
            texto = String.valueOf(String.valueOf(String.valueOf("b[").concat(String.valueOf(this.iArmonico))).concat(String.valueOf("]="))).concat(String.valueOf(String.valueOf(Math.floor(this.analisis.b[this.iArmonico] * (double)1000) / (double)1000)));
            g.drawString(texto, this.wAncho - g.getFontMetrics().stringWidth(texto) - this.cAncho, this.orgYA - 5 * this.cAlto);
            x = -Math.PI;
            x1 = this.orgX + (int)(x * this.escalaX);
            y = this.analisis.b[this.iArmonico] * Math.sin((double)this.iArmonico * x);
            y1 = this.orgYA - (int)(y * (double)this.escalaY);
            for (x = -Math.PI; x < Math.PI; x += 0.031415926535897934) {
                y = this.analisis.b[this.iArmonico] * Math.sin((double)this.iArmonico * x);
                x2 = this.orgX + (int)(x * this.escalaX);
                y2 = this.orgYA - (int)(y * (double)this.escalaY);
                g.drawLine(x1, y1, x2, y2);
                x1 = x2;
                y1 = y2;
            }
        }
    }

    void dibujaCoeficientes(Graphics g) {
        int y1;
        int x1;
        double escalaXC = (double)(this.wAncho / 2 - 4 * this.cAncho) / (this.analisis.P * (double)11);
        double escalaYC = (double)(4 * this.cAlto) / this.analisis.valorMaximo();
        g.setColor(Color.black);
        g.drawLine(this.orgXA, this.orgYC, this.wAncho / 2, this.orgYC);
        g.drawLine(this.orgXB, this.orgYC, this.wAncho, this.orgYC);
        g.setColor(Color.blue);
        for (int i = 0; i <= this.iArmonico; ++i) {
            x1 = this.orgXA + (int)((double)i * escalaXC);
            y1 = this.orgYC - (int)(this.analisis.a[i] * escalaYC);
            g.drawLine(x1, this.orgYC, x1, y1);
        }
        g.setColor(Color.red);
        for (int i = 1; i <= this.iArmonico; ++i) {
            x1 = this.orgXB + (int)((double)i * escalaXC);
            y1 = this.orgYC - (int)(this.analisis.b[i] * escalaYC);
            g.drawLine(x1, this.orgYC, x1, y1);
        }
    }

    public void paint(Graphics g) {
        this.origen(g);
    }
}

