/*
 * Decompiled with CFR 0.152.
 */
package interferencia;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class MiCanvas
extends Canvas {
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgY;
    int orgX;
    double d = 0.5;
    int N = 4;
    final int FACTOR = 10;
    int escala = 500;
    double escY;
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas() {
        this.setBackground(Color.white);
    }

    void setNuevo(double separacion, int num, int esc) {
        this.d = separacion;
        this.N = num;
        this.escala = esc * 10;
        this.repaint();
    }

    void setEscala(int esc) {
        this.escala = esc * 10;
        this.repaint();
    }

    void origen(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgX = this.wAncho / 2;
        this.orgY = this.wAlto / 2;
        this.escY = this.wAlto / 3;
    }

    void fuentes(Graphics g) {
        g.setColor(Color.blue);
        int y1 = this.orgY + (int)((double)(this.N - 1) * this.d * (double)this.cAlto / (double)2);
        for (int i = 0; i < this.N; ++i) {
            g.fillOval(this.orgX - 2, y1 - 2, 4, 4);
            y1 -= (int)(this.d * (double)this.cAlto);
        }
    }

    void diagrama(Graphics g) {
        g.setColor(Color.red);
        double alfa = 0.0;
        double r = this.intensidad(alfa);
        int x1 = this.orgX - (int)(r * (double)this.escala);
        int y1 = this.orgY;
        for (double angulo = -Math.PI; angulo < Math.PI; angulo += Math.PI / 180) {
            alfa = Math.PI * this.d * Math.sin(angulo);
            r = this.intensidad(alfa);
            int x2 = this.orgX + (int)(r * Math.cos(angulo) * (double)this.escala);
            int y2 = this.orgY - (int)(r * Math.sin(angulo) * (double)this.escala);
            g.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
        }
        g.setColor(Color.black);
        g.drawString("m\u00e1ximos", this.cAncho, this.cAlto);
        int i = 0;
        while ((double)i / this.d <= 1.0) {
            double ang = Math.asin((double)i / this.d) * (double)180 / Math.PI;
            String texto = String.valueOf((double)Math.round(ang * (double)10) / (double)10);
            g.drawString(texto, this.cAncho, (2 * i + 2) * this.cAlto);
            texto = String.valueOf((double)Math.round(((double)180 - ang) * (double)10) / (double)10);
            g.drawString(texto, this.cAncho, (2 * i + 3) * this.cAlto);
            ++i;
        }
    }

    double intensidad(double x) {
        if (Math.abs(Math.sin(x)) < 1.0E-4 && Math.abs(Math.sin((double)this.N * x)) < 1.0E-4) {
            return 1.0;
        }
        double y = Math.sin((double)this.N * x) * Math.sin((double)this.N * x) / ((double)this.N * Math.sin(x) * (double)this.N * Math.sin(x));
        return y;
    }

    void dispositivo(Graphics g) {
        this.fuentes(g);
        this.diagrama(g);
    }

    public void paint(Graphics g) {
        this.origen(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, d.width, d.height);
        this.dispositivo(this.gBuffer);
        g.drawImage(this.imag, 0, 0, null);
    }
}

