/*
 * Decompiled with CFR 0.152.
 */
package ondasEstacionarias;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;

public class MiCanvas
extends Canvas {
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgY;
    int orgX;
    int escalaX;
    int escalaY;
    double velocidad;
    double fAngular;
    final double amortiguamiento = 0.2;
    final double xFuente = 0.3;
    double t;
    double dt;
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas() {
        this.setBackground(Color.white);
    }

    void setNuevo(double velocidad, double frecuencia) {
        this.velocidad = velocidad;
        this.fAngular = Math.PI * 2 * frecuencia;
        this.dt = 1.0 / frecuencia / (double)20;
        this.t = 0.0;
    }

    void setEscala(int esc) {
        this.escalaY = 2 * this.cAlto * esc;
        this.repaint();
    }

    void origen(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgX = 4 * this.cAncho;
        this.orgY = this.wAlto / 2;
        this.escalaX = this.wAncho - 8 * this.cAncho;
        this.escalaY = 80 * this.cAlto;
        g.setColor(Color.blue);
        g.drawLine(this.orgX, this.orgY, this.wAncho - 4 * this.cAncho, this.orgY);
    }

    synchronized void mover() {
        this.repaint();
        this.t += this.dt;
    }

    synchronized void onda(Graphics g) {
        int x1 = this.orgX;
        int y1 = this.orgY;
        g.setColor(Color.blue);
        for (double x = 0.0; x < 1.0; x += 0.02) {
            double realY = Math.cos(this.fAngular * this.t) * this.realSuma(x) - Math.sin(this.fAngular * this.t) * this.imgSuma(x);
            int x2 = this.orgX + (int)((double)this.escalaX * x);
            int y2 = this.orgY - (int)(realY * (double)this.escalaY);
            g.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
        }
        g.drawLine(x1, y1, this.wAncho - 4 * this.cAncho, this.orgY);
    }

    double realSuma(double x) {
        double rSuma = 0.0;
        for (int i = 1; i < 51; ++i) {
            double numerador = Math.sin((double)i * Math.PI * 0.3) * Math.sin((double)i * Math.PI * x) * ((double)(i * i) * Math.PI * Math.PI * this.velocidad * this.velocidad - this.fAngular * this.fAngular);
            double denominador = ((double)(i * i) * Math.PI * Math.PI * this.velocidad * this.velocidad - this.fAngular * this.fAngular) * ((double)(i * i) * Math.PI * Math.PI * this.velocidad * this.velocidad - this.fAngular * this.fAngular) - (double)4 * this.fAngular * this.fAngular * 0.2 * 0.2;
            rSuma += numerador / denominador;
        }
        return rSuma;
    }

    double imgSuma(double x) {
        double iSuma = 0.0;
        for (int i = 1; i < 51; ++i) {
            double numerador = -Math.sin((double)i * Math.PI * 0.3) * Math.sin((double)i * Math.PI * x) * ((double)2 * this.fAngular * 0.2);
            double denominador = ((double)(i * i) * Math.PI * Math.PI * this.velocidad * this.velocidad - this.fAngular * this.fAngular) * ((double)(i * i) * Math.PI * Math.PI * this.velocidad * this.velocidad - this.fAngular * this.fAngular) - (double)4 * this.fAngular * this.fAngular * 0.2 * 0.2;
            iSuma += numerador / denominador;
        }
        return iSuma;
    }

    void fuente(Graphics g) {
        int x1 = this.orgX + (int)(0.3 * (double)this.escalaX);
        g.setColor(Color.black);
        g.fillRect(x1 - 2 * this.cAlto, this.wAlto - 2 * this.cAlto, 4 * this.cAlto, 2 * this.cAlto);
        double realY = Math.cos(this.fAngular * this.t) * this.realSuma(0.3) - Math.sin(this.fAngular * this.t) * this.imgSuma(0.3);
        int y1 = this.orgY - (int)(realY * (double)this.escalaY);
        g.setColor(Color.red);
        g.fillOval(x1 - this.cAncho / 2, y1 - this.cAncho / 2, this.cAncho, this.cAncho);
        g.drawLine(x1, y1, x1, this.wAlto - 2 * this.cAlto);
    }

    void extremos(Graphics g) {
        g.setColor(Color.black);
        g.fillRect(this.orgX - 2 * this.cAlto, this.orgY - 2 * this.cAlto, 2 * this.cAlto, 4 * this.cAlto);
        g.drawOval(this.wAncho - 4 * this.cAncho - this.cAlto, this.orgY, 2 * this.cAlto, 2 * this.cAlto);
        g.fillOval(this.wAncho - 4 * this.cAncho - this.cAncho / 2, this.orgY + this.cAlto - this.cAncho / 2, this.cAncho, this.cAncho);
        g.setColor(Color.blue);
        g.drawLine(this.wAncho - 4 * this.cAncho + this.cAlto, this.orgY + this.cAlto, this.wAncho - 4 * this.cAncho + this.cAlto, this.orgY + 4 * this.cAlto);
        g.setColor(Color.black);
        g.fillRect(this.wAncho - 4 * this.cAncho, this.orgY + 4 * this.cAlto, 2 * this.cAlto, this.cAlto / 2 + (int)(Math.sqrt(this.velocidad) * (double)this.cAlto / (double)4));
    }

    private void flechaVertical(Graphics g, int x1) {
        int sgn = -1;
        int l = 2 * this.cAlto * sgn;
        int y1 = this.orgY + l - 6;
        Polygon flecha = new Polygon();
        flecha.addPoint(x1 + 2, y1);
        flecha.addPoint(x1 + 2, y1 - l);
        flecha.addPoint(x1 + 4, y1 - l);
        flecha.addPoint(x1, y1 - l - 4 * sgn);
        flecha.addPoint(x1 - 4, y1 - l);
        flecha.addPoint(x1 - 2, y1 - l);
        flecha.addPoint(x1 - 2, y1);
        g.setColor(Color.red);
        g.fillPolygon(flecha);
    }

    private boolean esModo() {
        double frecuencia = this.fAngular / (double)2 / Math.PI;
        double fModoFundamental = this.velocidad / (double)2;
        int entero = (int)Math.round(frecuencia / fModoFundamental);
        return Math.abs(frecuencia - fModoFundamental * (double)entero) < 0.05 && entero > 1;
    }

    void flechasNodos(Graphics g) {
        double frecuencia = this.fAngular / (double)2 / Math.PI;
        double fModoFundamental = this.velocidad / (double)2;
        int numNodos = (int)Math.round(frecuencia / fModoFundamental);
        for (int i = 1; i < numNodos; ++i) {
            int x1 = this.orgX + (int)((double)(this.escalaX * i) * 1.0 / (double)numNodos);
            this.flechaVertical(g, x1);
        }
    }

    public void paint(Graphics g) {
        this.origen(g);
        this.extremos(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, this.wAncho, this.wAlto);
        this.onda(this.gBuffer);
        this.fuente(this.gBuffer);
        this.extremos(this.gBuffer);
        if (this.esModo()) {
            this.flechasNodos(this.gBuffer);
        }
        g.drawImage(this.imag, 0, 0, null);
    }
}

