/*
 * Decompiled with CFR 0.152.
 */
package resonador;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import resonador.ResonadorApplet;

public class MiCanvas
extends Canvas
implements MouseListener {
    ResonadorApplet parent;
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgX;
    int orgY;
    double escalaX;
    double escalaY;
    double lonCuello;
    final double volumen = 339.0;
    final double areaCuello = 4.9;
    final double areaTubo = 48.0;
    double velSonido = 348.0;
    double gamma;
    double frecAngular;
    int frecuencia = 100;
    Polygon pol = new Polygon();
    double[] x;
    int[] y;
    boolean bGrafica = false;
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas(ResonadorApplet p) {
        this.velSonido = (double)330 + (double)40 * Math.random();
        this.parent = p;
        this.setBackground(Color.white);
        this.addMouseListener(this);
    }

    void origenEscalas(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.escalaX = (double)(this.wAncho - 7 * this.cAncho) / (double)500;
        this.escalaY = (double)(this.wAlto - 3 * this.cAlto) / 1.0;
        this.orgX = 5 * this.cAncho;
        this.orgY = this.wAlto - 2 * this.cAlto;
    }

    void setNuevo(double lonCuello) {
        this.lonCuello = lonCuello;
        this.gamma = this.velSonido * (double)100 * 4.9 / (96.0 * lonCuello);
        this.frecAngular = (double)100 * this.velSonido * Math.sqrt(4.9 / (lonCuello * 339.0));
        this.frecuencia = 100;
        this.pol.npoints = 0;
        this.bGrafica = false;
        this.repaint();
    }

    void setDatos(double[] lonCuello, int[] frecuencias) {
        this.x = new double[lonCuello.length];
        for (int i = 0; i < lonCuello.length; ++i) {
            this.x[i] = 1.0 / Math.sqrt(lonCuello[i]);
        }
        this.y = frecuencias;
        this.bGrafica = true;
        this.repaint();
    }

    void mover() {
        this.frecuencia += 2;
        if (this.frecuencia > 600) {
            this.parent.hilo.putMsg(0);
        }
        this.repaint();
    }

    void graficaRespuesta(Graphics g) {
        int y1;
        String texto;
        int x1;
        g.setColor(Color.black);
        int orgYY = this.orgY + this.cAlto - this.cAncho;
        g.drawLine(this.orgX, orgYY, this.wAncho, orgYY);
        g.drawString("(Hz)", this.wAncho - 4 * this.cAncho, orgYY - 2);
        for (int i = 100; i <= 600; i += 50) {
            x1 = this.orgX + (int)(this.escalaX * (double)(i - 100));
            g.drawLine(x1, orgYY, x1, orgYY + this.cAncho);
            texto = String.valueOf(i);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, orgYY + this.cAncho + this.cAlto);
            if (i == 600) break;
            for (int j = 1; j < 5; ++j) {
                x1 = this.orgX + (int)(this.escalaX * (double)(i + j * 10 - 100));
                g.drawLine(x1, orgYY, x1, orgYY + this.cAncho / 2);
            }
        }
        g.drawLine(this.orgX, orgYY, this.orgX, 0);
        g.drawString("Intensidad", this.orgX + this.cAncho, this.cAlto);
        for (int i = 0; i <= 10; ++i) {
            y1 = this.orgY - (int)(this.escalaY * (double)i / (double)10);
            g.drawLine(this.orgX, y1, this.orgX - this.cAncho, y1);
            texto = String.valueOf((double)Math.round(10 - i) / (double)10);
            g.drawString(texto, this.orgX - 4 * this.cAncho, y1 + this.cAlto / 2);
        }
        x1 = this.orgX + (int)((double)(this.frecuencia - 100) * this.escalaX);
        y1 = this.orgY - (int)(this.escalaY * (1.0 - this.intensidad((double)(this.frecuencia * 2) * Math.PI)));
        this.pol.addPoint(x1, y1);
        g.setColor(Color.red);
        g.drawPolyline(this.pol.xpoints, this.pol.ypoints, this.pol.npoints);
        g.setColor(Color.black);
        int y2 = y1;
        do {
            g.drawLine(x1, y2, x1, y2 + this.cAncho / 2);
        } while ((y2 += this.cAncho) < orgYY);
        int x2 = x1;
        do {
            g.drawLine(x2, y1, x2 - this.cAncho / 2, y1);
        } while ((x2 -= this.cAncho) > this.orgX);
        g.setColor(Color.red);
        g.fillOval(x1 - 2, y1 - 2, 4, 4);
    }

    double intensidad(double x) {
        double y = this.gamma * this.gamma / (double)4 / ((this.frecAngular - x) * (this.frecAngular - x) + this.gamma * this.gamma / (double)4);
        return y;
    }

    public void paint(Graphics g) {
        this.origenEscalas(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, d.width, d.height);
        if (this.bGrafica) {
            this.grafica(this.gBuffer);
        } else {
            this.graficaRespuesta(this.gBuffer);
        }
        g.drawImage(this.imag, 0, 0, null);
    }

    public void mousePressed(MouseEvent ev) {
        Graphics g = this.getGraphics();
        g.setColor(Color.blue);
        g.fillOval(ev.getX() - 2, ev.getY() - 2, 4, 4);
        int frecPico = (int)(100.0 + (double)(ev.getX() - this.orgX) / this.escalaX);
        String texto = String.valueOf((double)Math.round(this.lonCuello * (double)10) / (double)10);
        this.parent.taDatos.append(String.valueOf(String.valueOf(String.valueOf(texto).concat(String.valueOf(", "))).concat(String.valueOf(String.valueOf(frecPico)))).concat(String.valueOf("\n")));
    }

    public void mouseClicked(MouseEvent ev) {
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    void grafica(Graphics g) {
        int y1;
        int x1;
        int orgXX = 5 * this.cAncho;
        int orgYY = this.wAlto - 2 * this.cAlto;
        double escalaX = (double)(this.wAncho - orgXX - 3 * this.cAncho) / 1.0;
        double escalaY = (double)(this.wAlto - 3 * this.cAlto) / (double)600;
        g.setColor(Color.black);
        g.drawLine(orgXX - this.cAncho, orgYY, this.wAncho, orgYY);
        g.drawString("1/cm", this.wAncho - 6 * this.cAncho, orgYY);
        for (int i = 0; i <= 10; ++i) {
            x1 = orgXX + (int)((double)i * escalaX / (double)10);
            g.drawLine(x1, orgYY + this.cAncho / 2, x1, orgYY - this.cAncho / 2);
            String str = String.valueOf((double)Math.round(i) / (double)10);
            g.drawString(str, x1 - g.getFontMetrics().stringWidth(str) / 2, orgYY + this.cAlto);
        }
        g.drawLine(orgXX, 0, orgXX, this.wAlto - this.cAlto);
        g.drawString("Hz", orgXX + this.cAncho, this.cAlto);
        for (int i = 0; i <= 600; i += 50) {
            y1 = orgYY - (int)((double)i * escalaY);
            g.drawLine(orgXX + this.cAncho / 2, y1, orgXX - this.cAncho / 2, y1);
            String str = String.valueOf(i);
            g.drawString(str, orgXX - g.getFontMetrics().stringWidth(str) - this.cAncho / 2, y1 + this.cAlto / 2);
        }
        g.setColor(Color.red);
        for (int i = 0; i < this.x.length; ++i) {
            x1 = orgXX + (int)(this.x[i] * escalaX);
            y1 = orgYY - (int)((double)this.y[i] * escalaY);
            g.fillOval(x1 - 2, y1 - 2, 4, 4);
        }
        double a = (double)100 * this.velSonido * Math.sqrt(0.014454277286135695) / (Math.PI * 2);
        x1 = orgXX + (int)(1.0 * escalaX);
        y1 = orgYY - (int)(1.0 * a * escalaY);
        g.setColor(Color.blue);
        g.drawLine(orgXX, orgYY, x1, y1);
        g.setColor(Color.black);
        String texto = String.valueOf((double)Math.round(a * (double)10000) / (double)10000);
        g.drawString(String.valueOf("pendiente: ").concat(String.valueOf(texto)), this.wAncho / 2, this.cAlto);
    }
}

