/*
 * Decompiled with CFR 0.152.
 */
package interferencia3;

import interferencia3.InterferenciaApplet3;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MiCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    InterferenciaApplet3 parent;
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgX;
    int orgY;
    double escalaX;
    double escalaY;
    final double velocidad = 340.0;
    int frecuencia = 1000;
    double t;
    final double dt = 5.0E-6;
    double dist = 0.51;
    final int[] gris = new int[]{0, 2, 3, 4, 6, 7, 8, 10, 11, 12, 13, 15, 17, 18, 20, 21, 22, 23, 25, 26, 27, 29, 30, 31, 32, 35, 36, 37, 39, 40, 41, 42, 44, 45, 46, 48, 49, 51, 53, 54, 55, 56, 58, 59, 60, 62, 63, 64, 65, 68, 69, 70, 72, 73, 74, 75, 77, 78, 79, 81, 82, 83, 85, 87, 88, 89, 91, 92, 93, 95, 96, 97, 98, 100, 102, 103, 105, 106, 107, 108, 110, 111, 112, 114, 115, 116, 117, 120, 121, 122, 124, 125, 126, 127, 129, 130, 131, 133, 134, 136, 138, 139, 140, 141, 143, 144, 145, 147, 148, 149, 150, 153, 154, 155, 157, 158, 159, 160, 162, 163, 164, 166, 167, 168, 170, 172, 173, 174, 176, 177, 178, 180, 181, 182, 183, 185, 187, 188, 190, 191, 192, 193, 195, 196, 197, 199, 200, 201, 202, 205, 206, 207, 209, 210, 211, 212, 214, 215, 216, 218, 219, 221, 223, 224, 225, 226, 228, 229, 230, 232, 233, 234, 235, 238, 239, 240, 242, 243, 244, 245, 247, 248, 249, 251, 252, 253, 255};
    Image imagenIntensidad;
    boolean bNuevo = true;
    int xMarca;
    boolean bArrastrar = false;
    Rectangle flecha = new Rectangle();
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas(InterferenciaApplet3 p) {
        this.parent = p;
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    void setInicio(int frec) {
        this.frecuencia = frec;
        this.t = 0.0;
        this.bNuevo = true;
        this.repaint();
    }

    void setNuevo(int frec) {
        this.frecuencia = frec;
        this.t = 0.0;
        this.crearImagenes();
        this.bNuevo = false;
        this.repaint();
    }

    void crearImagenes() {
        this.parent.setCursor(Cursor.getPredefinedCursor(3));
        this.imagenIntensidad = this.createImage(this.wAncho, 5 * this.cAncho);
        this.gBuffer = this.imagenIntensidad.getGraphics();
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, this.wAncho - this.orgX, 5 * this.cAncho);
        this.intensidad(this.gBuffer);
        this.gBuffer = null;
        this.parent.setCursor(Cursor.getPredefinedCursor(0));
    }

    void intensidad(Graphics g) {
        for (int i = 0; i < this.wAncho - this.orgX; ++i) {
            double x = (double)i / this.escalaX;
            int nivel = (int)((double)(this.gris.length - 1) * this.calculaIntensidad(x));
            g.setColor(new Color(this.gris[nivel], this.gris[nivel], this.gris[nivel]));
            g.fillRect(i, 0, 1, 5 * this.cAncho);
        }
    }

    double calculaIntensidad(double x) {
        double y = 0.0;
        y = x <= this.dist ? Math.cos(Math.PI * 2 * (double)this.frecuencia / 340.0 * (x - this.dist / (double)2)) : Math.cos(Math.PI * 2 * (double)this.frecuencia / 340.0 * this.dist / (double)2);
        return y * y;
    }

    void origen(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.orgX = this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgY = this.wAlto / 7;
        this.escalaX = (double)(this.wAncho - this.orgX - this.cAncho) / 1.0;
        this.escalaY = this.wAlto / 8 - this.cAncho;
        this.flecha.setSize(4 * this.cAncho, this.cAncho);
        this.flecha.x = this.orgX + (int)(this.dist * this.escalaX) - 2 * this.cAncho;
        this.flecha.y = 2 * this.orgY - this.cAncho;
    }

    void mover() {
        this.repaint();
        this.t += 5.0E-6;
    }

    void ondas(Graphics g) {
        int y2;
        int x2;
        String texto;
        int x1;
        g.setColor(Color.black);
        this.orgY = this.wAlto / 7;
        g.drawLine(0, this.orgY, this.wAncho, this.orgY);
        for (int i = -1; i <= 10; ++i) {
            x1 = this.orgX + (int)((double)i * this.escalaX / (double)10);
            g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho);
            texto = String.valueOf((double)i / (double)10);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, this.orgY + this.cAlto + this.cAncho);
            for (int j = 0; j < 5; ++j) {
                x1 = this.orgX + (int)(((double)i + (double)j / (double)5) * this.escalaX / (double)10);
                g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho / 2);
            }
        }
        g.fillRect(this.orgX - 2 * this.cAncho, 2 * this.orgY - this.cAncho, 4 * this.cAncho, this.cAncho);
        double y = Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (-340.0 * this.t));
        int y1 = this.orgY - (int)(y * this.escalaY);
        g.setColor(Color.red);
        g.fillOval(this.orgX - this.cAncho / 2, y1 - this.cAncho / 2, this.cAncho, this.cAncho);
        g.drawLine(this.orgX, y1, this.orgX, 2 * this.orgY - this.cAncho);
        y = Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (0.0 - 340.0 * this.t));
        x1 = this.orgX + (int)(this.escalaX * 0.0);
        y1 = this.orgY - (int)(y * this.escalaY);
        for (double x = 0.0; x <= 1.0; x += 0.005) {
            y = Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (x - 340.0 * this.t));
            x2 = this.orgX + (int)(this.escalaX * x);
            y2 = this.orgY - (int)(y * this.escalaY);
            g.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
        }
        g.setColor(Color.black);
        g.fillRect(this.flecha.x, this.flecha.y, this.flecha.width, this.flecha.height);
        x1 = this.orgX + (int)(this.dist * this.escalaX);
        y = Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (-340.0 * this.t));
        y1 = this.orgY - (int)(y * this.escalaY);
        g.setColor(Color.blue);
        g.fillOval(x1 - this.cAncho / 2, y1 - this.cAncho / 2, this.cAncho, this.cAncho);
        g.drawLine(x1, y1, x1, 2 * this.orgY - this.cAncho);
        y = Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (-340.0 * this.t));
        x1 = this.orgX + (int)(this.escalaX * this.dist);
        y1 = this.orgY - (int)(y * this.escalaY);
        for (double x = 0.0; x <= 1.0 - this.dist; x += 0.005) {
            y = Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (x - 340.0 * this.t));
            x2 = this.orgX + (int)(this.escalaX * (x + this.dist));
            y2 = this.orgY - (int)(y * this.escalaY);
            g.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
        }
        y = -Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (0.0 + 340.0 * this.t));
        x1 = this.orgX + (int)(this.escalaX * this.dist);
        y1 = this.orgY - (int)(y * this.escalaY);
        for (double x = 0.0; x >= -this.dist; x -= 0.005) {
            y = -Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (x + 340.0 * this.t));
            x2 = this.orgX + (int)(this.escalaX * (x + this.dist));
            y2 = this.orgY - (int)(y * this.escalaY);
            g.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
        }
        g.setColor(Color.black);
        texto = String.valueOf((double)Math.round(this.dist * (double)100) / (double)100);
        g.drawString(texto, this.flecha.x + this.flecha.width, this.flecha.y + this.cAncho + this.cAlto);
    }

    void superposicion(Graphics g) {
        int x1;
        g.setColor(Color.black);
        this.orgY = 4 * this.wAlto / 7;
        g.drawLine(0, this.orgY, this.wAncho, this.orgY);
        for (int i = -1; i <= 10; ++i) {
            x1 = this.orgX + (int)((double)i * this.escalaX / (double)10);
            g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho);
            String texto = String.valueOf((double)i / (double)10);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, this.orgY + this.cAlto + this.cAncho);
            for (int j = 0; j < 5; ++j) {
                x1 = this.orgX + (int)(((double)i + (double)j / (double)5) * this.escalaX / (double)10);
                g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho / 2);
            }
        }
        double y = Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (0.0 - 340.0 * this.t)) - Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (-this.dist + 340.0 * this.t));
        x1 = this.orgX + (int)(this.escalaX * 0.0);
        int y1 = this.orgY - (int)(y * this.escalaY);
        int x2 = 0;
        int y2 = 0;
        for (double x = 0.0; x < this.dist; x += 0.005) {
            y = Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (x - 340.0 * this.t)) - Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (-this.dist + x + 340.0 * this.t));
            x2 = this.orgX + (int)(this.escalaX * x);
            y2 = this.orgY - (int)(y * this.escalaY);
            g.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
        }
        x1 = this.orgX + (int)(this.escalaX * this.dist);
        y = Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (this.dist - 340.0 * this.t)) - Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * 340.0 * this.t);
        y1 = this.orgY - (int)(y * this.escalaY);
        g.drawLine(x1, y1, x2, y2);
        y = Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (this.dist - 340.0 * this.t)) + Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (-340.0 * this.t));
        x1 = this.orgX + (int)(this.escalaX * this.dist);
        y1 = this.orgY - (int)(y * this.escalaY);
        for (double x = this.dist; x < 1.0; x += 0.005) {
            y = Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (x - 340.0 * this.t)) + Math.sin(Math.PI * 2 * (double)this.frecuencia / 340.0 * (x - this.dist - 340.0 * this.t));
            x2 = this.orgX + (int)(this.escalaX * x);
            y2 = this.orgY - (int)(y * this.escalaY);
            g.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
        }
        g.setColor(Color.magenta);
        y = (double)2 * Math.cos(Math.PI * 2 * (double)this.frecuencia / 340.0 * (0.0 - this.dist / (double)2));
        x1 = this.orgX + (int)(this.escalaX * 0.0);
        y1 = this.orgY - (int)(y * this.escalaY);
        for (double x = 0.0; x < this.dist; x += 0.005) {
            y = (double)2 * Math.cos(Math.PI * 2 * (double)this.frecuencia / 340.0 * (x - this.dist / (double)2));
            x2 = this.orgX + (int)(this.escalaX * x);
            y2 = this.orgY - (int)(y * this.escalaY);
            g.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
        }
        x1 = this.orgX + (int)(this.escalaX * this.dist);
        y = (double)2 * Math.cos(Math.PI * 2 * (double)this.frecuencia / 340.0 * this.dist / (double)2);
        y1 = this.orgY - (int)(y * this.escalaY);
        g.drawLine(x1, y1, x2, y2);
        x1 = this.orgX + (int)(this.escalaX * this.dist);
        x2 = this.orgX + (int)(this.escalaX * 1.0);
        y = (double)2 * Math.cos(Math.PI * 2 * (double)this.frecuencia / 340.0 * this.dist / (double)2);
        y1 = this.orgY - (int)(y * this.escalaY);
        g.drawLine(x1, y1, x2, y1);
        g.setColor(Color.green);
        g.drawRect(this.orgX - 1, 6 * this.wAlto / 7 - 1, this.wAncho, 5 * this.cAncho + 2);
        g.drawImage(this.imagenIntensidad, this.orgX, 6 * this.wAlto / 7, null);
    }

    public void paint(Graphics g) {
        this.origen(g);
        this.ondas(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, this.wAncho, this.wAlto);
        this.ondas(this.gBuffer);
        if (!this.bNuevo) {
            this.superposicion(this.gBuffer);
        }
        g.drawImage(this.imag, 0, 0, null);
    }

    public void mousePressed(MouseEvent ev) {
        if (this.flecha.contains(ev.getX(), ev.getY())) {
            this.xMarca = ev.getX();
            this.bArrastrar = true;
        }
    }

    public void mouseReleased(MouseEvent ev) {
        if (this.bArrastrar) {
            this.bArrastrar = false;
            this.flecha.x += ev.getX() - this.xMarca;
            this.dist = (double)(this.flecha.x + this.flecha.width / 2 - this.orgX) / this.escalaX;
            if (this.dist < 0.25) {
                this.dist = 0.25;
            }
            if (this.dist > 1.0) {
                this.dist = 1.0;
            }
            this.flecha.x = this.orgX + (int)(this.dist * this.escalaX) - this.flecha.width / 2;
        }
        this.xMarca = ev.getX();
        this.repaint();
    }

    public void mouseDragged(MouseEvent ev) {
        int x1 = this.orgX + (int)(1.0 * this.escalaX);
        int x2 = this.orgX + (int)(0.25 * this.escalaX);
        if (this.bArrastrar && this.flecha.x + this.flecha.width / 2 <= x1 && this.flecha.x + this.flecha.width / 2 >= x2) {
            this.flecha.x += ev.getX() - this.xMarca;
            this.dist = (double)(this.flecha.x + this.flecha.width / 2 - this.orgX) / this.escalaX;
            if (this.dist < 0.25) {
                this.dist = 0.25;
            }
            if (this.dist > 1.0) {
                this.dist = 1.0;
            }
            this.flecha.x = this.orgX + (int)(this.dist * this.escalaX) - this.flecha.width / 2;
        }
        this.xMarca = ev.getX();
        this.repaint();
    }

    public void mouseClicked(MouseEvent ev) {
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseMoved(MouseEvent ev) {
    }
}

