/*
 * Decompiled with CFR 0.152.
 */
package ondasEstacionarias2;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class MiCanvas
extends Canvas {
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgY;
    int orgYY;
    int orgX;
    double escalaX;
    double escalaY;
    final double vSonido = 340.0;
    double frecuencia = 170.0;
    double t;
    double dt;
    boolean bAbierto = true;
    int iModo = 1;
    double[] xModos = new double[5];
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas() {
        this.setBackground(Color.white);
        this.dt = 2.0E-5;
    }

    void setModo(int iModo) {
        this.iModo = iModo;
        this.frecuencia = this.bAbierto ? (double)iModo * 340.0 / 2.0 : (double)(2 * iModo - 1) * 340.0 / 4.0;
        for (int i = 1; i <= iModo; ++i) {
            this.xModos[i - 1] = this.bAbierto ? (double)(2 * i - 1) * 1.0 / (double)(2 * iModo) : (double)(2 * i - 1) * 1.0 / (double)(2 * iModo - 1);
        }
        this.t = 0.0;
        this.repaint();
    }

    void setNuevo(boolean bAbierto) {
        this.bAbierto = bAbierto;
        this.repaint();
    }

    void origen(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgX = 4 * this.cAncho;
        this.orgY = this.wAlto / 2;
        this.orgYY = 3 * this.wAlto / 4 + this.cAlto;
        this.escalaX = (double)(this.wAncho - 8 * this.cAncho) / 1.0;
        this.escalaY = 4 * this.cAlto;
    }

    void ejes(Graphics g) {
        g.setColor(Color.black);
        g.drawLine(0, this.orgY, this.wAncho, this.orgY);
        for (int i = 0; i <= 10; ++i) {
            int x1 = this.orgX + (int)((double)i * this.escalaX / (double)10);
            g.drawLine(x1, this.orgY - this.cAncho, x1, this.orgY + this.cAncho);
            String texto = String.valueOf((double)Math.round((double)i / (double)10 * (double)10) / (double)10);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, this.orgY + this.cAlto + this.cAncho / 2);
            if (i == 10) break;
            for (int j = 0; j < 5; ++j) {
                int x2 = x1 + (int)((double)j * this.escalaX / (double)10 / (double)5);
                g.drawLine(x2, this.orgY - this.cAncho / 2, x2, this.orgY + this.cAncho / 2);
            }
        }
        g.drawString("m", this.wAncho - 2 * this.cAncho, this.orgY + this.cAlto + this.cAncho / 2);
    }

    void mover() {
        this.repaint();
        this.t += this.dt;
    }

    void onda(Graphics g) {
        int y2;
        int x2;
        double y = Math.sin(Math.PI * 2 * this.frecuencia * this.t);
        int x1 = this.orgX;
        int y1 = this.orgY - (int)(y * this.escalaY);
        g.setColor(Color.blue);
        double longitudOnda = 340.0 / this.frecuencia;
        for (double x = 0.0; x < 1.0; x += 0.02) {
            y = Math.cos(Math.PI * 2 * x / longitudOnda) * Math.sin(Math.PI * 2 * this.frecuencia * this.t);
            x2 = this.orgX + (int)(this.escalaX * x);
            y2 = this.orgY - (int)(y * this.escalaY);
            g.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
        }
        y = Math.cos(Math.PI * 2 / longitudOnda) * Math.sin(Math.PI * 2 * this.frecuencia * this.t);
        x2 = this.orgX + (int)(this.escalaX * 1.0);
        y2 = this.orgY - (int)(y * this.escalaY);
        g.drawLine(x1, y1, x2, y2);
        g.setColor(Color.black);
        g.drawString(String.valueOf("Longitud de onda (m) : ").concat(String.valueOf(String.valueOf(Math.floor((double)100 * longitudOnda) / (double)100))), this.cAncho, this.cAlto);
        g.drawString(String.valueOf("Frecuencia (Hz): ").concat(String.valueOf(String.valueOf(Math.floor(this.frecuencia)))), this.cAncho, 2 * this.cAlto);
    }

    void movParticulas(Graphics g) {
        g.setColor(Color.red);
        double longitudOnda = 340.0 / this.frecuencia;
        int n = (int)(this.xModos[0] / 0.02);
        double dxx = this.xModos[0] / (double)n;
        block0: for (double x = 0.0; x <= 1.0 + dxx; x += dxx) {
            int j;
            int x1;
            for (int i = 1; i <= this.iModo; ++i) {
                x1 = this.orgX + (int)(x * this.escalaX);
                int x2 = this.orgX + (int)(this.xModos[i - 1] * this.escalaX);
                if (Math.abs(x1 - x2) >= 4) continue;
                g.setColor(Color.blue);
                for (j = 0; j < 5; ++j) {
                    g.fillOval(x1 - 2, this.orgYY + j * this.cAncho - 2, 4, 4);
                }
                continue block0;
            }
            g.setColor(Color.red);
            for (j = 0; j < 5; ++j) {
                double dx = 0.02 * Math.cos(Math.PI * 2 * x / longitudOnda) * Math.sin(Math.PI * 2 * this.frecuencia * this.t);
                x1 = this.orgX + (int)((x + dx) * this.escalaX);
                g.fillOval(x1 - 2, this.orgYY + j * this.cAncho - 2, 4, 4);
            }
        }
    }

    void tubo(Graphics g) {
        g.setColor(Color.black);
        int y1 = this.orgYY + 5 * this.cAncho;
        int x1 = this.orgX + (int)(this.escalaX * 1.02);
        if (!this.bAbierto) {
            g.drawLine(x1, y1, x1, this.orgYY - this.cAncho - 1);
            g.drawLine(x1 + 1, y1 + 1, x1 + 1, this.orgYY - this.cAncho - 1);
        }
        g.drawLine(this.orgX, this.orgYY - this.cAncho, x1, this.orgYY - this.cAncho);
        g.drawLine(this.orgX, this.orgYY - this.cAncho - 1, x1, this.orgYY - this.cAncho - 1);
        g.drawLine(this.orgX, y1, x1, y1);
        g.drawLine(this.orgX, y1 + 1, x1, y1 + 1);
        x1 = this.orgX - (int)(this.escalaX * 0.02);
        g.drawLine(x1, this.orgYY - this.cAncho, x1 - this.cAncho, this.orgYY - this.cAncho);
        g.drawLine(x1, this.orgYY - this.cAncho - 1, x1 - this.cAncho, this.orgYY - this.cAncho - 1);
        g.drawLine(x1 - this.cAncho, this.orgYY - this.cAncho - 1, x1 - this.cAncho, this.orgYY + this.cAncho);
        g.drawLine(x1 - this.cAncho - 1, this.orgYY - this.cAncho - 1, x1 - this.cAncho - 1, this.orgYY + this.cAncho);
        g.drawLine(x1 - this.cAncho, this.orgYY + this.cAncho, 0, this.orgYY + this.cAncho);
        g.drawLine(x1 - this.cAncho, this.orgYY + this.cAncho - 1, 0, this.orgYY + this.cAncho - 1);
        g.drawLine(this.orgX, y1, x1 - this.cAncho, y1);
        g.drawLine(this.orgX, y1 + 1, x1 - this.cAncho, y1 + 1);
        g.drawLine(x1 - this.cAncho, y1 + 1, x1 - this.cAncho, y1 - 2 * this.cAncho);
        g.drawLine(x1 - this.cAncho - 1, y1 + 1, x1 - this.cAncho - 1, y1 - 2 * this.cAncho);
        g.drawLine(x1 - this.cAncho, y1 - 2 * this.cAncho, 0, y1 - 2 * this.cAncho);
        g.drawLine(x1 - this.cAncho, y1 - 2 * this.cAncho + 1, 0, y1 - 2 * this.cAncho + 1);
    }

    void dispositivo(Graphics g) {
        this.ejes(g);
        this.onda(g);
        this.movParticulas(g);
        this.tubo(g);
    }

    public void paint(Graphics g) {
        this.origen(g);
        this.update(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, this.wAncho, this.wAlto);
        this.dispositivo(this.gBuffer);
        g.drawImage(this.imag, 0, 0, null);
    }
}

