/*
 * Decompiled with CFR 0.152.
 */
package ondasEstacionarias5;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import ondasEstacionarias5.OndasEstacionariasApplet5;

public class MiCanvas
extends Canvas {
    OndasEstacionariasApplet5 parent;
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgY;
    int orgX;
    double escTemp;
    double f0;
    int temperatura = 25;
    boolean bResonancia = false;
    final int MAX_DATOS = 10;
    double[] x = new double[10];
    double[] y = new double[10];
    int nDatos;
    int tipo;
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas(OndasEstacionariasApplet5 p) {
        this.parent = p;
        this.setBackground(Color.white);
        double vSonido = Math.sqrt(11.6396 * (273.15 + (double)this.temperatura) / 0.02895);
        this.f0 = vSonido / 0.9;
    }

    void origen(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.orgX = this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgY = this.wAlto - this.cAncho - this.cAlto;
        this.escTemp = 20.0 * (double)this.cAncho / (double)60;
    }

    void setNuevo(int temp) {
        this.temperatura = temp;
        double vSonido = Math.sqrt(11.6396 * (273.15 + (double)temp) / 0.02895);
        this.f0 = vSonido / 0.9;
        this.bResonancia = false;
        this.tipo = 1;
        this.repaint();
    }

    void setInicio() {
        this.nDatos = 0;
        this.tipo = 0;
        this.repaint();
    }

    void setVelocidad() {
        this.tipo = 2;
        String texto = String.valueOf(String.valueOf(String.valueOf(this.temperatura)).concat(String.valueOf(", "))).concat(String.valueOf(String.valueOf((double)Math.round(0.9 * this.f0 * (double)100) / (double)100)));
        this.parent.taDatos.append(String.valueOf(texto).concat(String.valueOf("\n")));
        if (this.nDatos < 10) {
            this.x[this.nDatos] = this.temperatura;
            this.y[this.nDatos] = this.f0 * (double)2 * 0.45;
            ++this.nDatos;
        }
        this.repaint();
    }

    void setGrafica() {
        this.tipo = 3;
        this.repaint();
    }

    void tubo(Graphics g) {
        int x1;
        g.drawImage(this.parent.tubo, 0, 0, null);
        int ancho = this.parent.tubo.getWidth(this);
        int alto = this.parent.tubo.getHeight(this);
        g.setColor(Color.black);
        for (int i = 10; i <= 70; i += 10) {
            x1 = ancho - 115 + (int)((double)(i - 10) * this.escTemp);
            g.drawLine(x1, alto - 15, x1, alto - 15 + this.cAncho);
            String texto = String.valueOf(i);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, alto - 15 + this.cAncho + this.cAlto);
        }
        x1 = (int)((double)(this.temperatura - 10) * this.escTemp);
        g.setColor(Color.red);
        g.fillRect(ancho - 115, alto - 18, x1, 3);
        g.setColor(Color.black);
        g.drawRect(ancho - 115, alto - 18, 21 * this.cAncho, 3);
    }

    void graficaEspectro(Graphics g) {
        int x1;
        double escalaX = (double)(this.wAncho - this.orgX - 3 * this.cAncho) / (double)4000;
        double escalaY = (double)(this.orgY - this.parent.tubo.getHeight(this) - this.cAlto) / 1.0;
        g.setColor(Color.black);
        g.drawLine(this.orgX, this.orgY, this.wAncho, this.orgY);
        int y1 = this.orgY - (int)(1.0 * escalaY);
        g.drawLine(this.orgX, y1, this.orgX, this.wAlto);
        for (int i = 0; i <= 4000; i += 1000) {
            x1 = this.orgX + (int)((double)i * escalaX);
            g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho);
            String texto = String.valueOf(i);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, this.orgY + this.cAncho + this.cAlto - 2);
            for (int j = 100; j < 1000; j += 100) {
                x1 = this.orgX + (int)((double)(i + j) * escalaX);
                g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho / 2);
                if (j != 500) continue;
                g.drawLine(x1, this.orgY, x1, this.orgY + 3 * this.cAncho / 4);
            }
        }
        g.drawString("f(Hz)", this.wAncho - 4 * this.cAncho, this.orgY - 2);
        g.drawString("int", this.orgX + this.cAncho, y1);
        int delta = 50;
        int x2 = this.orgX;
        int y2 = this.orgY;
        g.setColor(Color.red);
        int i = 1;
        for (int f = 0; f < 4000; f += 10) {
            double y;
            if ((double)f > (double)i * this.f0 - (double)(4 * delta) && (double)f < (double)i * this.f0 + (double)(4 * delta)) {
                double x = ((double)(f * f) - (double)(i * i) * this.f0 * this.f0) / (double)(delta * f);
                y = 1.0 / (1.0 + x * x);
                this.bResonancia = true;
            } else {
                if (this.bResonancia) {
                    ++i;
                    this.bResonancia = false;
                }
                y = 0.0;
            }
            y1 = this.orgY - (int)(y * escalaY);
            x1 = this.orgX + (int)((double)f * escalaX);
            g.drawLine(x1, y1, x2, y2);
            x2 = x1;
            y2 = y1;
        }
    }

    void graficaVelocidad(Graphics g) {
        int y1;
        String texto;
        int x1;
        this.orgX = 6 * this.cAncho;
        double escalaY = (double)(this.orgY - this.cAncho) / (double)4000;
        double escalaX = (double)(this.wAncho - this.orgX - 2 * this.cAncho) / (double)10;
        g.setColor(Color.black);
        g.drawLine(this.orgX, this.orgY, this.wAncho, this.orgY);
        g.drawLine(this.orgX, 0, this.orgX, this.wAlto);
        for (int i = 0; i <= 10; ++i) {
            x1 = this.orgX + (int)((double)i * escalaX);
            g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho);
            texto = String.valueOf(i);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, this.orgY + this.cAncho + this.cAlto - 2);
            for (int j = 100; j < 1000; j += 100) {
                x1 = this.orgX + (int)((double)(i + j) * escalaX);
                g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho / 2);
                if (j != 500) continue;
                g.drawLine(x1, this.orgY, x1, this.orgY + 3 * this.cAncho / 4);
            }
        }
        for (int i = 0; i <= 4000; i += 1000) {
            y1 = this.orgY - (int)((double)i * escalaY);
            g.drawLine(this.orgX, y1, this.orgX - this.cAncho, y1);
            texto = String.valueOf(i);
            g.drawString(texto, this.orgX - this.cAncho - g.getFontMetrics().stringWidth(texto), y1 + this.cAlto / 4);
            for (int j = 100; j < 1000; j += 100) {
                y1 = this.orgY - (int)((double)(i + j) * escalaY);
                g.drawLine(this.orgX, y1, this.orgX - this.cAncho / 2, y1);
                if (j != 500) continue;
                g.drawLine(this.orgX, y1, this.orgX - 3 * this.cAncho / 4, y1);
            }
        }
        g.drawString("n", this.wAncho - 4 * this.cAncho, this.orgY - 2);
        g.drawString("f(Hz)", this.orgX + this.cAncho, this.cAlto);
        g.setColor(Color.blue);
        x1 = this.orgX + (int)(escalaX * (double)11);
        y1 = this.orgY - (int)((double)11 * this.f0 * escalaY);
        g.drawLine(this.orgX, this.orgY, x1, y1);
        g.setColor(Color.red);
        for (int i = 1; i <= 10; ++i) {
            x1 = this.orgX + (int)(escalaX * (double)i);
            y1 = this.orgY - (int)((double)i * this.f0 * escalaY);
            g.fillOval(x1 - this.cAncho / 2, y1 - this.cAncho / 2, this.cAncho, this.cAncho);
        }
        int x2 = x1;
        do {
            g.drawLine(x2, y1, x2 - this.cAncho / 2, y1);
        } while ((x2 -= this.cAncho) > this.orgX);
        int y2 = y1;
        do {
            g.drawLine(x1, y2, x1, y2 + this.cAncho / 2);
        } while ((y2 += this.cAncho) < this.orgY);
        g.setColor(Color.black);
        Font oldFont = g.getFont();
        Font fuente = new Font("Times", 1, 14);
        g.setFont(fuente);
        texto = String.valueOf((double)Math.round(0.9 * this.f0 * (double)100) / (double)100);
        if (texto.substring(texto.indexOf(".")).length() == 2) {
            texto = String.valueOf(texto).concat(String.valueOf("0"));
        }
        g.drawString(String.valueOf("v(m/s): ").concat(String.valueOf(texto)), this.wAncho / 2 - g.getFontMetrics().stringWidth(texto) / 2, g.getFontMetrics().getHeight() + this.cAlto / 2);
        g.setFont(oldFont);
    }

    void graficaTemp(Graphics g) {
        int y1;
        String texto;
        int x1;
        this.orgX = 4 * this.cAncho;
        double escalaY = (double)(this.orgY - this.cAncho) / (double)50;
        double escalaX = (double)(this.wAncho - this.orgX - 2 * this.cAncho) / (double)70;
        g.setColor(Color.black);
        g.drawLine(this.orgX, this.orgY, this.wAncho, this.orgY);
        g.drawLine(this.orgX, 0, this.orgX, this.wAlto);
        for (int i = 0; i <= 70; i += 10) {
            x1 = this.orgX + (int)((double)i * escalaX);
            g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho);
            texto = String.valueOf(i);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, this.orgY + this.cAncho + this.cAlto - 2);
            for (int j = 1; j < 10; ++j) {
                x1 = this.orgX + (int)((double)(i + j) * escalaX);
                g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho / 2);
                if (j != 5) continue;
                g.drawLine(x1, this.orgY, x1, this.orgY + 3 * this.cAncho / 4);
            }
        }
        for (int i = 330; i <= 380; i += 10) {
            y1 = this.orgY - (int)((double)(i - 330) * escalaY);
            g.drawLine(this.orgX, y1, this.orgX - this.cAncho, y1);
            texto = String.valueOf(i);
            g.drawString(texto, this.orgX - this.cAncho - g.getFontMetrics().stringWidth(texto), y1 + this.cAlto / 4);
            for (int j = 1; j < 10; ++j) {
                y1 = this.orgY - (int)((double)(i + j - 330) * escalaY);
                g.drawLine(this.orgX, y1, this.orgX - this.cAncho / 2, y1);
                if (j != 5) continue;
                g.drawLine(this.orgX, y1, this.orgX - 3 * this.cAncho / 4, y1);
            }
        }
        g.drawString("t(\u00baC)", this.wAncho - 4 * this.cAncho, this.orgY - 2);
        g.drawString("v(m/s)", this.orgX + this.cAncho, this.cAlto);
        g.setColor(Color.blue);
        x1 = this.orgX + (int)((double)80 * escalaX);
        y1 = this.orgY - (int)(49.922500000000014 * escalaY);
        int y2 = this.orgY - (int)(1.3944999999999936 * escalaY);
        g.drawLine(this.orgX, y2, x1, y1);
        g.setColor(Color.red);
        for (int i = 0; i <= this.nDatos; ++i) {
            x1 = this.orgX + (int)(this.x[i] * escalaX);
            y1 = this.orgY - (int)((this.y[i] - (double)330) * escalaY);
            g.fillOval(x1 - this.cAncho / 2, y1 - this.cAncho / 2, this.cAncho, this.cAncho);
        }
    }

    void dispositivo(Graphics g) {
        switch (this.tipo) {
            case 0: {
                this.tubo(g);
                break;
            }
            case 1: {
                this.tubo(g);
                this.graficaEspectro(g);
                break;
            }
            case 2: {
                this.graficaVelocidad(g);
                break;
            }
            case 3: {
                this.graficaTemp(g);
            }
        }
    }

    public void paint(Graphics g) {
        this.origen(g);
        this.update(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, this.wAncho, this.wAlto);
        this.dispositivo(this.gBuffer);
        g.drawImage(this.imag, 0, 0, null);
    }
}

