/*
 * Decompiled with CFR 0.152.
 */
package doppler1;

import doppler1.DopplerApplet1;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class MiCanvas
extends Canvas {
    DopplerApplet1 parent;
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgY;
    int orgX;
    double escala;
    double vEmisor;
    double vObservador;
    double t;
    int xEmisor;
    int xObservador;
    double xIniEmisor;
    double xIniObservador;
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas(DopplerApplet1 p) {
        this.parent = p;
        this.setBackground(Color.white);
    }

    void setNuevo(double vEmisor, double vObservador) {
        this.vEmisor = vEmisor;
        this.vObservador = vObservador;
        this.xIniEmisor = 0.0;
        this.xIniObservador = vObservador < 0.0 ? 5.5 : (1.0 - vObservador) * (double)3;
        this.t = 0.0;
    }

    void origen(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgX = this.wAncho / 4;
        this.orgY = this.wAlto / 2;
        this.escala = (double)(this.wAncho - this.orgX) / (double)6;
    }

    void ejes(Graphics g) {
        g.setColor(Color.black);
        g.drawLine(0, this.orgY, this.wAncho, this.orgY);
        for (int i = -2; i < 6; ++i) {
            int x1 = this.orgX + (int)((double)i * this.escala);
            g.drawLine(x1, this.orgY - this.cAncho, x1, this.orgY + this.cAncho);
            String texto = String.valueOf(i);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, this.orgY + this.cAlto + this.cAncho / 2);
            for (int j = 0; j < 5; ++j) {
                int x2 = x1 + (int)((double)j * this.escala / (double)5);
                g.drawLine(x2, this.orgY - this.cAncho / 2, x2, this.orgY + this.cAncho / 2);
            }
        }
    }

    void mover() {
        this.xEmisor = this.orgX + (int)((this.xIniEmisor + this.vEmisor * this.t) * this.escala);
        this.xObservador = this.orgX + (int)((this.xIniObservador + this.vObservador * this.t) * this.escala);
        if (this.xObservador > this.wAncho || this.xEmisor > 5 * this.wAncho / 4 || this.xObservador < 0 || this.xEmisor < -this.wAncho / 4) {
            this.parent.hilo.putMsg(0);
            return;
        }
        this.repaint();
        this.t += 0.01;
    }

    void funcionOnda(Graphics g) {
        int x1;
        int y1 = 0;
        g.setClip(0, 0, this.wAncho, this.wAlto);
        g.setColor(Color.red);
        double x = this.vEmisor * this.t;
        int x2 = this.orgX + (int)(x * this.escala);
        int y2 = this.wAlto - this.cAlto - this.cAncho / 2 - (int)((double)this.cAlto * Math.cos(Math.PI * 2 * (x - 1.0 * this.t) / (1.0 - this.vEmisor)));
        double xFin = 1.0 * this.t + (1.0 - this.vEmisor) / (double)4;
        for (x = this.vEmisor * this.t; x < xFin; x += 0.05) {
            x1 = this.orgX + (int)(x * this.escala);
            y1 = this.wAlto - this.cAlto - this.cAncho / 2 - (int)((double)this.cAlto * Math.cos(Math.PI * 2 * (x - 1.0 * this.t) / (1.0 - this.vEmisor)));
            g.drawLine(x1, y1, x2, y2);
            x2 = x1;
            y2 = y1;
        }
        x1 = this.orgX + (int)(xFin * this.escala);
        g.drawLine(x2, y2, x1, this.wAlto - this.cAlto - this.cAncho / 2);
        g.drawLine(x1, this.wAlto - this.cAlto - this.cAncho / 2, this.wAncho, this.wAlto - this.cAlto - this.cAncho / 2);
        x = this.vEmisor * this.t;
        x2 = this.orgX + (int)(x * this.escala);
        y2 = this.wAlto - this.cAlto - this.cAncho / 2 - (int)((double)this.cAlto * Math.cos(Math.PI * 2 * (x + 1.0 * this.t) / (1.0 + this.vEmisor)));
        g.fillOval(x2 - this.cAncho / 2, y2 - this.cAncho / 2, this.cAncho, this.cAncho);
        xFin = -1.0 * this.t - (1.0 + this.vEmisor) / (double)4;
        for (x = this.vEmisor * this.t; x > xFin; x -= 0.05) {
            x1 = this.orgX + (int)(x * this.escala);
            y1 = this.wAlto - this.cAlto - this.cAncho / 2 - (int)((double)this.cAlto * Math.cos(Math.PI * 2 * (x + 1.0 * this.t) / (1.0 + this.vEmisor)));
            g.drawLine(x1, y1, x2, y2);
            x2 = x1;
            y2 = y1;
        }
        x1 = this.orgX + (int)(xFin * this.escala);
        g.drawLine(x2, y2, x1, this.wAlto - this.cAlto - this.cAncho / 2);
        g.drawLine(x1, this.wAlto - this.cAlto - this.cAncho / 2, 0, this.wAlto - this.cAlto - this.cAncho / 2);
        g.setColor(Color.blue);
        x = this.xIniObservador + this.vObservador * this.t;
        x1 = this.orgX + (int)(x * this.escala);
        if (1.0 * this.t > x && this.vEmisor * this.t < x) {
            y1 = this.wAlto - this.cAlto - this.cAncho / 2 - (int)((double)this.cAlto * Math.cos(Math.PI * 2 * (x - 1.0 * this.t) / (1.0 - this.vEmisor)));
            g.fillOval(x1 - this.cAncho / 2, y1 - this.cAncho / 2, this.cAncho, this.cAncho);
        }
        if (this.vEmisor * this.t > x) {
            y1 = this.wAlto - this.cAlto - this.cAncho / 2 - (int)((double)this.cAlto * Math.cos(Math.PI * 2 * (x + 1.0 * this.t) / (1.0 + this.vEmisor)));
            g.fillOval(x1 - this.cAncho / 2, y1 - this.cAncho / 2, this.cAncho, this.cAncho);
        }
    }

    void emiteOndas(Graphics g) {
        g.setClip(0, 0, this.wAncho, this.wAlto - 2 * this.cAlto - this.cAncho);
        g.setColor(Color.red);
        g.fillRect(this.xEmisor - this.cAlto, this.orgY + this.cAlto + this.cAncho, 2 * this.cAlto, this.cAlto);
        g.drawLine(this.xEmisor, this.orgY, this.xEmisor, this.orgY + this.cAlto + this.cAncho);
        for (int i = 0; i < (int)this.t + 1; ++i) {
            int centro = this.orgX + (int)(this.vEmisor * (double)i * this.escala);
            int radio = (int)((this.t - (double)i) * this.escala);
            if (radio > this.wAncho) continue;
            g.drawOval(centro - radio, this.orgY - radio, 2 * radio, 2 * radio);
        }
        g.setColor(Color.blue);
        g.fillRect(this.xObservador - this.cAlto, this.orgY + this.cAlto + this.cAncho, 2 * this.cAlto, this.cAlto);
        g.drawLine(this.xObservador, this.orgY, this.xObservador, this.orgY + this.cAlto + this.cAncho);
        g.setColor(Color.blue);
        g.setColor(Color.black);
        g.drawString(String.valueOf("tiempo: ").concat(String.valueOf(String.valueOf(Math.floor(this.t * (double)100) / (double)100))), this.cAncho, this.cAlto);
        g.drawLine(0, this.wAlto - 2 * this.cAlto - this.cAncho - 1, this.wAncho, this.wAlto - 2 * this.cAlto - this.cAncho - 1);
    }

    public void paint(Graphics g) {
        this.origen(g);
        this.ejes(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, d.width, d.height);
        this.ejes(this.gBuffer);
        this.emiteOndas(this.gBuffer);
        this.funcionOnda(this.gBuffer);
        g.drawImage(this.imag, 0, 0, null);
    }
}

