/*
 * Decompiled with CFR 0.152.
 */
package gris5;

import gris5.Complejo;

public class Fresnel {
    static final double EPS = 6.0E-8;
    static final int MAXIT = 100;
    static final double FPMIN = 1.0E-30;
    static final double XMIN = 1.5;
    double s;
    double c;

    void integral(double x) {
        block10: {
            double ax = Math.abs(x);
            if (ax < Math.sqrt(1.0E-30)) {
                this.c = ax;
            } else if (ax <= 1.5) {
                int k;
                double sums = 0.0;
                double sum = 0.0;
                double sumc = ax;
                double sign = 1.0;
                double fact = Math.PI * ax * ax / (double)2;
                boolean odd = true;
                double term = ax;
                int n = 3;
                for (k = 1; k <= 100; ++k) {
                    double test = Math.abs(sum += sign * (term *= fact / (double)k) / (double)n) * 6.0E-8;
                    if (odd) {
                        sign = -sign;
                        sums = sum;
                        sum = sumc;
                    } else {
                        sumc = sum;
                        sum = sums;
                    }
                    if (term < test) break;
                    odd = !odd;
                    n += 2;
                }
                if (k > 100) {
                    this.nrerror("series failed in frenel");
                }
                this.s = sums;
                this.c = sumc;
            } else {
                int k;
                Complejo h;
                double pix2 = Math.PI * ax * ax;
                Complejo b = new Complejo(1.0, -pix2);
                Complejo cc = new Complejo(9.999999999999999E29, 0.0);
                Complejo d = h = Complejo.cociente(new Complejo(1.0, 0.0), b);
                int n = -1;
                for (k = 2; k <= 100; ++k) {
                    double a = -(n += 2) * (n + 1);
                    b = Complejo.suma(b, new Complejo(4.0, 0.0));
                    d = Complejo.cociente(new Complejo(1.0, 0.0), Complejo.suma(Complejo.producto(a, d), b));
                    cc = Complejo.suma(b, Complejo.cociente(new Complejo(a, 0.0), cc));
                    Complejo del = Complejo.producto(cc, d);
                    h = Complejo.producto(h, del);
                    if (Math.abs(del.real - 1.0) + Math.abs(del.imag) < 6.0E-8) break;
                }
                if (k > 100) {
                    this.nrerror("cf failed in frenel");
                }
                h = Complejo.producto(new Complejo(ax, -ax), h);
                Complejo cs = Complejo.producto(new Complejo(0.5, 0.5), Complejo.diferencia(new Complejo(1.0, 0.0), Complejo.producto(new Complejo(Math.cos(0.5 * pix2), Math.sin(0.5 * pix2)), h)));
                this.c = cs.real;
                this.s = cs.imag;
            }
            if (!(x < 0.0)) break block10;
            this.c = -this.c;
            this.s = -this.s;
        }
    }

    void nrerror(String texto) {
        System.out.println(texto);
    }
}

