/*
 * Decompiled with CFR 0.152.
 */
package sedimentacion;

import java.util.Random;

public class Sistema {
    final int nParticulas = 500;
    int ancho;
    int alto;
    final double Mt = 1.0;
    double Mb;
    double Vt;
    double dt = 1.0;
    double Fa;
    double[] X;
    double[] Y;
    double[] VX;
    double[] VY;
    Random rnd = new Random();

    public Sistema(double Vt, double Mb, double Fa, int eleccion, int ancho, int alto) {
        this.ancho = ancho;
        this.alto = alto;
        this.Vt = Vt;
        this.Mb = Mb;
        this.Fa = Fa;
        this.X = new double[500];
        this.Y = new double[500];
        this.VX = new double[500];
        this.VY = new double[500];
        for (int i = 0; i < 500; ++i) {
            this.VY[i] = 0.0;
            this.VY[i] = 0.0;
        }
        switch (eleccion) {
            case 0: {
                for (int i = 0; i < 500; ++i) {
                    this.Y[i] = 0.0;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < 500; ++i) {
                    this.Y[i] = alto;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < 500; ++i) {
                    this.Y[i] = alto / 2;
                }
                break;
            }
            case 3: {
                for (int i = 0; i < 500; ++i) {
                    this.Y[i] = (int)((double)alto * this.rnd.nextDouble());
                }
                break;
            }
        }
        for (int i = 0; i < 500; ++i) {
            this.X[i] = (int)((double)ancho * this.rnd.nextDouble());
        }
    }

    void evolucion() {
        for (int i = 0; i < 500; ++i) {
            double angulo = Math.PI * 2 * this.rnd.nextDouble();
            double Ux = this.VX[i] - this.Vt * Math.sin(angulo);
            double Uy = this.VY[i] - this.Vt * Math.cos(angulo);
            angulo = Math.PI * 2 * this.rnd.nextDouble();
            int n = i;
            this.VY[n] = this.VY[n] + (1.0 / (1.0 + this.Mb) * (Uy * (Math.cos(angulo) - 1.0) - Ux * Math.sin(angulo)) + this.Fa * this.dt);
            int n2 = i;
            this.VX[n2] = this.VX[n2] + 1.0 / (1.0 + this.Mb) * (Ux * (Math.cos(angulo) - 1.0) + Uy * Math.sin(angulo));
            int n3 = i;
            this.X[n3] = this.X[n3] + this.VX[i] * this.dt;
            int n4 = i;
            this.Y[n4] = this.Y[n4] + this.VY[i] * this.dt;
            if (this.X[i] < 0.0) {
                this.X[i] = -this.X[i];
                this.VX[i] = -this.VX[i];
            }
            if (this.X[i] > (double)this.ancho) {
                this.X[i] = (double)(2 * this.ancho) - this.X[i];
                this.VX[i] = -this.VX[i];
            }
            if (this.Y[i] < 0.0) {
                this.Y[i] = -this.Y[i];
                this.VY[i] = -this.VY[i];
            }
            if (!(this.Y[i] > (double)this.alto)) continue;
            this.Y[i] = (double)(2 * this.alto) - this.Y[i];
            this.VY[i] = -this.VY[i];
        }
    }
}

