/*
 * Decompiled with CFR 0.152.
 */
package termico6;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import termico6.TermicoApplet6;

public class MiCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    TermicoApplet6 parent;
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgX;
    int orgY;
    int orgXX;
    int orgYY;
    double escala;
    double escalaX;
    double escalaY;
    final double[] a2 = new double[]{11352.0, 79733.0, 8909.0, 37778.0, 5768.0, 42457.0};
    int iMetal;
    double t;
    final double dt = 0.25;
    double T1 = 0.0;
    double T2 = 0.0;
    double T0 = 15.0;
    double periodo = 80.0;
    boolean bCambia = false;
    int nMarca1;
    int nMarca2;
    boolean bArrastrar1 = false;
    boolean bArrastrar2 = false;
    Rectangle flecha1 = new Rectangle();
    Rectangle flecha2 = new Rectangle();
    Polygon pol_1 = new Polygon();
    Polygon pol_2 = new Polygon();
    int iZoom = 1;
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas(TermicoApplet6 p) {
        this.parent = p;
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.flecha1.setSize(8, 16);
        this.flecha2.setSize(8, 16);
    }

    void origenEscalas(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgY = 3 * this.cAlto + 2 * this.cAncho;
        this.orgX = 2 * this.cAlto;
        this.escala = (double)(this.wAncho - this.cAncho - this.orgX) / 50.0;
        this.orgXX = 6 * this.cAncho;
        this.orgYY = this.orgY + (this.wAlto - this.orgY) / 2 + this.cAlto;
        this.escalaX = (double)(this.wAncho - this.orgXX - 2 * this.cAncho) / this.periodo;
        this.escalaY = (double)(this.wAlto - this.orgY - 3 * this.cAlto) / ((double)2 * this.T0);
        this.nMarca1 = 8;
        this.nMarca2 = 16;
        this.flecha1.x = this.orgX + (int)((double)this.nMarca1 * this.escala);
        this.flecha2.x = this.orgX + (int)((double)this.nMarca2 * this.escala);
        this.flecha1.y = this.flecha2.y = this.orgY - this.cAlto;
    }

    void setInicio() {
        this.nMarca1 = 8;
        this.nMarca2 = 16;
        this.flecha1.x = this.orgX + (int)((double)this.nMarca1 * this.escala);
        this.flecha2.x = this.orgX + (int)((double)this.nMarca2 * this.escala);
        this.flecha1.y = this.flecha2.y = this.orgY - this.cAlto;
        this.t = 0.0;
        this.pol_1.npoints = 0;
        this.pol_2.npoints = 0;
        this.bCambia = false;
        this.repaint();
    }

    void setNuevo(double temp, double periodo, int iMetal, int iZoom) {
        this.T0 = temp;
        this.iMetal = iMetal;
        this.periodo = periodo;
        this.iZoom = iZoom;
        this.t = 0.0;
        this.bCambia = false;
        this.pol_1.npoints = 0;
        this.pol_2.npoints = 0;
        this.escalaX = (double)(this.wAncho - this.orgXX - 2 * this.cAncho) / periodo;
        this.escalaY = (double)(this.wAlto - this.orgY - 3 * this.cAlto) / ((double)2 * this.T0);
    }

    void dispositivo(Graphics g) {
        String texto;
        g.setColor(Color.lightGray);
        int x1 = (int)(50.0 * this.escala);
        g.fillRect(this.orgX, this.orgY - this.cAlto, x1, this.cAlto);
        g.setColor(Color.black);
        g.drawRect(this.orgX, this.orgY - this.cAlto, x1, this.cAlto);
        g.drawString("cm", this.orgX + x1, this.orgY + this.cAncho + this.cAlto);
        for (int i = 0; i <= 50; i += 5) {
            x1 = this.orgX + (int)((double)i * this.escala);
            g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho);
            texto = String.valueOf(i);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, this.orgY + this.cAncho + this.cAlto);
            if (i == 50) break;
            for (int j = 1; j < 5; ++j) {
                x1 = this.orgX + (int)((double)(i + j) * this.escala);
                g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho / 2);
            }
        }
        g.setColor(Color.lightGray);
        g.fillRoundRect(this.cAncho, (this.orgY - this.cAlto) / 2 - this.cAlto, 10 * this.cAncho, 2 * this.cAlto, this.cAncho, this.cAncho);
        g.setColor(Color.black);
        g.drawRoundRect(this.cAncho, (this.orgY - this.cAlto) / 2 - this.cAlto, 10 * this.cAncho, 2 * this.cAlto, this.cAncho, this.cAncho);
        g.drawLine(5 * this.cAncho, (this.orgY - this.cAlto) / 2 + this.cAlto, this.orgX - this.cAncho, this.orgY - this.cAlto);
        if (this.bCambia) {
            g.setColor(Color.blue);
            g.fillRect(this.orgX - 2 * this.cAncho, this.orgY - this.cAlto, 2 * this.cAncho, this.cAlto);
        } else {
            g.setColor(Color.red);
            g.fillRect(this.orgX - 2 * this.cAncho, this.orgY - this.cAlto, 2 * this.cAncho, this.cAlto);
        }
        g.drawImage(this.parent.marca1, this.flecha1.x - this.flecha1.width / 2, this.flecha1.y, this);
        g.drawImage(this.parent.marca2, this.flecha2.x - this.flecha2.width / 2, this.flecha2.y, this);
        g.setColor(Color.pink);
        g.fillRoundRect(this.wAncho / 2 + 2 * this.cAlto, (this.orgY - this.cAlto) / 2 - this.cAlto, 10 * this.cAncho, 2 * this.cAlto, this.cAncho, this.cAncho);
        g.setColor(Color.black);
        g.drawRoundRect(this.wAncho / 2 + 2 * this.cAlto, (this.orgY - this.cAlto) / 2 - this.cAlto, 10 * this.cAncho, 2 * this.cAlto, this.cAncho, this.cAncho);
        g.setColor(Color.cyan);
        g.fillRoundRect(this.wAncho / 2 - 2 * this.cAlto - 10 * this.cAncho, (this.orgY - this.cAlto) / 2 - this.cAlto, 10 * this.cAncho, 2 * this.cAlto, this.cAncho, this.cAncho);
        g.setColor(Color.black);
        g.drawRoundRect(this.wAncho / 2 - 2 * this.cAlto - 10 * this.cAncho, (this.orgY - this.cAlto) / 2 - this.cAlto, 10 * this.cAncho, 2 * this.cAlto, this.cAncho, this.cAncho);
        g.setColor(Color.black);
        Font oldFont = g.getFont();
        Font fuente = new Font("Times", 1, 14);
        g.setFont(fuente);
        texto = String.valueOf((double)Math.round(this.T2 * (double)1000) / (double)1000);
        if (texto.substring(texto.indexOf(".")).length() == 3) {
            texto = String.valueOf(texto).concat(String.valueOf("0"));
        }
        g.drawString(texto, this.wAncho / 2 + 2 * this.cAlto + 5 * this.cAncho - g.getFontMetrics().stringWidth(texto) / 2, (this.orgY - this.cAlto) / 2 + g.getFontMetrics().getHeight() / 2);
        texto = String.valueOf((double)Math.round(this.T1 * (double)1000) / (double)1000);
        if (texto.substring(texto.indexOf(".")).length() == 3) {
            texto = String.valueOf(texto).concat(String.valueOf("0"));
        }
        g.drawString(texto, this.wAncho / 2 - 2 * this.cAlto - 5 * this.cAncho - g.getFontMetrics().stringWidth(texto) / 2, (this.orgY - this.cAlto) / 2 + g.getFontMetrics().getHeight() / 2);
        texto = String.valueOf((double)Math.round(this.t * (double)10) / (double)10);
        if (texto.substring(texto.indexOf(".")).length() == 1) {
            texto = String.valueOf(texto).concat(String.valueOf("0"));
        }
        g.drawString(texto, 6 * this.cAncho - g.getFontMetrics().stringWidth(texto) / 2, (this.orgY - this.cAlto) / 2 + g.getFontMetrics().getHeight() / 2);
        g.setFont(oldFont);
        this.grafica(g);
    }

    void grafica(Graphics g) {
        int y1;
        String texto;
        int x1;
        g.setColor(Color.black);
        g.drawLine(this.orgXX, this.orgYY, this.wAncho, this.orgYY);
        g.drawString("t", this.wAncho - 2 * this.cAncho, this.orgYY - 2);
        for (int i = 1; i <= 10; ++i) {
            x1 = this.orgX + (int)((double)i * this.periodo * this.escalaX / (double)10);
            g.drawLine(x1, this.orgYY, x1, this.orgYY + this.cAncho);
            texto = String.valueOf((double)i * this.periodo / (double)10);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, this.orgYY + this.cAncho + this.cAlto);
        }
        g.drawLine(this.orgXX, this.wAlto, this.orgXX, this.wAlto / 4);
        g.drawString("T", this.orgXX + this.cAncho, this.orgY + 2 * this.cAlto);
        for (int i = -10; i <= 10; i += 2) {
            y1 = this.orgYY - (int)((double)i * this.T0 * this.escalaY / (double)10);
            texto = String.valueOf((double)Math.round((double)i * this.T0 * (double)100 / (double)(10 * this.iZoom)) / (double)100);
            g.drawString(texto, this.orgXX - this.cAncho - g.getFontMetrics().stringWidth(texto), y1 + this.cAlto / 4);
            g.drawLine(this.orgXX, y1, this.orgXX - this.cAncho / 2, y1);
            if (Math.abs(i) != 5) continue;
            g.drawLine(this.orgXX, y1, this.orgXX - this.cAncho, y1);
        }
        x1 = this.orgXX + (int)(this.t % this.periodo * this.escalaX);
        y1 = this.orgYY - (int)(this.T1 * this.escalaY * (double)this.iZoom);
        int y2 = this.orgYY - (int)(this.T2 * this.escalaY * (double)this.iZoom);
        if (this.t < this.periodo) {
            this.pol_1.addPoint(x1, y1);
            this.pol_2.addPoint(x1, y2);
        }
        g.setColor(Color.blue);
        g.drawPolyline(this.pol_1.xpoints, this.pol_1.ypoints, this.pol_1.npoints);
        g.fillOval(x1 - 2, y1 - 2, 4, 4);
        g.setColor(Color.red);
        g.drawPolyline(this.pol_2.xpoints, this.pol_2.ypoints, this.pol_2.npoints);
        g.fillOval(x1 - 2, y2 - 2, 4, 4);
    }

    double funcion(double x, double t) {
        double suma = 0.0;
        for (int i = 1; i < 100; i += 2) {
            double w = (double)(2 * i) * Math.PI / this.periodo;
            double k = Math.sqrt(w * this.a2[this.iMetal] / (double)2);
            double A = (double)4 * this.T0 * Math.exp(-k * x) / ((double)i * Math.PI);
            suma += A * Math.sin(w * t - k * x);
        }
        return suma;
    }

    void mover() {
        this.t += 0.25;
        this.bCambia = false;
        this.T1 = this.funcion((double)this.nMarca1 / (double)100, this.t);
        this.T2 = this.funcion((double)this.nMarca2 / (double)100, this.t);
        if (this.t % this.periodo < this.periodo / (double)2) {
            this.bCambia = true;
        }
        this.repaint();
    }

    public void paint(Graphics g) {
        this.origenEscalas(g);
        this.update(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, d.width, d.height);
        this.dispositivo(this.gBuffer);
        g.drawImage(this.imag, 0, 0, null);
    }

    public void mousePressed(MouseEvent ev) {
        if (this.flecha1.contains(ev.getX(), ev.getY())) {
            this.bArrastrar1 = true;
        }
        if (this.flecha2.contains(ev.getX(), ev.getY())) {
            this.bArrastrar2 = true;
        }
    }

    public void mouseReleased(MouseEvent ev) {
        int x1 = this.orgX + (int)(50.0 * this.escala);
        if (this.bArrastrar1) {
            this.nMarca1 = (int)Math.round((double)(ev.getX() - this.orgX) / this.escala);
            this.flecha1.x = this.orgX + (int)((double)this.nMarca1 * this.escala);
            this.bArrastrar1 = false;
            if (this.flecha1.x < this.orgX) {
                this.flecha1.x = this.orgX;
                this.nMarca1 = 0;
            }
            if (this.flecha1.x > x1) {
                this.flecha1.x = x1;
                this.nMarca1 = 50;
            }
            this.repaint();
        }
        if (this.bArrastrar2) {
            this.nMarca2 = (int)Math.round((double)(ev.getX() - this.orgX) / this.escala);
            this.flecha2.x = this.orgX + (int)((double)this.nMarca2 * this.escala);
            this.bArrastrar2 = false;
            if (this.flecha2.x < this.orgX) {
                this.flecha2.x = this.orgX;
                this.nMarca2 = 0;
            }
            if (this.flecha2.x > x1) {
                this.flecha2.x = x1;
                this.nMarca2 = 50;
            }
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent ev) {
        int x1 = this.orgX + (int)(50.0 * this.escala);
        if (ev.getX() < this.orgX || ev.getX() > x1) {
            return;
        }
        if (this.bArrastrar1) {
            this.flecha1.x = ev.getX();
            this.repaint();
        }
        if (this.bArrastrar2) {
            this.flecha2.x = ev.getX();
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent ev) {
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseMoved(MouseEvent ev) {
    }
}

