/*
 * Decompiled with CFR 0.152.
 */
package termico7;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import termico7.TermicoApplet7;

public class MiCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    TermicoApplet7 parent;
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgX;
    int orgY;
    int orgXX;
    int orgYY;
    double escala;
    double escalaX;
    double escalaY;
    double escTermo;
    final double[] esc = new double[]{1.0, 2.0, 5.0, 10.0};
    int iEscala = 1;
    double a2;
    double constante;
    double longitud = 25.0;
    double xTermo = 3.0;
    double tempTermo = 0.0;
    double t;
    double t0;
    final double T0 = 0.0;
    double dt = 1.0;
    boolean bConecta = false;
    boolean bGrafica = false;
    boolean bMensaje = false;
    int contador;
    Polygon pol = new Polygon();
    boolean bArrastrar = false;
    Rectangle flecha = new Rectangle();
    int xMarca;
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas(TermicoApplet7 p) {
        this.parent = p;
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    void origenEscalas(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgY = this.wAlto - this.cAlto - this.cAncho;
        this.orgX = 6 * this.cAncho;
        this.escala = (double)(this.wAncho - this.cAncho - this.orgX - 2 * this.cAlto) / this.longitud;
        this.orgXX = 6 * this.cAncho;
        this.orgYY = this.wAlto - this.cAlto - this.cAncho;
        this.escalaX = (double)(this.wAncho - this.orgXX - 2 * this.cAncho) / 1000.0;
        this.escalaY = (double)(this.orgYY - this.cAncho) / 100.0;
        this.escTermo = (double)(this.orgY - 3 * this.cAlto) / 100.0;
        this.flecha.setSize(2 * this.cAncho, 2 * this.cAncho);
        this.flecha.x = this.orgX + (int)(this.xTermo * this.escala) - this.cAncho / 2;
        this.flecha.y = this.orgY - this.cAlto;
    }

    void setInicio() {
        this.t = 0.0;
        this.t0 = 0.0;
        this.dt = 1.0;
        this.tempTermo = 0.0;
        this.pol.npoints = 0;
        this.bConecta = false;
        this.bMensaje = false;
        this.repaint();
    }

    void setNuevo(double potencia, double K, double c, int iEscala) {
        this.iEscala = iEscala;
        this.escalaX = (double)(this.wAncho - this.orgXX - 2 * this.cAncho) / (this.esc[iEscala] * 2000.0);
        this.t = 0.0;
        this.dt *= this.esc[iEscala];
        this.pol.npoints = 0;
        this.constante = potencia / (K * Math.PI * 0.005 * 0.005);
        this.a2 = (double)5000 * c / K;
        this.bConecta = true;
        this.bMensaje = false;
        this.t0 = 0.0;
        this.contador = 0;
        this.repaint();
    }

    void setDesconectar() {
        this.bConecta = false;
        this.t0 = this.t;
        this.repaint();
    }

    void setGrafica(boolean bGrafica) {
        this.bGrafica = bGrafica;
        this.repaint();
    }

    void dispositivo(Graphics g) {
        String texto;
        g.setColor(Color.lightGray);
        int x1 = (int)(this.longitud * this.escala);
        g.fillRect(this.orgX, this.orgY - this.cAlto, x1, this.cAlto);
        g.setColor(Color.black);
        g.drawRect(this.orgX, this.orgY - this.cAlto, x1, this.cAlto);
        g.drawRect(this.orgX + 1, this.orgY - this.cAlto + 1, x1 - 2, this.cAlto - 2);
        g.setColor(Color.black);
        for (int i = 0; i <= 25; i += 5) {
            x1 = this.orgX + (int)((double)i * this.escala);
            g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho);
            texto = String.valueOf(i);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, this.orgY + this.cAncho + this.cAlto - 2);
            if (i == 25) break;
            for (int j = 1; j < 5; ++j) {
                x1 = this.orgX + (int)((double)(i + j) * this.escala);
                g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho / 2);
            }
        }
        if (this.bConecta) {
            g.setColor(Color.red);
            g.fillRect(0, this.orgY - this.cAlto, this.orgX, this.cAlto);
            for (int i = 0; i < 2 * this.orgX / this.cAncho; i += 2) {
                g.drawLine(i * this.cAncho / 2, this.wAlto - this.cAlto - this.cAncho + 2, (i + 1) * this.cAncho / 2, this.wAlto - 2 - this.cAncho);
                g.drawLine((i + 1) * this.cAncho / 2, this.wAlto - 2 - this.cAncho, (i + 2) * this.cAncho / 2, this.wAlto - this.cAlto + 2 - this.cAncho);
            }
            g.setColor(Color.black);
            g.drawRect(0, this.orgY - this.cAlto, this.orgX, this.cAlto + 2 * this.cAncho);
            g.drawRect(0, this.orgY - this.cAlto - 1, this.orgX + 1, this.cAlto + 2 * this.cAncho + 2);
        } else {
            g.setColor(Color.blue);
            g.fillRect(0, this.orgY - this.cAlto, this.orgX, this.cAlto);
            g.setColor(Color.black);
            g.drawRect(0, this.orgY - this.cAlto - 1, this.orgX, this.cAlto + 1);
        }
        x1 = this.orgX + (int)(this.longitud * this.escala);
        g.setColor(Color.blue);
        g.fillRect(x1, this.orgY - this.cAlto, this.wAncho - x1, this.cAlto);
        g.setColor(Color.black);
        g.drawRect(x1, this.orgY - this.cAlto - 1, this.wAncho - x1, this.cAlto + 1);
        x1 = this.orgX + (int)(this.xTermo * this.escala);
        texto = String.valueOf((double)Math.round(this.xTermo * (double)10) / (double)10);
        g.drawString(texto, x1 - 4 * this.cAncho, this.orgY - 2);
        this.termometro(g, x1, this.orgY - this.cAlto - this.cAncho, this.tempTermo);
        this.termometro(g, this.wAncho - 4 * this.cAncho, this.orgY - this.cAlto - this.cAncho, 0.0);
        Font oldFont = g.getFont();
        Font fuente = new Font("Times", 1, 14);
        g.setFont(fuente);
        texto = String.valueOf((double)Math.round((this.t - this.t0) * (double)10) / (double)10);
        g.drawString(String.valueOf("t(s): ").concat(String.valueOf(texto)), this.wAncho / 2 - g.getFontMetrics().stringWidth(texto) / 2, g.getFontMetrics().getHeight());
        g.setColor(Color.red);
        if (this.bMensaje) {
            texto = "Desconecte";
            g.drawString(texto, this.wAncho - g.getFontMetrics().stringWidth(texto) - 10 * this.cAncho, g.getFontMetrics().getHeight());
        }
        g.setFont(oldFont);
    }

    void grafica(Graphics g) {
        int y1;
        String texto;
        int x1;
        g.setColor(Color.black);
        g.drawLine(this.orgXX, this.orgYY, this.wAncho, this.orgYY);
        g.drawString("t", this.wAncho - 2 * this.cAncho, this.orgYY - 2);
        int di = (int)((double)200 * this.esc[this.iEscala]);
        int i = 0;
        while ((double)i <= (double)2000 * this.esc[this.iEscala]) {
            x1 = this.orgXX + (int)((double)i * this.escalaX);
            g.drawLine(x1, this.orgYY, x1, this.orgYY + this.cAncho);
            texto = String.valueOf(i);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, this.orgYY + this.cAncho + this.cAlto);
            i += di;
        }
        g.drawLine(this.orgXX, 0, this.orgXX, this.orgYY);
        g.drawString("T", this.orgXX + this.cAncho, this.cAlto);
        for (int i2 = 0; i2 <= 100; i2 += 10) {
            y1 = this.orgYY - (int)((double)i2 * this.escalaY);
            texto = String.valueOf(i2);
            g.drawString(texto, this.orgXX - this.cAncho - g.getFontMetrics().stringWidth(texto), y1 + this.cAlto / 4);
            g.drawLine(this.orgXX, y1, this.orgXX - this.cAncho, y1);
            for (int j = 1; j < 5; ++j) {
                y1 = this.orgYY - (int)((double)(i2 + 2 * j) * this.escalaY);
                g.drawLine(this.orgXX, y1, this.orgXX - this.cAncho / 2, y1);
            }
        }
        g.setColor(Color.red);
        g.drawPolyline(this.pol.xpoints, this.pol.ypoints, this.pol.npoints);
        x1 = this.orgXX + (int)(this.t * this.escalaX);
        y1 = this.orgYY - (int)(this.tempTermo * this.escalaY);
        g.fillOval(x1 - 2, y1 - 2, 4, 4);
        do {
            g.drawLine(x1, y1, x1, y1 + this.cAncho / 2);
        } while ((y1 += this.cAncho) < this.orgYY);
        y1 = this.orgYY - (int)(this.tempTermo * this.escalaY);
        do {
            g.drawLine(x1, y1, x1 - this.cAncho / 2, y1);
        } while ((x1 -= this.cAncho) > this.orgXX);
        x1 = this.orgXX + (int)(this.t * this.escalaX);
        g.setColor(Color.black);
        texto = String.valueOf(Math.round(this.t));
        g.drawString(texto, x1 + 2, this.orgYY - 2);
        texto = String.valueOf((double)Math.round(this.tempTermo * (double)10) / (double)10);
        g.drawString(texto, this.orgXX + 2, y1 - 2);
        Font oldFont = g.getFont();
        Font fuente = new Font("Times", 1, 14);
        g.setFont(fuente);
        g.setColor(Color.red);
        texto = "Desconecte";
        if (this.bMensaje) {
            g.drawString(texto, this.wAncho / 2 - g.getFontMetrics().stringWidth(texto) / 2, g.getFontMetrics().getHeight());
        }
        g.setFont(oldFont);
    }

    void mover() {
        this.t += this.dt;
        if (this.bConecta) {
            this.tempTermo = this.fConectar(this.t);
            if (0.0 + this.constante * (this.longitud - this.xTermo) / (double)100 - this.tempTermo < 0.5) {
                this.parent.btnEmpieza.setEnabled(true);
                this.bMensaje = true;
            }
        } else {
            this.tempTermo = this.fDesconectar(this.t - this.t0);
        }
        int x1 = this.orgXX + (int)(this.t * this.escalaX);
        int y1 = this.orgYY - (int)(this.tempTermo * this.escalaY);
        if (this.contador % 3 == 0) {
            this.pol.addPoint(x1, y1);
        }
        ++this.contador;
        this.repaint();
    }

    double fConectar(double t) {
        double v;
        double suma = 0.0;
        int n = 1;
        do {
            v = Math.exp((double)(-(2 * n - 1) * (2 * n - 1)) * Math.PI * Math.PI * t * (double)10000 / ((double)4 * this.a2 * this.longitud * this.longitud));
            suma += v * Math.cos(Math.PI * (double)(2 * n - 1) * this.xTermo / ((double)2 * this.longitud)) / (((double)n - 0.5) * ((double)n - 0.5));
            ++n;
        } while (v > 0.001);
        return 0.0 + this.constante * (this.longitud - this.xTermo) / (double)100 - suma * (double)2 * this.constante * this.longitud / 986.9604401089358;
    }

    double fDesconectar(double t) {
        double v;
        double suma = 0.0;
        int n = 1;
        do {
            v = Math.exp((double)(-(2 * n - 1) * (2 * n - 1)) * Math.PI * Math.PI * t * (double)10000 / ((double)4 * this.a2 * this.longitud * this.longitud));
            suma += v * Math.cos(Math.PI * (double)(2 * n - 1) * this.xTermo / ((double)2 * this.longitud)) / (((double)n - 0.5) * ((double)n - 0.5));
            ++n;
        } while (v > 0.001);
        return 0.0 + suma * (double)2 * this.constante * this.longitud / 986.9604401089358;
    }

    void termometro(Graphics g, int orgXtermo, int orgYtermo, double temp) {
        int y1 = orgYtermo - (int)(temp * this.escTermo);
        g.setColor(this.getBackground());
        g.fillRect(orgXtermo, 0, this.cAncho, orgYtermo + this.cAncho);
        g.setColor(Color.red);
        g.fillRect(orgXtermo, y1, this.cAncho, orgYtermo - y1 + this.cAncho);
        g.fillOval(orgXtermo - this.cAncho / 2, orgYtermo + this.cAncho, 2 * this.cAncho, 3 * this.cAncho / 2);
        g.setColor(Color.black);
        String texto = String.valueOf((double)Math.round(temp * (double)10) / (double)10);
        g.drawString(texto, orgXtermo - 4 * this.cAncho, y1 - 2);
        g.drawRect(orgXtermo, 0, this.cAncho, orgYtermo + this.cAncho);
        g.drawOval(orgXtermo - this.cAncho / 2, orgYtermo + this.cAncho, 2 * this.cAncho, 3 * this.cAncho / 2);
        for (int i = 0; i <= 100; i += 10) {
            y1 = orgYtermo - (int)((double)i * this.escTermo);
            g.drawLine(orgXtermo + this.cAncho / 2, y1, orgXtermo + 3 * this.cAncho / 2, y1);
            g.drawString(String.valueOf(i), orgXtermo + 2 * this.cAncho, y1 + this.cAlto / 4);
            if (i == 100) break;
            for (int j = 1; j < 5; ++j) {
                y1 = orgYtermo - (int)((double)(i + 2 * j) * this.escTermo);
                g.drawLine(orgXtermo + this.cAncho, y1, orgXtermo + this.cAncho / 2, y1);
            }
        }
    }

    public void paint(Graphics g) {
        this.origenEscalas(g);
        this.update(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, d.width, d.height);
        if (this.bGrafica) {
            this.grafica(this.gBuffer);
        } else {
            this.dispositivo(this.gBuffer);
        }
        g.drawImage(this.imag, 0, 0, null);
    }

    public void mousePressed(MouseEvent ev) {
        if (this.flecha.contains(ev.getX(), ev.getY())) {
            this.xMarca = ev.getX();
            this.bArrastrar = true;
        }
    }

    public void mouseReleased(MouseEvent ev) {
        if (this.bArrastrar) {
            this.bArrastrar = false;
            this.flecha.x += ev.getX() - this.xMarca;
            this.xTermo = (double)(-this.orgX + this.flecha.x + this.flecha.width / 2) / this.escala;
            if (this.xTermo < (double)2) {
                this.xTermo = 2.0;
            }
            if (this.xTermo > (double)23) {
                this.xTermo = 23.0;
            }
            this.flecha.x = this.orgX + (int)(this.xTermo * this.escala) - this.flecha.width / 2;
        }
        this.xMarca = ev.getX();
        this.repaint();
    }

    public void mouseDragged(MouseEvent ev) {
        int x1 = this.orgX + (int)((double)23 * this.escala);
        int x2 = this.orgX + (int)((double)2 * this.escala);
        if (this.bArrastrar && this.flecha.x + this.flecha.width / 2 <= x1 && this.flecha.x + this.flecha.width / 2 >= x2) {
            this.flecha.x += ev.getX() - this.xMarca;
            this.xTermo = (double)(-this.orgX + this.flecha.x + this.flecha.width / 2) / this.escala;
            if (this.xTermo < (double)2) {
                this.xTermo = 2.0;
            }
            if (this.xTermo > (double)23) {
                this.xTermo = 23.0;
            }
            this.flecha.x = this.orgX + (int)(this.xTermo * this.escala) - this.flecha.width / 2;
        }
        this.xMarca = ev.getX();
        this.repaint();
    }

    public void mouseClicked(MouseEvent ev) {
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseMoved(MouseEvent ev) {
    }
}

