/*
 * Decompiled with CFR 0.152.
 */
package termico9;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import termico9.Sistema;
import termico9.TermicoApplet9;

public class MiCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    TermicoApplet9 parent;
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgX;
    int orgY;
    double escalaX;
    double escTermo;
    final double[] datos = new double[]{11352.0, 79733.0, 8909.0, 37778.0, 5768.0, 42457.0};
    int iMetal = 0;
    double tOld;
    double[] T = new double[3];
    boolean bGrafica = false;
    boolean bNuevo = true;
    Sistema sis;
    Polygon pol = new Polygon();
    Polygon polOld = new Polygon();
    boolean[] bArrastrar = new boolean[3];
    Rectangle[] marca = new Rectangle[3];
    int[] yMarca = new int[3];
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas(TermicoApplet9 p) {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        for (int i = 0; i < this.marca.length; ++i) {
            this.bArrastrar[i] = false;
            this.marca[i] = new Rectangle();
            this.marca[i].setSize(16, 8);
        }
        this.T[0] = 100.0;
        this.T[1] = 20.0;
        this.T[2] = 10.0;
        this.parent = p;
        this.setBackground(Color.white);
    }

    void origenEscalas(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgY = this.wAlto - 2 * this.cAlto - this.cAncho;
        this.orgX = 6 * this.cAncho;
        this.escalaX = (double)(this.wAncho - 2 * this.orgX) / 0.5;
        this.escTermo = (double)(this.orgY - this.cAlto) / 100.0;
        this.marcaInicial();
    }

    void marcaInicial() {
        int y1 = this.orgY - (int)(this.escTermo * this.T[0]) - this.marca[0].height / 2;
        this.marca[0].setLocation(4 * this.cAncho - this.marca[0].width, y1);
        y1 = this.orgY - (int)(this.escTermo * this.T[1]) - this.marca[1].height / 2;
        this.marca[1].setLocation(this.wAncho / 2 - this.marca[1].width, y1);
        y1 = this.orgY - (int)(this.escTermo * this.T[2]) - this.marca[2].height / 2;
        this.marca[2].setLocation(this.wAncho - 5 * this.cAncho - this.marca[2].width, y1);
    }

    void setInicio() {
        this.pol.npoints = 0;
        this.bGrafica = false;
        this.bNuevo = true;
        this.repaint();
    }

    void setNuevo(int iMet, double t) {
        if (iMet != this.iMetal || this.bNuevo) {
            this.bNuevo = true;
            this.iMetal = iMet;
            this.sis = new Sistema(this.T[0], this.T[2], this.T[1], this.datos[this.iMetal]);
        }
        this.sis.setTiempo(t * (double)60);
        this.bGrafica = true;
        this.polOld = !this.bNuevo ? new Polygon(this.pol.xpoints, this.pol.ypoints, this.pol.npoints) : new Polygon();
        this.bNuevo = false;
        this.pol.npoints = 0;
        this.repaint();
    }

    void dispositivo(Graphics g) {
        int x1;
        g.setColor(Color.lightGray);
        g.fillRect(this.orgX, this.orgY, this.wAncho - this.orgX, this.cAlto);
        g.setColor(Color.black);
        g.drawRect(this.orgX, this.orgY, this.wAncho - 2 * this.orgX, this.cAlto);
        g.drawRect(this.orgX + 1, this.orgY + 1, this.wAncho - 2 * this.orgX - 1, this.cAlto - 1);
        for (int i = 0; i <= 50; i += 10) {
            x1 = this.orgX + (int)((double)i * this.escalaX / (double)100);
            g.drawLine(x1, this.orgY + this.cAlto, x1, this.orgY + this.cAlto + this.cAncho);
            String texto = String.valueOf(i);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, this.wAlto - 2);
            if (i == 50) break;
            for (int j = 1; j < 10; ++j) {
                x1 = this.orgX + (int)((double)(i + j) * this.escalaX / (double)100);
                g.drawLine(x1, this.orgY + this.cAlto, x1, this.orgY + this.cAlto + this.cAncho / 2);
                if (j != 5) continue;
                g.drawLine(x1, this.orgY + this.cAlto, x1, this.orgY + this.cAlto + 3 * this.cAncho / 4);
            }
        }
        x1 = this.orgX + (int)(0.5 * this.escalaX);
        g.setColor(Color.blue);
        g.fillRect(0, this.orgY, this.orgX, this.cAlto);
        g.fillRect(x1, this.orgY, this.wAncho - x1, this.cAlto);
        g.setColor(Color.black);
        g.drawRect(0, this.orgY, this.orgX, this.cAlto);
        g.drawRect(x1, this.orgY, this.wAncho - x1, this.cAlto);
        this.termometro(g, 4 * this.cAncho, this.orgY, this.T[0]);
        this.termometro(g, this.wAncho - 5 * this.cAncho, this.orgY, this.T[2]);
        this.termometro(g, this.wAncho / 2, this.orgY, this.T[1]);
        for (int i = 0; i < this.marca.length; ++i) {
            g.drawImage(this.parent.marca, this.marca[i].x, this.marca[i].y, this);
        }
    }

    void grafica(Graphics g) {
        String str;
        int y1;
        g.setColor(Color.black);
        g.drawLine(0, this.orgY, this.wAncho, this.orgY);
        g.drawString("x(m)", this.wAncho - 3 * this.cAncho, this.orgY - 2);
        g.drawLine(this.orgX, 0, this.orgX, this.orgY);
        for (int i = 0; i <= 100; i += 10) {
            y1 = this.orgY - (int)((double)i * this.escTermo);
            g.drawLine(this.orgX, y1, this.orgX + this.cAncho, y1);
            str = String.valueOf(i);
            g.drawString(str, this.orgX - this.cAncho - g.getFontMetrics().stringWidth(str), y1 + this.cAlto / 2);
            for (int j = 1; j < 5; ++j) {
                y1 = this.orgY - (int)((double)(i + 2 * j) * this.escTermo);
                g.drawLine(this.orgX, y1, this.orgX + this.cAncho / 2, y1);
            }
        }
        int x1 = this.orgX + (int)(0.5 * this.escalaX);
        g.drawLine(x1, 0, x1, this.orgY);
        for (int i = 0; i <= 100; i += 10) {
            y1 = this.orgY - (int)((double)i * this.escTermo);
            g.drawLine(x1, y1, x1 + this.cAncho, y1);
            str = String.valueOf(i);
            g.drawString(str, x1 + this.cAncho, y1 + this.cAlto / 2);
            for (int j = 1; j < 5; ++j) {
                y1 = this.orgY - (int)((double)(i + 2 * j) * this.escTermo);
                g.drawLine(x1, y1, x1 + this.cAncho / 2, y1);
            }
        }
        for (int i = 0; i <= 50; i += 10) {
            x1 = this.orgX + (int)((double)i * this.escalaX / (double)100);
            g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho);
            str = String.valueOf(i);
            g.drawString(str, x1 - g.getFontMetrics().stringWidth(str) / 2, this.orgY + this.cAncho + this.cAlto - 2);
            if (i == 50) break;
            for (int j = 1; j < 10; ++j) {
                x1 = this.orgX + (int)((double)(i + j) * this.escalaX / (double)100);
                g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho / 2);
                if (j != 5) continue;
                g.drawLine(x1, this.orgY, x1, this.orgY + 3 * this.cAncho / 4);
            }
        }
        this.pol.npoints = 0;
        for (double x = 0.0; x <= 0.5; x += 0.005) {
            y1 = this.orgY - (int)(this.sis.evolucion(x) * this.escTermo);
            x1 = this.orgX + (int)(x * this.escalaX);
            this.pol.addPoint(x1, y1);
        }
        y1 = this.orgY - (int)(this.sis.evolucion(0.5) * this.escTermo);
        x1 = this.orgX + (int)(0.5 * this.escalaX);
        this.pol.addPoint(x1, y1);
        g.setColor(Color.blue);
        g.drawPolyline(this.polOld.xpoints, this.polOld.ypoints, this.polOld.npoints);
        g.fillRect(this.orgX + 30 * this.cAncho, this.cAlto / 2, this.cAlto, this.cAncho / 2);
        g.setColor(Color.red);
        g.drawPolyline(this.pol.xpoints, this.pol.ypoints, this.pol.npoints);
        g.fillRect(this.orgX + 10 * this.cAncho, this.cAlto / 2, this.cAlto, this.cAncho / 2);
        g.setColor(Color.black);
        str = String.valueOf((double)Math.round(this.sis.t / (double)60 * (double)10) / (double)10);
        g.drawString(str, this.orgX + 11 * this.cAncho + this.cAlto, this.cAlto);
        str = String.valueOf((double)Math.round(this.tOld / (double)60 * (double)10) / (double)10);
        g.drawString(str, this.orgX + 31 * this.cAncho + this.cAlto, this.cAlto);
        this.tOld = this.sis.t;
    }

    void termometro(Graphics g, int orgXtermo, int orgYtermo, double temp) {
        int y1 = orgYtermo - (int)(temp * this.escTermo);
        g.setColor(this.getBackground());
        g.fillRect(orgXtermo, 0, this.cAncho, orgYtermo + this.cAncho);
        g.setColor(Color.red);
        g.fillRect(orgXtermo, y1, this.cAncho, orgYtermo - y1 + this.cAncho);
        g.fillOval(orgXtermo - this.cAncho / 2, orgYtermo + this.cAncho, 2 * this.cAncho, 3 * this.cAncho / 2);
        g.setColor(Color.black);
        String texto = String.valueOf((double)Math.round(temp * (double)10) / (double)10);
        g.drawString(texto, orgXtermo - 4 * this.cAncho, y1 - this.marca[0].height / 2 - 2);
        g.drawRect(orgXtermo, 0, this.cAncho, orgYtermo + this.cAncho);
        g.drawOval(orgXtermo - this.cAncho / 2, orgYtermo + this.cAncho, 2 * this.cAncho, 3 * this.cAncho / 2);
        for (int i = 0; i <= 100; i += 10) {
            y1 = orgYtermo - (int)((double)i * this.escTermo);
            g.drawLine(orgXtermo + this.cAncho / 2, y1, orgXtermo + 3 * this.cAncho / 2, y1);
            g.drawString(String.valueOf(i), orgXtermo + 2 * this.cAncho, y1 + this.cAlto / 4);
            if (i == 100) break;
            for (int j = 1; j < 5; ++j) {
                y1 = orgYtermo - (int)((double)(i + 2 * j) * this.escTermo);
                g.drawLine(orgXtermo + this.cAncho, y1, orgXtermo + this.cAncho / 2, y1);
            }
        }
    }

    public void paint(Graphics g) {
        this.origenEscalas(g);
        this.update(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, d.width, d.height);
        if (this.bGrafica) {
            this.grafica(this.gBuffer);
        } else {
            this.dispositivo(this.gBuffer);
        }
        g.drawImage(this.imag, 0, 0, null);
    }

    public void mousePressed(MouseEvent ev) {
        for (int i = 0; i < this.marca.length; ++i) {
            if (!this.marca[i].contains(ev.getX(), ev.getY())) continue;
            this.yMarca[i] = ev.getY();
            this.bArrastrar[i] = true;
        }
    }

    public void mouseReleased(MouseEvent ev) {
        for (int i = 0; i < this.marca.length; ++i) {
            if (this.bArrastrar[i]) {
                this.bArrastrar[i] = false;
                this.marca[i].y += ev.getY() - this.yMarca[i];
                this.T[i] = (double)(this.orgY - this.marca[i].y - this.marca[i].height / 2) / this.escTermo;
                if (this.T[i] > 100.0) {
                    this.T[i] = 100.0;
                    this.marca[i].y = this.orgY - (int)(this.T[i] * this.escTermo) - this.marca[i].height / 2;
                }
                if (this.T[i] < 0.0) {
                    this.T[i] = 0.0;
                    this.marca[i].y = this.orgY - this.marca[i].height / 2;
                }
            }
            this.yMarca[i] = ev.getY();
        }
        this.repaint();
    }

    public void mouseDragged(MouseEvent ev) {
        int y1 = this.orgY - (int)(100.0 * this.escTermo);
        for (int i = 0; i < this.marca.length; ++i) {
            if (this.bArrastrar[i] && this.marca[i].y + this.marca[i].height / 2 >= y1 && this.marca[i].y + this.marca[i].height / 2 <= this.orgY) {
                this.marca[i].y += ev.getY() - this.yMarca[i];
                this.T[i] = (double)(this.orgY - this.marca[i].y - this.marca[i].height / 2) / this.escTermo;
            }
            this.yMarca[i] = ev.getY();
        }
        this.repaint();
    }

    public void mouseClicked(MouseEvent ev) {
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseMoved(MouseEvent ev) {
    }
}

