/*
 * Decompiled with CFR 0.152.
 */
package termico9;

public class Sistema {
    double Ta;
    double Tb;
    double T0;
    static final double L = 0.5;
    double a2;
    double t;
    double[] k = new double[2];
    double cte;
    double x;
    double T;

    public Sistema(double Ta, double Tb, double T0, double a2) {
        this.Ta = Ta;
        this.Tb = Tb;
        this.T0 = T0;
        this.a2 = a2;
        this.t = 0.0;
        this.k[0] = (double)2 * ((double)2 * T0 - (Ta + Tb)) / Math.PI;
        this.k[1] = (double)2 * (Tb - Ta) / Math.PI;
        this.cte = Math.PI * Math.PI / (a2 * 0.5 * 0.5);
    }

    void setTiempo(double t) {
        this.t = t;
    }

    double evolucion(double x) {
        if (this.t < 0.1) {
            return this.T0;
        }
        double v = 0.0;
        int n = 0;
        double T = this.Ta + (this.Tb - this.Ta) * x / 0.5;
        do {
            for (int j = 0; j < 2; ++j) {
                v = Math.exp(-this.cte * (double)(++n) * (double)n * this.t);
                T += v * this.k[j] * Math.sin(Math.PI * (double)n * x / 0.5) / (double)n;
            }
        } while (v > 0.01);
        return T;
    }
}

