/*
 * Decompiled with CFR 0.152.
 */
package termico2;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import termico2.Sistema;
import termico2.TermicoApplet2;

public class MiCanvas
extends Canvas {
    TermicoApplet2 parent;
    Sistema sis;
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgX;
    int orgXX;
    int orgY;
    double escalaY;
    double dimCaja;
    boolean bActualizar = false;
    Image imag;
    Graphics gBuffer;
    Dimension dim;
    int[] xN;
    int[] yN;
    int pasos;
    int iniPasos;

    public MiCanvas(TermicoApplet2 p) {
        this.parent = p;
        this.setBackground(Color.white);
        this.xN = new int[24];
        this.yN = new int[24];
    }

    void setNuevo(double Ta, double Tb, double T0, int pasos) {
        this.sis = new Sistema(Ta, Tb, T0);
        this.pasos = pasos;
        this.iniPasos = 0;
        this.repaint();
    }

    void setManual() {
        this.bActualizar = true;
    }

    void setPasos(int pasos) {
        this.iniPasos = this.sis.t;
        this.pasos = pasos;
    }

    void origenEscalas(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgX = 4 * this.cAncho;
        this.orgXX = this.wAncho - 4 * this.cAncho;
        this.orgY = this.wAlto - 2 * this.cAlto;
        this.dimCaja = (double)(this.orgXX - this.orgX) / (double)12;
        this.escalaY = (double)(this.orgY - 2 * this.cAlto) / (double)10;
    }

    void dibujaEjes(Graphics g) {
        int y1;
        g.setColor(Color.black);
        g.drawLine(this.orgX, this.orgY, this.orgX, 0);
        for (int i = 1; i < 11; ++i) {
            y1 = this.orgY - (int)((double)i * this.escalaY);
            g.drawLine(this.orgX - 2, y1, this.orgX + 2, y1);
            String texto = String.valueOf(10 * i);
            g.drawString(texto, this.orgX - this.cAncho - g.getFontMetrics().stringWidth(texto), y1 + this.cAlto / 2);
        }
        g.drawString("T(\u00baC)", this.orgX + this.cAncho, this.cAlto);
        g.drawLine(this.orgXX, this.orgY, this.orgXX, 0);
        for (int i = 1; i < 11; ++i) {
            y1 = this.orgY - (int)((double)i * this.escalaY);
            g.drawLine(this.orgXX - 2, y1, this.orgXX + 2, y1);
            String texto = String.valueOf(10 * i);
            g.drawString(texto, this.orgXX + this.cAncho, y1 + this.cAlto / 2);
        }
        g.setColor(Color.magenta);
        g.fillRect(this.orgX, this.orgY, (int)this.dimCaja, 2 * this.cAlto);
        g.fillRect(this.orgXX - (int)this.dimCaja, this.orgY, (int)this.dimCaja, 2 * this.cAlto);
        g.setColor(Color.black);
        g.drawRect(this.orgX, this.orgY, (int)this.dimCaja, 2 * this.cAlto);
        g.drawRect(this.orgXX - (int)this.dimCaja, this.orgY, (int)this.dimCaja, 2 * this.cAlto);
        g.setColor(Color.gray);
        if (this.sis != null) {
            for (int i = 1; i < 11; ++i) {
                this.dibujaCaja(g, i);
            }
        } else {
            g.fillRect(this.orgX + (int)this.dimCaja, this.orgY, this.orgXX - this.orgX - (int)((double)2 * this.dimCaja), 2 * this.cAlto);
        }
    }

    void dibujaCaja(Graphics g, int iCaja) {
        g.setColor(Color.black);
        g.drawRect(this.orgX + (int)((double)iCaja * this.dimCaja), this.orgY, (int)this.dimCaja, 2 * this.cAlto);
        g.setColor(Color.magenta);
        for (int i = 0; i < 100; ++i) {
            int x1 = this.orgX + (int)((double)iCaja * this.dimCaja) + 1 + (int)(Math.random() * (this.dimCaja - (double)2));
            int y1 = this.orgY + 1 + (int)(Math.random() * (double)(2 * this.cAlto - 2));
            g.fillRect(x1, y1, 1, 1);
        }
    }

    void dibujaGrafico(Graphics g) {
        int k = 0;
        int j = 0;
        this.xN[k] = this.orgX;
        this.yN[k] = this.orgY - (int)(this.sis.Told[0] * this.escalaY / (double)10);
        for (j = 1; j <= 11; ++j) {
            this.xN[++k] = this.orgX + (int)((double)j * this.dimCaja);
            this.yN[k] = this.orgY - (int)(this.sis.Told[j - 1] * this.escalaY / (double)10);
            this.xN[++k] = this.orgX + (int)((double)j * this.dimCaja);
            this.yN[k] = this.orgY - (int)(this.sis.Told[j] * this.escalaY / (double)10);
        }
        j = 11;
        this.xN[++k] = this.orgX + (int)((double)(j + 1) * this.dimCaja);
        this.yN[k] = this.orgY - (int)(this.sis.Told[j] * this.escalaY / (double)10);
        g.setColor(Color.blue);
        g.drawPolyline(this.xN, this.yN, k + 1);
        k = 0;
        this.xN[k] = this.orgX;
        this.yN[k] = this.orgY - (int)(this.sis.T[0] * this.escalaY / (double)10);
        for (j = 1; j <= 11; ++j) {
            this.xN[++k] = this.orgX + (int)((double)j * this.dimCaja);
            this.yN[k] = this.orgY - (int)(this.sis.T[j - 1] * this.escalaY / (double)10);
            this.xN[++k] = this.orgX + (int)((double)j * this.dimCaja);
            this.yN[k] = this.orgY - (int)(this.sis.T[j] * this.escalaY / (double)10);
        }
        j = 11;
        this.xN[++k] = this.orgX + (int)((double)(j + 1) * this.dimCaja);
        this.yN[k] = this.orgY - (int)(this.sis.T[j] * this.escalaY / (double)10);
        g.setColor(Color.red);
        g.drawPolyline(this.xN, this.yN, k + 1);
        g.setColor(Color.black);
        String texto = String.valueOf("pasos: ").concat(String.valueOf(this.sis.t));
        g.drawString(texto, this.orgXX - g.getFontMetrics().stringWidth(texto) - this.cAncho, this.cAlto);
        g.setColor(Color.red);
        g.fillRect(this.orgX + 10 * this.cAncho, 1, 2 * this.cAncho, this.cAlto);
        g.setColor(Color.black);
        g.drawString("actual", this.orgX + 13 * this.cAncho, this.cAlto);
        g.setColor(Color.blue);
        g.fillRect(this.orgX + 18 * this.cAncho, 1, 2 * this.cAncho, this.cAlto);
        g.setColor(Color.black);
        g.drawString("anterior", this.orgX + 21 * this.cAncho, this.cAlto);
    }

    void mover() {
        if (this.parent.chkManual.getState() && (this.sis.t - this.iniPasos) % this.pasos == 0) {
            this.bActualizar = true;
        }
        if (this.bActualizar) {
            this.sis.actualizacion();
            this.sis.distribucion();
            this.bActualizar = false;
        }
        this.sis.evolucion(100);
        this.repaint();
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, d.width, d.height);
        this.gBuffer.setColor(Color.black);
        this.dibujaEjes(this.gBuffer);
        if (this.sis != null) {
            this.dibujaGrafico(this.gBuffer);
        }
        g.drawImage(this.imag, 0, 0, null);
    }

    public void paint(Graphics g) {
        if (this.sis == null) {
            this.origenEscalas(g);
            this.dibujaEjes(g);
        }
    }
}

