/*
 * Decompiled with CFR 0.152.
 */
package termico2;

public class Sistema {
    double Ta;
    double Tb;
    double T0;
    static final int nCajas = 10;
    static final int N = 100;
    private double[][] E;
    double[] T;
    double[] Told;
    int t = 0;

    public Sistema(double Ta, double Tb, double T0) {
        this.Ta = Ta;
        this.Tb = Tb;
        this.T0 = T0;
        this.E = new double[12][100];
        this.T = new double[12];
        this.Told = new double[12];
        this.T[0] = this.Told[0] = Ta;
        this.T[11] = this.Told[11] = Tb;
        for (int i = 1; i < 11; ++i) {
            this.T[i] = this.Told[i] = T0;
        }
        for (int i = 0; i < 12; ++i) {
            for (int j = 0; j < 100; ++j) {
                this.E[i][j] = this.T[i];
            }
        }
    }

    void evolucion(int dt) {
        int c1 = 0;
        boolean c2 = false;
        ++this.t;
        for (int k = 0; k < dt; ++k) {
            c1 = (int)((double)11 * Math.random());
            int i1 = (int)((double)100 * Math.random());
            int i2 = (int)((double)100 * Math.random());
            double E1 = this.E[c1][i1];
            double E2 = this.E[c1 + 1][i2];
            double F1 = (E1 + E2) * Math.random();
            double F2 = E1 + E2 - F1;
            this.E[c1][i1] = F1;
            this.E[c1 + 1][i2] = F2;
            if (c1 == 0) {
                this.E[c1][i1] = E1;
            }
            if (c1 != 10) continue;
            this.E[c1 + 1][i2] = E2;
        }
    }

    void distribucion() {
        for (int i = 1; i < 11; ++i) {
            double Et = 0.0;
            for (int j = 0; j < 100; ++j) {
                Et += this.E[i][j] / (double)100;
            }
            this.T[i] = Et;
        }
    }

    void actualizacion() {
        for (int i = 1; i < 11; ++i) {
            this.Told[i] = this.T[i];
        }
    }
}

