/*
 * Decompiled with CFR 0.152.
 */
package difusion5;

import difusion5.DifusionApplet5;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;

public class MiCanvas
extends Canvas {
    DifusionApplet5 parent;
    int cAncho;
    int cAlto;
    int wAncho;
    int wAlto;
    int orgX;
    int orgY;
    double escala;
    final double[] coefDifusion = new double[]{0.101, 0.091, 0.079};
    final double[] densidad = new double[]{0.792, 0.7135, 1.595};
    final double[][] presion = new double[][]{{115.6, 147.1, 184.8, 229.2, 282.7}, {291.7, 360.7, 442.2, 537.0, 647.3}, {53.1, 68.7, 86.5, 109.0, 137.0}};
    final double[] pMolecular = new double[]{58.1, 74.12, 153.8};
    double cte;
    int iLiquido = 0;
    int iTemperatura = 0;
    double y = 0.0;
    double t = 0.0;
    double dt = 10.0;
    int nMinutos = 1;
    Polygon pol = new Polygon();
    boolean bParar = false;
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas(DifusionApplet5 p) {
        this.parent = p;
        this.setBackground(Color.white);
    }

    void origenEscalas(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgY = this.cAlto;
        this.escala = (double)(this.wAlto - this.cAlto - this.cAncho) / 1.5;
        this.orgX = 4 * this.cAncho;
    }

    void setNuevo(int iLiquido, int iTemperatura) {
        this.iLiquido = iLiquido;
        this.iTemperatura = iTemperatura;
        double cVapor = 1.604E-5 * this.pMolecular[iLiquido] * this.presion[iLiquido][iTemperatura] / (double)(10 + iTemperatura * 5 + 273);
        this.cte = Math.sqrt((double)2 * this.coefDifusion[iLiquido] * cVapor / this.densidad[iLiquido]);
        this.pol.npoints = 0;
        this.y = 0.0;
        this.t = 0.0;
        this.nMinutos = 1;
        this.bParar = false;
        this.repaint();
    }

    void mover() {
        this.y = this.cte * Math.sqrt(this.t);
        this.t += this.dt;
        if (this.y > 1.4 || this.t > (double)13500) {
            this.bParar = true;
            this.parent.hilo.putMsg(0);
        }
        this.repaint();
    }

    void dispositivo(Graphics g) {
        String texto;
        g.setColor(Color.black);
        g.drawLine(this.orgX, this.cAlto, this.orgX, this.wAlto);
        g.drawLine(this.orgX - 1, this.cAlto, this.orgX - 1, this.wAlto);
        int ancho = (int)(this.escala * 0.2);
        g.drawLine(this.orgX + ancho, this.cAlto, this.orgX + ancho, this.wAlto);
        g.drawLine(this.orgX + ancho + 1, this.cAlto, this.orgX + ancho + 1, this.wAlto);
        g.setColor(Color.red);
        int y1 = this.orgY + (int)(this.y * this.escala);
        g.fillRect(this.orgX + 1, y1, ancho - 1, this.wAlto - y1);
        int i = 0;
        while ((double)i < (double)100 * this.y) {
            y1 = this.orgY + (int)(this.escala * this.y * Math.sqrt(Math.random()));
            int x1 = this.orgX + (int)((double)(ancho - 3) * Math.random()) + 2;
            g.fillOval(x1 - 2, y1 - 2, 4, 4);
            ++i;
        }
        g.setColor(Color.black);
        for (int i2 = 0; i2 <= 15; ++i2) {
            y1 = this.orgY + (int)(this.escala * (double)i2 / (double)10);
            g.drawLine(this.orgX, y1, this.orgX - this.cAncho, y1);
            texto = String.valueOf((double)Math.round((double)i2 / (double)10 * (double)10) / (double)10);
            g.drawString(texto, this.orgX - this.cAncho - g.getFontMetrics().stringWidth(texto), y1 + this.cAlto / 4);
            if (i2 == 15) break;
            for (int j = 1; j < 5; ++j) {
                y1 = this.orgY + (int)(this.escala * ((double)i2 + (double)j / (double)5) / (double)10);
                g.drawLine(this.orgX, y1, this.orgX - this.cAncho / 2, y1);
            }
        }
        g.setColor(Color.black);
        Font oldFont = g.getFont();
        Font fuente = new Font("Times", 1, 14);
        g.setFont(fuente);
        texto = String.valueOf((double)Math.round(this.t / (double)6) / (double)10);
        g.drawString(String.valueOf("tiempo(min):").concat(String.valueOf(texto)), this.wAncho / 2 - 10 * this.cAncho, g.getFontMetrics().getHeight() + this.cAlto / 2);
        g.setFont(oldFont);
        this.grafica(g);
    }

    public void paint(Graphics g) {
        this.origenEscalas(g);
        this.dispositivo(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, d.width, d.height);
        this.dispositivo(this.gBuffer);
        g.drawImage(this.imag, 0, 0, null);
    }

    void grafica(Graphics g) {
        block4: {
            int y1;
            String texto;
            int x1;
            int orgXX = this.orgX + (int)(this.escala * 0.2) + 5 * this.cAncho;
            int orgYY = this.wAlto - 2 * this.cAlto;
            double escalaX = (double)(this.wAncho - orgXX - 3 * this.cAncho) / (double)15;
            double escalaY = (double)(this.wAlto - 3 * this.cAlto) / 1.5;
            g.setColor(Color.black);
            g.drawLine(orgXX - this.cAncho, orgYY, this.wAncho, orgYY);
            g.drawString("sqrt(t)", this.wAncho - 6 * this.cAncho, orgYY - 2);
            for (int i = 0; i <= 15; ++i) {
                x1 = orgXX + (int)((double)i * escalaX);
                g.drawLine(x1, orgYY, x1, orgYY + this.cAncho);
                texto = String.valueOf(i);
                g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, orgYY + this.cAlto + this.cAncho);
            }
            g.drawLine(orgXX, 0, orgXX, this.wAlto - this.cAlto);
            g.drawString("h(cm)", orgXX + this.cAncho, this.cAlto);
            for (int i = 0; i <= 15; ++i) {
                y1 = orgYY - (int)(this.escala * (double)i / (double)10);
                g.drawLine(orgXX, y1, orgXX - this.cAncho, y1);
                texto = String.valueOf((double)Math.round((double)i / (double)10 * (double)10) / (double)10);
                g.drawString(texto, orgXX - this.cAncho - g.getFontMetrics().stringWidth(texto), y1 + this.cAlto / 4);
            }
            if (this.t / 60.0 % (double)(this.nMinutos * this.nMinutos) < this.dt / (double)60) {
                x1 = orgXX + (int)(Math.sqrt(this.t / (double)60) * escalaX);
                y1 = orgYY - (int)(this.y * escalaY);
                this.pol.addPoint(x1, y1);
                ++this.nMinutos;
            }
            g.setColor(Color.blue);
            for (int i = 0; i < this.pol.npoints; ++i) {
                g.fillOval(this.pol.xpoints[i] - 2, this.pol.ypoints[i] - 2, 4, 4);
            }
            g.setColor(Color.blue);
            if (!this.bParar) break block4;
            g.drawLine(orgXX, orgYY, this.pol.xpoints[this.pol.npoints - 1], this.pol.ypoints[this.pol.npoints - 1]);
            double pendiente = this.y / Math.sqrt(this.t / (double)60);
            texto = String.valueOf((double)Math.round(pendiente * (double)10000) / (double)10000);
            g.setColor(Color.black);
            g.drawString(String.valueOf("pendiente: ").concat(String.valueOf(texto)), this.wAncho - 15 * this.cAncho, this.cAlto);
        }
    }
}

