/*
 * Decompiled with CFR 0.152.
 */
package termico8;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import termico8.TermicoApplet8;

public class MiCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    TermicoApplet8 parent;
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgY;
    int orgX;
    int orgYTermometro;
    double escalaX;
    double escalaY;
    double escTermo;
    double t = 0.5;
    final double dt = 15.0;
    double a2 = 35300.0;
    double T0 = 25.0;
    double Ts = 90.0;
    double Tc = this.T0;
    double radio = 0.03;
    double alfa = 1.5E-7;
    Polygon pol = new Polygon();
    boolean bGrafica = false;
    boolean bInicio = true;
    boolean bArrastrarIzq = false;
    Rectangle marcaIzq = new Rectangle();
    int yMarcaIzq;
    boolean bArrastrarDcha = false;
    Rectangle marcaDcha = new Rectangle();
    int yMarcaDcha;
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas(TermicoApplet8 p) {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.marcaIzq.setSize(16, 8);
        this.marcaDcha.setSize(16, 8);
        this.parent = p;
        this.setBackground(Color.white);
    }

    void origen(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgX = 4 * this.cAncho;
        this.orgY = this.wAlto - this.cAlto - this.cAncho;
        this.orgYTermometro = this.wAlto - 3 * this.cAlto;
        this.escalaX = (double)(this.wAncho - this.orgX - this.cAncho) / 100.0;
        this.escalaY = (double)(this.orgY - this.cAncho) / 100.0;
        this.escTermo = (double)(this.orgYTermometro - this.cAlto) / 100.0;
        this.marcaInicial();
    }

    void inicio() {
        this.bGrafica = false;
        this.bInicio = true;
        this.t = 0.0;
        this.pol.npoints = 0;
        this.repaint();
    }

    void setNuevo(double r, double a, boolean bGrafica) {
        this.radio = r / (double)100;
        this.alfa = a * 1.0E-7;
        this.bGrafica = bGrafica;
        this.bInicio = false;
        this.t = 15.0;
        this.pol.npoints = 0;
        this.Tc = this.T0;
        int y1 = this.orgY - (int)(this.Tc * this.escalaY);
        this.pol.addPoint(this.orgX, y1);
        this.bArrastrarIzq = false;
        this.bArrastrarDcha = false;
        this.marcaInicial();
        bGrafica = true;
        this.repaint();
    }

    void marcaInicial() {
        int y1 = this.orgY - this.cAlto - this.cAncho - (int)(this.escTermo * this.Ts) - this.marcaIzq.height / 2;
        this.marcaIzq.setLocation(this.wAncho - 6 * this.cAlto - this.cAncho - this.marcaIzq.width, y1);
        y1 = this.orgY - this.cAlto - this.cAncho - (int)(this.escTermo * this.T0) - this.marcaDcha.height / 2;
        this.marcaDcha.setLocation(9 * this.cAlto - this.cAncho - this.marcaDcha.width, y1);
    }

    void antes(Graphics g) {
        g.setColor(Color.gray);
        g.fillOval(6 * this.cAlto, this.wAlto - 6 * this.cAlto, 6 * this.cAlto, 6 * this.cAlto);
        this.termometro(g, 9 * this.cAlto, this.orgYTermometro, this.T0);
        g.setColor(Color.black);
        g.fillRect(this.wAncho - 10 * this.cAlto, this.wAlto - 10 * this.cAlto, 2, 10 * this.cAlto);
        g.fillRect(this.wAncho - this.cAlto, this.wAlto - 10 * this.cAlto, 2, 10 * this.cAlto);
        g.fillRect(this.wAncho - 10 * this.cAlto, this.wAlto - 2, 9 * this.cAlto, 2);
        g.setColor(Color.cyan);
        g.fillRect(this.wAncho - 10 * this.cAlto + 2, this.wAlto - 8 * this.cAlto, 9 * this.cAlto - 2, 8 * this.cAlto - 2);
        this.termometro(g, this.wAncho - 6 * this.cAlto, this.orgYTermometro, this.Ts);
        g.drawImage(this.parent.marca, this.marcaIzq.x, this.marcaIzq.y, this);
        g.drawImage(this.parent.marca, this.marcaDcha.x, this.marcaDcha.y, this);
    }

    void despues(Graphics g) {
        g.setColor(Color.cyan);
        g.fillRect(0, 0, this.wAncho, this.wAlto);
        g.setColor(Color.gray);
        int r = (int)(this.radio * (double)(this.wAlto / 2 - 2 * this.cAlto) / 0.1);
        g.fillOval(this.wAncho / 4 - r, this.wAlto / 2 - r, 2 * r, 2 * r);
        this.termometro_H(g, this.wAncho / 4 + 2 * this.cAncho, this.wAlto / 2, this.Tc);
        this.termometro_H(g, this.wAncho / 4 + 2 * this.cAncho, this.cAlto + this.cAncho, this.Ts);
        g.setColor(Color.black);
        Font oldFont = g.getFont();
        Font fuente = new Font("Times", 1, 14);
        g.setFont(fuente);
        String texto = String.valueOf((double)Math.round(this.t * (double)10 / (double)60) / (double)10);
        g.drawString(String.valueOf("t(min): ").concat(String.valueOf(texto)), this.cAncho, g.getFontMetrics().getHeight());
        g.setFont(oldFont);
    }

    void grafica(Graphics g) {
        int y1;
        String str;
        int x1;
        g.setColor(Color.black);
        g.drawLine(0, this.orgY, this.wAncho, this.orgY);
        g.drawString("t(min)", this.wAncho - 5 * this.cAncho, this.orgY - 2);
        for (int i = 0; i < 100; i += 10) {
            x1 = this.orgX + (int)((double)i * this.escalaX);
            g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho);
            str = String.valueOf(i);
            g.drawString(str, x1 - g.getFontMetrics().stringWidth(str) / 2, this.orgY + this.cAlto + this.cAncho);
            for (int j = 1; j < 5; ++j) {
                x1 = this.orgX + (int)((double)(i + 2 * j) * this.escalaX);
                g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho / 2);
            }
        }
        g.drawLine(this.orgX, 0, this.orgX, this.orgY);
        g.drawString("T", this.orgX + this.cAncho, this.cAlto);
        for (int i = 0; i <= 100; i += 10) {
            y1 = this.orgY - (int)((double)i * this.escalaY);
            g.drawLine(this.orgX, y1, this.orgX - this.cAncho, y1);
            str = String.valueOf(i);
            g.drawString(str, this.orgX - this.cAncho - g.getFontMetrics().stringWidth(str), y1 + this.cAlto / 2);
            for (int j = 1; j < 5; ++j) {
                y1 = this.orgY - (int)((double)(i + 2 * j) * this.escalaY);
                g.drawLine(this.orgX, y1, this.orgX - this.cAncho / 2, y1);
            }
        }
        y1 = this.orgY - (int)(this.Tc * this.escalaY);
        x1 = this.orgX + (int)(this.t * this.escalaX / (double)60);
        this.pol.addPoint(x1, y1);
        g.setColor(Color.red);
        g.drawPolyline(this.pol.xpoints, this.pol.ypoints, this.pol.npoints);
        g.fillOval(x1 - 2, y1 - 2, 4, 4);
        do {
            g.drawLine(x1, y1, x1, y1 + this.cAncho / 2);
        } while ((y1 += this.cAncho) < this.orgY);
        y1 = this.orgY - (int)(this.Tc * this.escalaY);
        do {
            g.drawLine(x1, y1, x1 - this.cAncho / 2, y1);
        } while ((x1 -= this.cAncho) > this.orgX);
        x1 = this.orgX + (int)(this.t * this.escalaX / (double)60);
        g.setColor(Color.black);
        str = String.valueOf((double)Math.round(this.t * (double)10 / (double)60) / (double)10);
        g.drawString(str, x1 + 2, this.orgY - 2);
        str = String.valueOf((double)Math.round(this.Tc * (double)10) / (double)10);
        g.drawString(str, this.orgX + 2, y1 - 2);
    }

    void mover() {
        double temp = 0.0;
        for (int i = 1; i < 100; ++i) {
            int sgn = (i + 1) % 2 == 0 ? 1 : -1;
            temp += (double)sgn * Math.exp((double)(-i * i) * Math.PI * Math.PI * this.t * this.alfa / (this.radio * this.radio));
        }
        this.Tc = this.Ts + (double)2 * (this.T0 - this.Ts) * temp;
        this.t += 15.0;
        this.repaint();
    }

    void termometro(Graphics g, int orgXtermo, int orgYtermo, double temp) {
        int y1 = orgYtermo - (int)(temp * this.escTermo);
        g.setColor(this.getBackground());
        g.fillRect(orgXtermo, 0, this.cAncho, orgYtermo + this.cAncho);
        g.setColor(Color.red);
        g.fillRect(orgXtermo, y1, this.cAncho, orgYtermo - y1 + this.cAncho);
        g.fillOval(orgXtermo - this.cAncho / 2, orgYtermo + this.cAncho, 2 * this.cAncho, 3 * this.cAncho / 2);
        g.setColor(Color.black);
        String texto = String.valueOf((double)Math.round(temp * (double)10) / (double)10);
        g.drawString(texto, orgXtermo - 4 * this.cAncho, y1 - 2);
        g.drawRect(orgXtermo, 0, this.cAncho, orgYtermo + this.cAncho);
        g.drawOval(orgXtermo - this.cAncho / 2, orgYtermo + this.cAncho, 2 * this.cAncho, 3 * this.cAncho / 2);
        for (int i = 0; i <= 100; i += 10) {
            y1 = orgYtermo - (int)((double)i * this.escTermo);
            g.drawLine(orgXtermo + this.cAncho / 2, y1, orgXtermo + 3 * this.cAncho / 2, y1);
            g.drawString(String.valueOf(i), orgXtermo + 2 * this.cAncho, y1 + this.cAlto / 4);
            if (i == 100) break;
            for (int j = 1; j < 5; ++j) {
                y1 = orgYtermo - (int)((double)(i + 2 * j) * this.escTermo);
                g.drawLine(orgXtermo + this.cAncho, y1, orgXtermo + this.cAncho / 2, y1);
            }
        }
    }

    void termometro_H(Graphics g, int orgXtermo, int orgYtermo, double temp) {
        int x1 = orgXtermo + (int)(temp * this.escTermo);
        g.setColor(Color.red);
        g.fillRect(orgXtermo - this.cAncho, orgYtermo - this.cAncho, x1 - orgXtermo + this.cAncho, this.cAncho);
        g.fillOval(orgXtermo - 3 * this.cAncho, orgYtermo - 3 * this.cAncho / 2, 2 * this.cAncho, 2 * this.cAncho);
        g.setColor(Color.black);
        String texto = String.valueOf((double)Math.round(temp * (double)10) / (double)10);
        g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, orgYtermo - this.cAncho - 2);
        x1 = (int)((double)100 * this.escTermo) + this.cAlto;
        g.drawRect(orgXtermo - this.cAncho, orgYtermo - this.cAncho, x1 + this.cAncho + this.cAlto, this.cAncho);
        g.drawOval(orgXtermo - 3 * this.cAncho, orgYtermo - 3 * this.cAncho / 2, 2 * this.cAncho, 2 * this.cAncho);
        for (int i = 0; i <= 100; i += 10) {
            x1 = orgXtermo + (int)((double)i * this.escTermo);
            g.drawLine(x1, orgYtermo, x1, orgYtermo + this.cAncho);
            texto = String.valueOf(i);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, orgYtermo + this.cAncho + this.cAlto);
            if (i == 100) break;
            for (int j = 1; j < 5; ++j) {
                x1 = orgXtermo + (int)((double)(i + 2 * j) * this.escTermo);
                g.drawLine(x1, orgYtermo, x1, orgYtermo + this.cAncho / 2);
            }
        }
    }

    public void paint(Graphics g) {
        this.origen(g);
        this.update(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, d.width, d.height);
        if (this.bInicio) {
            this.antes(this.gBuffer);
        } else if (this.bGrafica) {
            this.grafica(this.gBuffer);
        } else {
            this.despues(this.gBuffer);
        }
        g.drawImage(this.imag, 0, 0, null);
    }

    public void mousePressed(MouseEvent ev) {
        if (this.marcaIzq.contains(ev.getX(), ev.getY())) {
            this.yMarcaIzq = ev.getY();
            this.bArrastrarIzq = true;
        }
        if (this.marcaDcha.contains(ev.getX(), ev.getY())) {
            this.yMarcaDcha = ev.getY();
            this.bArrastrarDcha = true;
        }
    }

    public void mouseReleased(MouseEvent ev) {
        if (this.bArrastrarIzq) {
            this.bArrastrarIzq = false;
            this.marcaIzq.y += ev.getY() - this.yMarcaIzq;
            this.Ts = (double)(this.orgYTermometro - this.marcaIzq.y - this.marcaIzq.height / 2) / this.escTermo;
            if (this.Ts > 100.0) {
                this.Ts = 100.0;
                this.marcaIzq.y = this.orgYTermometro - (int)(this.Ts * this.escTermo) - this.marcaIzq.height / 2;
            }
            if (this.Ts < 0.0) {
                this.Ts = 0.0;
                this.marcaIzq.y = this.orgYTermometro - this.marcaIzq.height / 2;
            }
        }
        this.yMarcaIzq = ev.getY();
        if (this.bArrastrarDcha) {
            this.bArrastrarDcha = false;
            this.marcaDcha.y += ev.getY() - this.yMarcaDcha;
            this.T0 = (double)(this.orgYTermometro - this.marcaDcha.y - this.marcaDcha.height / 2) / this.escTermo;
            if (this.T0 > 100.0) {
                this.T0 = 100.0;
                this.marcaDcha.y = this.orgYTermometro - (int)(this.T0 * this.escTermo) - this.marcaDcha.height / 2;
            }
            if (this.T0 < 0.0) {
                this.T0 = 0.0;
                this.marcaDcha.y = this.orgYTermometro - this.marcaDcha.height / 2;
            }
        }
        this.yMarcaDcha = ev.getY();
        this.repaint();
    }

    public void mouseDragged(MouseEvent ev) {
        int y1 = this.orgYTermometro - (int)(100.0 * this.escTermo);
        if (this.bArrastrarIzq && this.marcaIzq.y + this.marcaIzq.height / 2 >= y1 && this.marcaIzq.y + this.marcaIzq.height / 2 <= this.orgYTermometro) {
            this.marcaIzq.y += ev.getY() - this.yMarcaIzq;
            this.Ts = (double)(this.orgYTermometro - this.marcaIzq.y - this.marcaIzq.height / 2) / this.escTermo;
        }
        this.yMarcaIzq = ev.getY();
        if (this.bArrastrarDcha && this.marcaDcha.y + this.marcaDcha.height / 2 >= y1 && this.marcaDcha.y + this.marcaDcha.height / 2 <= this.orgYTermometro) {
            this.marcaDcha.y += ev.getY() - this.yMarcaDcha;
            this.T0 = (double)(this.orgYTermometro - this.marcaDcha.y - this.marcaDcha.height / 2) / this.escTermo;
        }
        this.yMarcaDcha = ev.getY();
        this.repaint();
    }

    public void mouseClicked(MouseEvent ev) {
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseMoved(MouseEvent ev) {
    }
}

