/*
 * Decompiled with CFR 0.152.
 */
package termico4;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;
import termico4.Burbuja;
import termico4.TermicoApplet4;

public class MiCanvas
extends Canvas {
    TermicoApplet4 parent;
    int cAncho;
    int cAlto;
    int wAncho;
    int wAlto;
    int orgX;
    int orgY;
    double escala;
    double escTermo;
    double escLiquido;
    final double[] densidad = new double[]{0.791, 0.79, 0.879, 0.7135};
    final double[] tempEbullicion = new double[]{56.2, 78.3, 80.2, 34.6};
    final double[] cLatente = new double[]{524.0, 846.0, 396.0, 351.0};
    final double[] conductividad = new double[]{209.3, 45.0, 389.6, 85.5, 418.7, 34.6};
    int iLiquido = 0;
    int longitud = 14;
    int seccion = 16;
    int iMetal = 0;
    double volumen;
    double t = 0.0;
    double dt = 5.0;
    Vector burbujas1 = new Vector(10, 5);
    Vector burbujas2 = new Vector(10, 5);
    int contador = 0;
    Image imag;
    Graphics gBuffer;
    Dimension dim;

    public MiCanvas(TermicoApplet4 p) {
        this.parent = p;
        this.setBackground(Color.white);
    }

    void origenEscalas(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgY = this.wAlto - 4 * this.cAlto;
        this.escala = (double)(this.wAlto - 8 * this.cAlto) / (double)20;
        this.orgX = this.wAncho / 3;
        this.escTermo = (double)(15 * this.cAlto) / 100.0;
        this.escLiquido = (double)(2 * this.wAlto / 3 - this.cAncho) / 1.0;
    }

    void setNuevo(int iLiquido, int longitud, int seccion, int iMetal) {
        this.iLiquido = iLiquido;
        this.longitud = longitud;
        this.seccion = seccion;
        this.iMetal = iMetal;
        this.t = 0.0;
        this.burbujas1.removeAllElements();
        this.burbujas2.removeAllElements();
        this.contador = 0;
        this.repaint();
    }

    void mover() {
        this.volumen = (double)1000 * this.conductividad[this.iMetal] * (double)this.seccion * 1.0E-4 * this.t * (100.0 - this.tempEbullicion[this.iLiquido]) / (this.cLatente[this.iLiquido] * (double)1000 * this.densidad[this.iLiquido] * (double)1000 * (double)this.longitud / (double)100);
        if (this.volumen >= 0.99) {
            this.parent.hilo.putMsg(0);
        }
        this.t += this.dt;
        ++this.contador;
        this.repaint();
    }

    void dispositivo(Graphics g) {
        Burbuja burbuja;
        int x1 = (int)(this.escala * Math.sqrt((double)this.seccion / Math.PI));
        int y1 = (int)(this.escala * (double)this.longitud);
        g.setColor(Color.black);
        g.fillRect(this.orgX - this.cAncho / 2, this.orgY - y1, x1 + this.cAncho, y1);
        g.setColor(Color.lightGray);
        g.fillRect(this.orgX, this.orgY - y1, x1, y1);
        int x2 = (int)(this.escala * Math.sqrt(7.957747154594767));
        g.setColor(Color.blue);
        g.fillRect(this.orgX - this.cAlto - (x2 - x1) / 2, this.orgY + this.cAlto, x2 + 2 * this.cAlto, 3 * this.cAlto);
        g.setColor(Color.black);
        g.drawRect(this.orgX - this.cAlto - (x2 - x1) / 2, this.orgY, x2 + 2 * this.cAlto, 4 * this.cAlto);
        g.drawRect(this.orgX - this.cAlto - 1 - (x2 - x1) / 2, this.orgY + 1, x2 + 2 * this.cAlto + 2, 4 * this.cAlto - 2);
        g.setColor(Color.cyan);
        g.fillRect(this.orgX - this.cAlto - (x2 - x1) / 2, this.orgY - y1 - 3 * this.cAlto, x2 + 2 * this.cAlto, 3 * this.cAlto);
        g.setColor(Color.black);
        g.drawRect(this.orgX - this.cAlto - (x2 - x1) / 2, this.orgY - y1 - 4 * this.cAlto, x2 + 2 * this.cAlto, 4 * this.cAlto);
        g.drawRect(this.orgX - this.cAlto - 1 - (x2 - x1) / 2, this.orgY - y1 - 4 * this.cAlto + 1, x2 + 2 * this.cAlto + 2, 4 * this.cAlto - 2);
        g.setColor(this.getBackground());
        int x3 = this.orgX - this.cAlto - (x2 - x1) / 2;
        int y3 = this.orgY - y1 - 4 * this.cAlto;
        g.fillRect(x3 - 1, y3, 2, this.cAncho);
        g.setColor(Color.black);
        int orgXliq = 5 * this.cAncho;
        int orgYliq = this.wAlto - this.cAncho;
        g.drawRect(orgXliq, this.wAlto / 3, 4 * this.cAlto, orgYliq - this.wAlto / 3);
        g.setColor(this.getBackground());
        g.drawLine(orgXliq + 2 * this.cAlto - this.cAncho / 2, this.wAlto / 3, orgXliq + 2 * this.cAlto + this.cAncho / 2, this.wAlto / 3);
        g.setColor(Color.black);
        g.drawLine(orgXliq + 2 * this.cAlto - this.cAncho / 2, this.wAlto / 3, orgXliq + 2 * this.cAlto - this.cAncho / 2, this.wAlto / 3 - 2 * this.cAlto);
        g.drawLine(orgXliq + 2 * this.cAlto + this.cAncho / 2, this.wAlto / 3, orgXliq + 2 * this.cAlto + this.cAncho / 2, this.wAlto / 3 - 2 * this.cAlto + this.cAncho);
        g.drawLine(orgXliq + 2 * this.cAlto - this.cAncho / 2, this.wAlto / 3 - 2 * this.cAlto, x3, y3);
        g.drawLine(orgXliq + 2 * this.cAlto + this.cAncho / 2, this.wAlto / 3 - 2 * this.cAlto + this.cAncho, x3, y3 + this.cAncho);
        int y2 = (int)(this.escLiquido * this.volumen);
        g.drawString("litros", orgXliq - 4 * this.cAncho, this.wAlto / 3 - this.cAlto);
        g.setColor(Color.cyan);
        g.fillRect(orgXliq + 1, orgYliq - y2, 4 * this.cAlto - 2, y2);
        if (this.contador % 16 == 0) {
            x3 = this.orgX - this.cAlto - (x2 - x1) / 2 + this.cAncho + (int)((double)(2 * this.cAlto + x2 - 2 * this.cAncho) * Math.random());
            this.burbujas1.addElement(new Burbuja(x3, this.wAlto - this.cAncho, this.cAncho, this.getBackground(), 1));
            x3 = this.orgX - this.cAlto - (x2 - x1) / 2 + this.cAncho + (int)((double)(2 * this.cAlto + x2 - 2 * this.cAncho) * Math.random());
            this.burbujas2.addElement(new Burbuja(x3, this.orgY - y1 - this.cAncho, this.cAncho, this.getBackground(), 1));
        }
        for (int i = 0; i < this.burbujas1.size(); ++i) {
            burbuja = (Burbuja)this.burbujas1.elementAt(i);
            if (burbuja.y1 < this.wAlto - 3 * this.cAlto) {
                this.burbujas1.removeElementAt(i);
                continue;
            }
            burbuja.dibujaBurbuja(g);
        }
        for (int i = 0; i < this.burbujas2.size(); ++i) {
            burbuja = (Burbuja)this.burbujas2.elementAt(i);
            if (burbuja.y1 < this.orgY - y1 - 3 * this.cAlto) {
                this.burbujas2.removeElementAt(i);
                continue;
            }
            burbuja.dibujaBurbuja(g);
        }
        this.termometro(g, this.orgX + x1 + this.cAncho, this.orgY + this.cAncho / 2, 100.0);
        this.termometro(g, this.orgX + x1 + this.cAncho, this.orgY - y1 + this.cAncho / 2, this.tempEbullicion[this.iLiquido]);
        this.termometro(g, this.orgX + x1 + this.cAncho, this.orgY - y1 / 2, (100.0 + this.tempEbullicion[this.iLiquido]) / (double)2);
        g.setColor(Color.black);
        String texto = String.valueOf((double)Math.round(this.volumen * (double)1000) / (double)1000);
        g.drawString(texto, orgXliq + 4 * this.cAlto + this.cAncho, orgYliq - y2 + this.cAlto / 2);
        for (int i = 0; i <= 10; ++i) {
            y1 = orgYliq - (int)(this.escLiquido * (double)i / (double)10);
            g.drawLine(orgXliq, y1, orgXliq - this.cAncho, y1);
            texto = String.valueOf((double)Math.round((double)i / (double)10 * (double)10) / (double)10);
            g.drawString(texto, orgXliq - this.cAncho - g.getFontMetrics().stringWidth(texto), y1 + this.cAlto / 4);
            if (i == 10) break;
            for (int j = 1; j < 5; ++j) {
                y1 = orgYliq - (int)(this.escLiquido * ((double)i + (double)j / (double)5) / (double)10);
                g.drawLine(orgXliq, y1, orgXliq - this.cAncho / 2, y1);
            }
        }
        g.setColor(Color.black);
        Font oldFont = g.getFont();
        Font fuente = new Font("Times", 1, 14);
        g.setFont(fuente);
        texto = String.valueOf("tiempo (min): ").concat(String.valueOf(String.valueOf((double)Math.round(this.t / (double)6) / (double)10)));
        g.drawString(texto, this.cAncho, g.getFontMetrics().getHeight() + this.cAlto / 2);
        g.setFont(oldFont);
    }

    void termometro(Graphics g, int orgXtermo, int orgYtermo, double temp) {
        int x1 = orgXtermo + (int)(temp * this.escTermo);
        g.setColor(Color.red);
        g.fillRect(orgXtermo - this.cAncho, orgYtermo - this.cAncho, x1 - orgXtermo + this.cAncho, this.cAncho);
        g.setColor(Color.black);
        g.drawRect(orgXtermo - this.cAncho, orgYtermo - this.cAncho, 17 * this.cAlto, this.cAncho);
        for (int i = 20; i <= 100; i += 10) {
            x1 = orgXtermo + (int)((double)i * this.escTermo);
            g.drawLine(x1, orgYtermo, x1, orgYtermo + this.cAncho);
            String texto = String.valueOf(i);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, orgYtermo + this.cAncho + this.cAlto);
            if (i == 100) break;
            for (int j = 2; j < 10; j += 2) {
                x1 = orgXtermo + (int)((double)(i + j) * this.escTermo);
                g.drawLine(x1, orgYtermo, x1, orgYtermo + this.cAncho / 2);
            }
        }
    }

    public void paint(Graphics g) {
        this.origenEscalas(g);
        this.dispositivo(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.gBuffer == null || d.width != this.dim.width || d.height != this.dim.height) {
            this.dim = d;
            this.imag = this.createImage(d.width, d.height);
            this.gBuffer = this.imag.getGraphics();
        }
        this.gBuffer.setColor(this.getBackground());
        this.gBuffer.fillRect(0, 0, d.width, d.height);
        this.dispositivo(this.gBuffer);
        g.drawImage(this.imag, 0, 0, null);
    }
}

