/*
 * Decompiled with CFR 0.152.
 */
package ejercicio01;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;

public class MyCanvas
extends Canvas {
    int wAncho;
    int wAlto;
    int cAlto;
    int cAncho;
    int orgX;
    int orgY;
    double escalaX;
    double escalaY;
    double vInicial;
    final int[] angulos = new int[]{10, 20, 30, 40, 50, 60, 70, 80};
    final int NPARTICULAS = this.angulos.length;
    double[] alcance = new double[this.NPARTICULAS];
    Polygon[] pol = new Polygon[this.NPARTICULAS];
    int divisionesX;
    int divisionesY;
    double dx;
    boolean bNuevo = false;

    public MyCanvas() {
        for (int i = 0; i < this.NPARTICULAS; ++i) {
            this.pol[i] = new Polygon();
        }
        this.setBackground(Color.white);
    }

    void origenEscalas(Graphics g) {
        this.wAncho = this.getSize().width;
        this.wAlto = this.getSize().height;
        this.cAlto = g.getFontMetrics().getHeight();
        this.cAncho = g.getFontMetrics().stringWidth("0");
        this.orgY = this.wAlto - 2 * this.cAlto;
        this.orgX = 4 * this.cAncho;
    }

    void setNuevo(double velocidad) {
        this.vInicial = velocidad;
        for (int i = 0; i < this.NPARTICULAS; ++i) {
            this.pol[i].npoints = 0;
            this.alcance[i] = this.vInicial * this.vInicial * Math.sin((double)(2 * this.angulos[i]) * Math.PI / (double)180) / 9.8;
        }
        double maxAlcance = this.vInicial * this.vInicial / 9.8;
        this.divisionesX = (int)(maxAlcance / 50.0) + 1;
        this.escalaX = (double)(this.wAncho - this.orgX - 2 * this.cAncho) / (double)(this.divisionesX * 50);
        double alturaMax = this.vInicial * this.vInicial / 19.6;
        this.divisionesY = (int)(alturaMax / (double)25) + 1;
        this.escalaY = (double)(this.orgY - this.cAncho) / (double)(this.divisionesY * 25);
        this.dx = (double)(this.divisionesX * 50) / (double)(this.wAncho - this.orgX);
        this.bNuevo = true;
        this.repaint();
    }

    void dibujaEjes(Graphics g) {
        String texto;
        g.drawLine(this.orgX, 0, this.orgX, this.wAlto);
        g.drawString("y(m)", this.orgX + this.cAncho, this.cAlto);
        for (int i = 0; i <= this.divisionesY; ++i) {
            int y1 = this.orgY - (int)(this.escalaY * (double)i * (double)25);
            texto = String.valueOf(i * 25);
            g.drawString(texto, this.orgX - g.getFontMetrics().stringWidth(texto) - this.cAncho, y1 + this.cAlto / 2);
            g.drawLine(this.orgX, y1, this.orgX - this.cAncho, y1);
        }
        g.drawString("x(m)", this.wAncho - 3 * this.cAncho, this.orgY);
        g.drawLine(this.orgX, this.orgY, this.wAncho, this.orgY);
        for (int i = 0; i <= this.divisionesX; ++i) {
            int x1 = this.orgX + (int)(this.escalaX * (double)i * (double)50);
            g.drawLine(x1, this.orgY, x1, this.orgY + this.cAncho);
            texto = String.valueOf(i * 50);
            g.drawString(texto, x1 - g.getFontMetrics().stringWidth(texto) / 2, this.orgY + this.cAncho + this.cAlto);
        }
    }

    double posicion(int angulo, double x) {
        double tangente = Math.tan((double)angulo * Math.PI / (double)180);
        double y = x * tangente - x * x * (1.0 + tangente * tangente) * 9.8 / ((double)2 * this.vInicial * this.vInicial);
        return y;
    }

    public void trayectorias(Graphics g) {
        for (int i = 0; i < this.NPARTICULAS; ++i) {
            for (double x = 0.0; x < this.alcance[i]; x += this.dx) {
                int x1 = this.orgX + (int)(this.escalaX * x);
                int y1 = this.orgY - (int)(this.escalaY * this.posicion(this.angulos[i], x));
                this.pol[i].addPoint(x1, y1);
            }
        }
        g.setColor(Color.red);
        for (int i = 0; i < this.NPARTICULAS; ++i) {
            g.drawPolyline(this.pol[i].xpoints, this.pol[i].ypoints, this.pol[i].npoints);
        }
        for (int i = 0; i < this.NPARTICULAS; ++i) {
            String texto = String.valueOf(String.valueOf(String.valueOf(this.angulos[i])).concat(String.valueOf("-->"))).concat(String.valueOf(String.valueOf((double)Math.round((double)10 * this.alcance[i]) / (double)10)));
            g.drawString(texto, this.wAncho - 10 * this.cAncho, (i + 2) * this.cAlto);
        }
        g.setColor(Color.black);
        g.drawString("\u00e1ngulo/alcance", this.wAncho - 12 * this.cAncho, this.cAlto);
    }

    public void paint(Graphics g) {
        this.origenEscalas(g);
        this.dibujaEjes(g);
        if (this.bNuevo) {
            this.trayectorias(g);
        }
    }
}

